/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.Comment;
import software.amazon.awssdk.services.codecommit.model.CommentsCopier;
import software.amazon.awssdk.services.codecommit.model.Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommentsForComparedCommit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommentsForComparedCommit> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(CommentsForComparedCommit.getter(CommentsForComparedCommit::repositoryName)).setter(CommentsForComparedCommit.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> BEFORE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("beforeCommitId").getter(CommentsForComparedCommit.getter(CommentsForComparedCommit::beforeCommitId)).setter(CommentsForComparedCommit.setter(Builder::beforeCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitId").build()}).build();
    private static final SdkField<String> AFTER_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterCommitId").getter(CommentsForComparedCommit.getter(CommentsForComparedCommit::afterCommitId)).setter(CommentsForComparedCommit.setter(Builder::afterCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitId").build()}).build();
    private static final SdkField<String> BEFORE_BLOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("beforeBlobId").getter(CommentsForComparedCommit.getter(CommentsForComparedCommit::beforeBlobId)).setter(CommentsForComparedCommit.setter(Builder::beforeBlobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeBlobId").build()}).build();
    private static final SdkField<String> AFTER_BLOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterBlobId").getter(CommentsForComparedCommit.getter(CommentsForComparedCommit::afterBlobId)).setter(CommentsForComparedCommit.setter(Builder::afterBlobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterBlobId").build()}).build();
    private static final SdkField<Location> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(CommentsForComparedCommit.getter(CommentsForComparedCommit::location)).setter(CommentsForComparedCommit.setter(Builder::location)).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<List<Comment>> COMMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("comments").getter(CommentsForComparedCommit.getter(CommentsForComparedCommit::comments)).setter(CommentsForComparedCommit.setter(Builder::comments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Comment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, BEFORE_COMMIT_ID_FIELD, AFTER_COMMIT_ID_FIELD, BEFORE_BLOB_ID_FIELD, AFTER_BLOB_ID_FIELD, LOCATION_FIELD, COMMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final String beforeCommitId;
    private final String afterCommitId;
    private final String beforeBlobId;
    private final String afterBlobId;
    private final Location location;
    private final List<Comment> comments;

    private CommentsForComparedCommit(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.beforeCommitId = builder.beforeCommitId;
        this.afterCommitId = builder.afterCommitId;
        this.beforeBlobId = builder.beforeBlobId;
        this.afterBlobId = builder.afterBlobId;
        this.location = builder.location;
        this.comments = builder.comments;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String beforeCommitId() {
        return this.beforeCommitId;
    }

    public final String afterCommitId() {
        return this.afterCommitId;
    }

    public final String beforeBlobId() {
        return this.beforeBlobId;
    }

    public final String afterBlobId() {
        return this.afterBlobId;
    }

    public final Location location() {
        return this.location;
    }

    public final boolean hasComments() {
        return this.comments != null && !(this.comments instanceof SdkAutoConstructList);
    }

    public final List<Comment> comments() {
        return this.comments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeBlobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterBlobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComments() ? this.comments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommentsForComparedCommit)) {
            return false;
        }
        CommentsForComparedCommit other = (CommentsForComparedCommit)obj;
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.beforeCommitId(), other.beforeCommitId()) && Objects.equals(this.afterCommitId(), other.afterCommitId()) && Objects.equals(this.beforeBlobId(), other.beforeBlobId()) && Objects.equals(this.afterBlobId(), other.afterBlobId()) && Objects.equals(this.location(), other.location()) && this.hasComments() == other.hasComments() && Objects.equals(this.comments(), other.comments());
    }

    public final String toString() {
        return ToString.builder((String)"CommentsForComparedCommit").add("RepositoryName", (Object)this.repositoryName()).add("BeforeCommitId", (Object)this.beforeCommitId()).add("AfterCommitId", (Object)this.afterCommitId()).add("BeforeBlobId", (Object)this.beforeBlobId()).add("AfterBlobId", (Object)this.afterBlobId()).add("Location", (Object)this.location()).add("Comments", this.hasComments() ? this.comments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "beforeCommitId": {
                return Optional.ofNullable(clazz.cast(this.beforeCommitId()));
            }
            case "afterCommitId": {
                return Optional.ofNullable(clazz.cast(this.afterCommitId()));
            }
            case "beforeBlobId": {
                return Optional.ofNullable(clazz.cast(this.beforeBlobId()));
            }
            case "afterBlobId": {
                return Optional.ofNullable(clazz.cast(this.afterBlobId()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "comments": {
                return Optional.ofNullable(clazz.cast(this.comments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CommentsForComparedCommit, T> g) {
        return obj -> g.apply((CommentsForComparedCommit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryName;
        private String beforeCommitId;
        private String afterCommitId;
        private String beforeBlobId;
        private String afterBlobId;
        private Location location;
        private List<Comment> comments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CommentsForComparedCommit model) {
            this.repositoryName(model.repositoryName);
            this.beforeCommitId(model.beforeCommitId);
            this.afterCommitId(model.afterCommitId);
            this.beforeBlobId(model.beforeBlobId);
            this.afterBlobId(model.afterBlobId);
            this.location(model.location);
            this.comments(model.comments);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getBeforeCommitId() {
            return this.beforeCommitId;
        }

        @Override
        public final Builder beforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
            return this;
        }

        public final void setBeforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
        }

        public final String getAfterCommitId() {
            return this.afterCommitId;
        }

        @Override
        public final Builder afterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
            return this;
        }

        public final void setAfterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
        }

        public final String getBeforeBlobId() {
            return this.beforeBlobId;
        }

        @Override
        public final Builder beforeBlobId(String beforeBlobId) {
            this.beforeBlobId = beforeBlobId;
            return this;
        }

        public final void setBeforeBlobId(String beforeBlobId) {
            this.beforeBlobId = beforeBlobId;
        }

        public final String getAfterBlobId() {
            return this.afterBlobId;
        }

        @Override
        public final Builder afterBlobId(String afterBlobId) {
            this.afterBlobId = afterBlobId;
            return this;
        }

        public final void setAfterBlobId(String afterBlobId) {
            this.afterBlobId = afterBlobId;
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final List<Comment.Builder> getComments() {
            List<Comment.Builder> result = CommentsCopier.copyToBuilder(this.comments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder comments(Collection<Comment> comments) {
            this.comments = CommentsCopier.copy(comments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Comment ... comments) {
            this.comments(Arrays.asList(comments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder comments(Consumer<Comment.Builder> ... comments) {
            this.comments(Stream.of(comments).map(c -> (Comment)((Comment.Builder)Comment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComments(Collection<Comment.BuilderImpl> comments) {
            this.comments = CommentsCopier.copyFromBuilder(comments);
        }

        public CommentsForComparedCommit build() {
            return new CommentsForComparedCommit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommentsForComparedCommit> {
        public Builder repositoryName(String var1);

        public Builder beforeCommitId(String var1);

        public Builder afterCommitId(String var1);

        public Builder beforeBlobId(String var1);

        public Builder afterBlobId(String var1);

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().applyMutation(location)).build());
        }

        public Builder comments(Collection<Comment> var1);

        public Builder comments(Comment ... var1);

        public Builder comments(Consumer<Comment.Builder> ... var1);
    }
}

