/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFileResponse extends CodeCommitResponse implements
        ToCopyableBuilder<PutFileResponse.Builder, PutFileResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitId").getter(getter(PutFileResponse::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final SdkField<String> BLOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("blobId")
            .getter(getter(PutFileResponse::blobId)).setter(setter(Builder::blobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()).build();

    private static final SdkField<String> TREE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("treeId")
            .getter(getter(PutFileResponse::treeId)).setter(setter(Builder::treeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD,
            BLOB_ID_FIELD, TREE_ID_FIELD));

    private final String commitId;

    private final String blobId;

    private final String treeId;

    private PutFileResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.blobId = builder.blobId;
        this.treeId = builder.treeId;
    }

    /**
     * <p>
     * The full SHA ID of the commit that contains this file change.
     * </p>
     * 
     * @return The full SHA ID of the commit that contains this file change.
     */
    public final String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The ID of the blob, which is its SHA-1 pointer.
     * </p>
     * 
     * @return The ID of the blob, which is its SHA-1 pointer.
     */
    public final String blobId() {
        return blobId;
    }

    /**
     * <p>
     * The full SHA-1 pointer of the tree information for the commit that contains this file change.
     * </p>
     * 
     * @return The full SHA-1 pointer of the tree information for the commit that contains this file change.
     */
    public final String treeId() {
        return treeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(blobId());
        hashCode = 31 * hashCode + Objects.hashCode(treeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFileResponse)) {
            return false;
        }
        PutFileResponse other = (PutFileResponse) obj;
        return Objects.equals(commitId(), other.commitId()) && Objects.equals(blobId(), other.blobId())
                && Objects.equals(treeId(), other.treeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFileResponse").add("CommitId", commitId()).add("BlobId", blobId()).add("TreeId", treeId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "blobId":
            return Optional.ofNullable(clazz.cast(blobId()));
        case "treeId":
            return Optional.ofNullable(clazz.cast(treeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutFileResponse, T> g) {
        return obj -> g.apply((PutFileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutFileResponse> {
        /**
         * <p>
         * The full SHA ID of the commit that contains this file change.
         * </p>
         * 
         * @param commitId
         *        The full SHA ID of the commit that contains this file change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The ID of the blob, which is its SHA-1 pointer.
         * </p>
         * 
         * @param blobId
         *        The ID of the blob, which is its SHA-1 pointer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blobId(String blobId);

        /**
         * <p>
         * The full SHA-1 pointer of the tree information for the commit that contains this file change.
         * </p>
         * 
         * @param treeId
         *        The full SHA-1 pointer of the tree information for the commit that contains this file change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeId(String treeId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String commitId;

        private String blobId;

        private String treeId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFileResponse model) {
            super(model);
            commitId(model.commitId);
            blobId(model.blobId);
            treeId(model.treeId);
        }

        public final String getCommitId() {
            return commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public final String getBlobId() {
            return blobId;
        }

        @Override
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        public final String getTreeId() {
            return treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        @Override
        public PutFileResponse build() {
            return new PutFileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
