/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an update to the source branch of a pull request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PullRequestSourceReferenceUpdatedEventMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<PullRequestSourceReferenceUpdatedEventMetadata.Builder, PullRequestSourceReferenceUpdatedEventMetadata> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(PullRequestSourceReferenceUpdatedEventMetadata::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> BEFORE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("beforeCommitId").getter(getter(PullRequestSourceReferenceUpdatedEventMetadata::beforeCommitId))
            .setter(setter(Builder::beforeCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitId").build()).build();

    private static final SdkField<String> AFTER_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("afterCommitId").getter(getter(PullRequestSourceReferenceUpdatedEventMetadata::afterCommitId))
            .setter(setter(Builder::afterCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitId").build()).build();

    private static final SdkField<String> MERGE_BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeBase").getter(getter(PullRequestSourceReferenceUpdatedEventMetadata::mergeBase))
            .setter(setter(Builder::mergeBase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeBase").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            BEFORE_COMMIT_ID_FIELD, AFTER_COMMIT_ID_FIELD, MERGE_BASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryName;

    private final String beforeCommitId;

    private final String afterCommitId;

    private final String mergeBase;

    private PullRequestSourceReferenceUpdatedEventMetadata(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.beforeCommitId = builder.beforeCommitId;
        this.afterCommitId = builder.afterCommitId;
        this.mergeBase = builder.mergeBase;
    }

    /**
     * <p>
     * The name of the repository where the pull request was updated.
     * </p>
     * 
     * @return The name of the repository where the pull request was updated.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull
     * request was updated.
     * </p>
     * 
     * @return The full commit ID of the commit in the destination branch that was the tip of the branch at the time the
     *         pull request was updated.
     */
    public final String beforeCommitId() {
        return beforeCommitId;
    }

    /**
     * <p>
     * The full commit ID of the commit in the source branch that was the tip of the branch at the time the pull request
     * was updated.
     * </p>
     * 
     * @return The full commit ID of the commit in the source branch that was the tip of the branch at the time the pull
     *         request was updated.
     */
    public final String afterCommitId() {
        return afterCommitId;
    }

    /**
     * <p>
     * The commit ID of the most recent commit that the source branch and the destination branch have in common.
     * </p>
     * 
     * @return The commit ID of the most recent commit that the source branch and the destination branch have in common.
     */
    public final String mergeBase() {
        return mergeBase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(beforeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(afterCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(mergeBase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestSourceReferenceUpdatedEventMetadata)) {
            return false;
        }
        PullRequestSourceReferenceUpdatedEventMetadata other = (PullRequestSourceReferenceUpdatedEventMetadata) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(beforeCommitId(), other.beforeCommitId())
                && Objects.equals(afterCommitId(), other.afterCommitId()) && Objects.equals(mergeBase(), other.mergeBase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PullRequestSourceReferenceUpdatedEventMetadata").add("RepositoryName", repositoryName())
                .add("BeforeCommitId", beforeCommitId()).add("AfterCommitId", afterCommitId()).add("MergeBase", mergeBase())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "beforeCommitId":
            return Optional.ofNullable(clazz.cast(beforeCommitId()));
        case "afterCommitId":
            return Optional.ofNullable(clazz.cast(afterCommitId()));
        case "mergeBase":
            return Optional.ofNullable(clazz.cast(mergeBase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PullRequestSourceReferenceUpdatedEventMetadata, T> g) {
        return obj -> g.apply((PullRequestSourceReferenceUpdatedEventMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PullRequestSourceReferenceUpdatedEventMetadata> {
        /**
         * <p>
         * The name of the repository where the pull request was updated.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where the pull request was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The full commit ID of the commit in the destination branch that was the tip of the branch at the time the
         * pull request was updated.
         * </p>
         * 
         * @param beforeCommitId
         *        The full commit ID of the commit in the destination branch that was the tip of the branch at the time
         *        the pull request was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeCommitId(String beforeCommitId);

        /**
         * <p>
         * The full commit ID of the commit in the source branch that was the tip of the branch at the time the pull
         * request was updated.
         * </p>
         * 
         * @param afterCommitId
         *        The full commit ID of the commit in the source branch that was the tip of the branch at the time the
         *        pull request was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterCommitId(String afterCommitId);

        /**
         * <p>
         * The commit ID of the most recent commit that the source branch and the destination branch have in common.
         * </p>
         * 
         * @param mergeBase
         *        The commit ID of the most recent commit that the source branch and the destination branch have in
         *        common.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeBase(String mergeBase);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryName;

        private String beforeCommitId;

        private String afterCommitId;

        private String mergeBase;

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestSourceReferenceUpdatedEventMetadata model) {
            repositoryName(model.repositoryName);
            beforeCommitId(model.beforeCommitId);
            afterCommitId(model.afterCommitId);
            mergeBase(model.mergeBase);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getBeforeCommitId() {
            return beforeCommitId;
        }

        @Override
        public final Builder beforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
            return this;
        }

        public final void setBeforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
        }

        public final String getAfterCommitId() {
            return afterCommitId;
        }

        @Override
        public final Builder afterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
            return this;
        }

        public final void setAfterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
        }

        public final String getMergeBase() {
            return mergeBase;
        }

        @Override
        public final Builder mergeBase(String mergeBase) {
            this.mergeBase = mergeBase;
            return this;
        }

        public final void setMergeBase(String mergeBase) {
            this.mergeBase = mergeBase;
        }

        @Override
        public PullRequestSourceReferenceUpdatedEventMetadata build() {
            return new PullRequestSourceReferenceUpdatedEventMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
