/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostCommentReplyRequest extends CodeCommitRequest implements
        ToCopyableBuilder<PostCommentReplyRequest.Builder, PostCommentReplyRequest> {
    private static final SdkField<String> IN_REPLY_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inReplyTo").getter(getter(PostCommentReplyRequest::inReplyTo)).setter(setter(Builder::inReplyTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inReplyTo").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(PostCommentReplyRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(PostCommentReplyRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IN_REPLY_TO_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, CONTENT_FIELD));

    private final String inReplyTo;

    private final String clientRequestToken;

    private final String content;

    private PostCommentReplyRequest(BuilderImpl builder) {
        super(builder);
        this.inReplyTo = builder.inReplyTo;
        this.clientRequestToken = builder.clientRequestToken;
        this.content = builder.content;
    }

    /**
     * <p>
     * The system-generated ID of the comment to which you want to reply. To get this ID, use
     * <a>GetCommentsForComparedCommit</a> or <a>GetCommentsForPullRequest</a>.
     * </p>
     * 
     * @return The system-generated ID of the comment to which you want to reply. To get this ID, use
     *         <a>GetCommentsForComparedCommit</a> or <a>GetCommentsForPullRequest</a>.
     */
    public final String inReplyTo() {
        return inReplyTo;
    }

    /**
     * <p>
     * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be
     * repeated with a changed parameter. If a request is received with the same parameters and a token is included, the
     * request returns information about the initial request that used that token.
     * </p>
     * 
     * @return A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The contents of your reply to a comment.
     * </p>
     * 
     * @return The contents of your reply to a comment.
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inReplyTo());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostCommentReplyRequest)) {
            return false;
        }
        PostCommentReplyRequest other = (PostCommentReplyRequest) obj;
        return Objects.equals(inReplyTo(), other.inReplyTo()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostCommentReplyRequest").add("InReplyTo", inReplyTo())
                .add("ClientRequestToken", clientRequestToken()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inReplyTo":
            return Optional.ofNullable(clazz.cast(inReplyTo()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostCommentReplyRequest, T> g) {
        return obj -> g.apply((PostCommentReplyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, PostCommentReplyRequest> {
        /**
         * <p>
         * The system-generated ID of the comment to which you want to reply. To get this ID, use
         * <a>GetCommentsForComparedCommit</a> or <a>GetCommentsForPullRequest</a>.
         * </p>
         * 
         * @param inReplyTo
         *        The system-generated ID of the comment to which you want to reply. To get this ID, use
         *        <a>GetCommentsForComparedCommit</a> or <a>GetCommentsForPullRequest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inReplyTo(String inReplyTo);

        /**
         * <p>
         * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be
         * repeated with a changed parameter. If a request is received with the same parameters and a token is included,
         * the request returns information about the initial request that used that token.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, client-generated idempotency token that, when provided in a request, ensures the request
         *        cannot be repeated with a changed parameter. If a request is received with the same parameters and a
         *        token is included, the request returns information about the initial request that used that token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The contents of your reply to a comment.
         * </p>
         * 
         * @param content
         *        The contents of your reply to a comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String inReplyTo;

        private String clientRequestToken;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(PostCommentReplyRequest model) {
            super(model);
            inReplyTo(model.inReplyTo);
            clientRequestToken(model.clientRequestToken);
            content(model.content);
        }

        public final String getInReplyTo() {
            return inReplyTo;
        }

        @Override
        public final Builder inReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
            return this;
        }

        public final void setInReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostCommentReplyRequest build() {
            return new PostCommentReplyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
