/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFolderRequest extends CodeCommitRequest implements
        ToCopyableBuilder<GetFolderRequest.Builder, GetFolderRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(GetFolderRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> COMMIT_SPECIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitSpecifier").getter(getter(GetFolderRequest::commitSpecifier))
            .setter(setter(Builder::commitSpecifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitSpecifier").build()).build();

    private static final SdkField<String> FOLDER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("folderPath").getter(getter(GetFolderRequest::folderPath)).setter(setter(Builder::folderPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("folderPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            COMMIT_SPECIFIER_FIELD, FOLDER_PATH_FIELD));

    private final String repositoryName;

    private final String commitSpecifier;

    private final String folderPath;

    private GetFolderRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.commitSpecifier = builder.commitSpecifier;
        this.folderPath = builder.folderPath;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * A fully qualified reference used to identify a commit that contains the version of the folder's content to
     * return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no
     * specifier is provided, the folder content is returned as it exists in the HEAD commit.
     * </p>
     * 
     * @return A fully qualified reference used to identify a commit that contains the version of the folder's content
     *         to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD.
     *         If no specifier is provided, the folder content is returned as it exists in the HEAD commit.
     */
    public final String commitSpecifier() {
        return commitSpecifier;
    }

    /**
     * <p>
     * The fully qualified path to the folder whose contents are returned, including the folder name. For example,
     * /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/) of
     * a repository.
     * </p>
     * 
     * @return The fully qualified path to the folder whose contents are returned, including the folder name. For
     *         example, /examples is a fully-qualified path to a folder named examples that was created off of the root
     *         directory (/) of a repository.
     */
    public final String folderPath() {
        return folderPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(commitSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(folderPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderRequest)) {
            return false;
        }
        GetFolderRequest other = (GetFolderRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(commitSpecifier(), other.commitSpecifier()) && Objects.equals(folderPath(), other.folderPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFolderRequest").add("RepositoryName", repositoryName())
                .add("CommitSpecifier", commitSpecifier()).add("FolderPath", folderPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "commitSpecifier":
            return Optional.ofNullable(clazz.cast(commitSpecifier()));
        case "folderPath":
            return Optional.ofNullable(clazz.cast(folderPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFolderRequest, T> g) {
        return obj -> g.apply((GetFolderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetFolderRequest> {
        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * A fully qualified reference used to identify a commit that contains the version of the folder's content to
         * return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no
         * specifier is provided, the folder content is returned as it exists in the HEAD commit.
         * </p>
         * 
         * @param commitSpecifier
         *        A fully qualified reference used to identify a commit that contains the version of the folder's
         *        content to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such
         *        as HEAD. If no specifier is provided, the folder content is returned as it exists in the HEAD commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitSpecifier(String commitSpecifier);

        /**
         * <p>
         * The fully qualified path to the folder whose contents are returned, including the folder name. For example,
         * /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/)
         * of a repository.
         * </p>
         * 
         * @param folderPath
         *        The fully qualified path to the folder whose contents are returned, including the folder name. For
         *        example, /examples is a fully-qualified path to a folder named examples that was created off of the
         *        root directory (/) of a repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderPath(String folderPath);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private String commitSpecifier;

        private String folderPath;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            commitSpecifier(model.commitSpecifier);
            folderPath(model.folderPath);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getCommitSpecifier() {
            return commitSpecifier;
        }

        @Override
        public final Builder commitSpecifier(String commitSpecifier) {
            this.commitSpecifier = commitSpecifier;
            return this;
        }

        public final void setCommitSpecifier(String commitSpecifier) {
            this.commitSpecifier = commitSpecifier;
        }

        public final String getFolderPath() {
            return folderPath;
        }

        @Override
        public final Builder folderPath(String folderPath) {
            this.folderPath = folderPath;
            return this;
        }

        public final void setFolderPath(String folderPath) {
            this.folderPath = folderPath;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFolderRequest build() {
            return new GetFolderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
