/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the metadata for a conflict in a merge operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ConflictMetadata.Builder, ConflictMetadata> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(ConflictMetadata::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<FileSizes> FILE_SIZES_FIELD = SdkField.<FileSizes> builder(MarshallingType.SDK_POJO)
            .memberName("fileSizes").getter(getter(ConflictMetadata::fileSizes)).setter(setter(Builder::fileSizes))
            .constructor(FileSizes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSizes").build()).build();

    private static final SdkField<FileModes> FILE_MODES_FIELD = SdkField.<FileModes> builder(MarshallingType.SDK_POJO)
            .memberName("fileModes").getter(getter(ConflictMetadata::fileModes)).setter(setter(Builder::fileModes))
            .constructor(FileModes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileModes").build()).build();

    private static final SdkField<ObjectTypes> OBJECT_TYPES_FIELD = SdkField.<ObjectTypes> builder(MarshallingType.SDK_POJO)
            .memberName("objectTypes").getter(getter(ConflictMetadata::objectTypes)).setter(setter(Builder::objectTypes))
            .constructor(ObjectTypes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectTypes").build()).build();

    private static final SdkField<Integer> NUMBER_OF_CONFLICTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfConflicts").getter(getter(ConflictMetadata::numberOfConflicts))
            .setter(setter(Builder::numberOfConflicts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfConflicts").build()).build();

    private static final SdkField<IsBinaryFile> IS_BINARY_FILE_FIELD = SdkField.<IsBinaryFile> builder(MarshallingType.SDK_POJO)
            .memberName("isBinaryFile").getter(getter(ConflictMetadata::isBinaryFile)).setter(setter(Builder::isBinaryFile))
            .constructor(IsBinaryFile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isBinaryFile").build()).build();

    private static final SdkField<Boolean> CONTENT_CONFLICT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("contentConflict").getter(getter(ConflictMetadata::contentConflict))
            .setter(setter(Builder::contentConflict))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentConflict").build()).build();

    private static final SdkField<Boolean> FILE_MODE_CONFLICT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("fileModeConflict").getter(getter(ConflictMetadata::fileModeConflict))
            .setter(setter(Builder::fileModeConflict))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileModeConflict").build()).build();

    private static final SdkField<Boolean> OBJECT_TYPE_CONFLICT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("objectTypeConflict").getter(getter(ConflictMetadata::objectTypeConflict))
            .setter(setter(Builder::objectTypeConflict))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectTypeConflict").build())
            .build();

    private static final SdkField<MergeOperations> MERGE_OPERATIONS_FIELD = SdkField
            .<MergeOperations> builder(MarshallingType.SDK_POJO).memberName("mergeOperations")
            .getter(getter(ConflictMetadata::mergeOperations)).setter(setter(Builder::mergeOperations))
            .constructor(MergeOperations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOperations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD,
            FILE_SIZES_FIELD, FILE_MODES_FIELD, OBJECT_TYPES_FIELD, NUMBER_OF_CONFLICTS_FIELD, IS_BINARY_FILE_FIELD,
            CONTENT_CONFLICT_FIELD, FILE_MODE_CONFLICT_FIELD, OBJECT_TYPE_CONFLICT_FIELD, MERGE_OPERATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String filePath;

    private final FileSizes fileSizes;

    private final FileModes fileModes;

    private final ObjectTypes objectTypes;

    private final Integer numberOfConflicts;

    private final IsBinaryFile isBinaryFile;

    private final Boolean contentConflict;

    private final Boolean fileModeConflict;

    private final Boolean objectTypeConflict;

    private final MergeOperations mergeOperations;

    private ConflictMetadata(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.fileSizes = builder.fileSizes;
        this.fileModes = builder.fileModes;
        this.objectTypes = builder.objectTypes;
        this.numberOfConflicts = builder.numberOfConflicts;
        this.isBinaryFile = builder.isBinaryFile;
        this.contentConflict = builder.contentConflict;
        this.fileModeConflict = builder.fileModeConflict;
        this.objectTypeConflict = builder.objectTypeConflict;
        this.mergeOperations = builder.mergeOperations;
    }

    /**
     * <p>
     * The path of the file that contains conflicts.
     * </p>
     * 
     * @return The path of the file that contains conflicts.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The file sizes of the file in the source, destination, and base of the merge.
     * </p>
     * 
     * @return The file sizes of the file in the source, destination, and base of the merge.
     */
    public final FileSizes fileSizes() {
        return fileSizes;
    }

    /**
     * <p>
     * The file modes of the file in the source, destination, and base of the merge.
     * </p>
     * 
     * @return The file modes of the file in the source, destination, and base of the merge.
     */
    public final FileModes fileModes() {
        return fileModes;
    }

    /**
     * <p>
     * Information about any object type conflicts in a merge operation.
     * </p>
     * 
     * @return Information about any object type conflicts in a merge operation.
     */
    public final ObjectTypes objectTypes() {
        return objectTypes;
    }

    /**
     * <p>
     * The number of conflicts, including both hunk conflicts and metadata conflicts.
     * </p>
     * 
     * @return The number of conflicts, including both hunk conflicts and metadata conflicts.
     */
    public final Integer numberOfConflicts() {
        return numberOfConflicts;
    }

    /**
     * <p>
     * A boolean value (true or false) indicating whether the file is binary or textual in the source, destination, and
     * base of the merge.
     * </p>
     * 
     * @return A boolean value (true or false) indicating whether the file is binary or textual in the source,
     *         destination, and base of the merge.
     */
    public final IsBinaryFile isBinaryFile() {
        return isBinaryFile;
    }

    /**
     * <p>
     * A boolean value indicating whether there are conflicts in the content of a file.
     * </p>
     * 
     * @return A boolean value indicating whether there are conflicts in the content of a file.
     */
    public final Boolean contentConflict() {
        return contentConflict;
    }

    /**
     * <p>
     * A boolean value indicating whether there are conflicts in the file mode of a file.
     * </p>
     * 
     * @return A boolean value indicating whether there are conflicts in the file mode of a file.
     */
    public final Boolean fileModeConflict() {
        return fileModeConflict;
    }

    /**
     * <p>
     * A boolean value (true or false) indicating whether there are conflicts between the branches in the object type of
     * a file, folder, or submodule.
     * </p>
     * 
     * @return A boolean value (true or false) indicating whether there are conflicts between the branches in the object
     *         type of a file, folder, or submodule.
     */
    public final Boolean objectTypeConflict() {
        return objectTypeConflict;
    }

    /**
     * <p>
     * Whether an add, modify, or delete operation caused the conflict between the source and destination of the merge.
     * </p>
     * 
     * @return Whether an add, modify, or delete operation caused the conflict between the source and destination of the
     *         merge.
     */
    public final MergeOperations mergeOperations() {
        return mergeOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(fileSizes());
        hashCode = 31 * hashCode + Objects.hashCode(fileModes());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypes());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfConflicts());
        hashCode = 31 * hashCode + Objects.hashCode(isBinaryFile());
        hashCode = 31 * hashCode + Objects.hashCode(contentConflict());
        hashCode = 31 * hashCode + Objects.hashCode(fileModeConflict());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeConflict());
        hashCode = 31 * hashCode + Objects.hashCode(mergeOperations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictMetadata)) {
            return false;
        }
        ConflictMetadata other = (ConflictMetadata) obj;
        return Objects.equals(filePath(), other.filePath()) && Objects.equals(fileSizes(), other.fileSizes())
                && Objects.equals(fileModes(), other.fileModes()) && Objects.equals(objectTypes(), other.objectTypes())
                && Objects.equals(numberOfConflicts(), other.numberOfConflicts())
                && Objects.equals(isBinaryFile(), other.isBinaryFile())
                && Objects.equals(contentConflict(), other.contentConflict())
                && Objects.equals(fileModeConflict(), other.fileModeConflict())
                && Objects.equals(objectTypeConflict(), other.objectTypeConflict())
                && Objects.equals(mergeOperations(), other.mergeOperations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConflictMetadata").add("FilePath", filePath()).add("FileSizes", fileSizes())
                .add("FileModes", fileModes()).add("ObjectTypes", objectTypes()).add("NumberOfConflicts", numberOfConflicts())
                .add("IsBinaryFile", isBinaryFile()).add("ContentConflict", contentConflict())
                .add("FileModeConflict", fileModeConflict()).add("ObjectTypeConflict", objectTypeConflict())
                .add("MergeOperations", mergeOperations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "fileSizes":
            return Optional.ofNullable(clazz.cast(fileSizes()));
        case "fileModes":
            return Optional.ofNullable(clazz.cast(fileModes()));
        case "objectTypes":
            return Optional.ofNullable(clazz.cast(objectTypes()));
        case "numberOfConflicts":
            return Optional.ofNullable(clazz.cast(numberOfConflicts()));
        case "isBinaryFile":
            return Optional.ofNullable(clazz.cast(isBinaryFile()));
        case "contentConflict":
            return Optional.ofNullable(clazz.cast(contentConflict()));
        case "fileModeConflict":
            return Optional.ofNullable(clazz.cast(fileModeConflict()));
        case "objectTypeConflict":
            return Optional.ofNullable(clazz.cast(objectTypeConflict()));
        case "mergeOperations":
            return Optional.ofNullable(clazz.cast(mergeOperations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictMetadata, T> g) {
        return obj -> g.apply((ConflictMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictMetadata> {
        /**
         * <p>
         * The path of the file that contains conflicts.
         * </p>
         * 
         * @param filePath
         *        The path of the file that contains conflicts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The file sizes of the file in the source, destination, and base of the merge.
         * </p>
         * 
         * @param fileSizes
         *        The file sizes of the file in the source, destination, and base of the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSizes(FileSizes fileSizes);

        /**
         * <p>
         * The file sizes of the file in the source, destination, and base of the merge.
         * </p>
         * This is a convenience that creates an instance of the {@link FileSizes.Builder} avoiding the need to create
         * one manually via {@link FileSizes#builder()}.
         *
         * When the {@link Consumer} completes, {@link FileSizes.Builder#build()} is called immediately and its result
         * is passed to {@link #fileSizes(FileSizes)}.
         * 
         * @param fileSizes
         *        a consumer that will call methods on {@link FileSizes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSizes(FileSizes)
         */
        default Builder fileSizes(Consumer<FileSizes.Builder> fileSizes) {
            return fileSizes(FileSizes.builder().applyMutation(fileSizes).build());
        }

        /**
         * <p>
         * The file modes of the file in the source, destination, and base of the merge.
         * </p>
         * 
         * @param fileModes
         *        The file modes of the file in the source, destination, and base of the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileModes(FileModes fileModes);

        /**
         * <p>
         * The file modes of the file in the source, destination, and base of the merge.
         * </p>
         * This is a convenience that creates an instance of the {@link FileModes.Builder} avoiding the need to create
         * one manually via {@link FileModes#builder()}.
         *
         * When the {@link Consumer} completes, {@link FileModes.Builder#build()} is called immediately and its result
         * is passed to {@link #fileModes(FileModes)}.
         * 
         * @param fileModes
         *        a consumer that will call methods on {@link FileModes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileModes(FileModes)
         */
        default Builder fileModes(Consumer<FileModes.Builder> fileModes) {
            return fileModes(FileModes.builder().applyMutation(fileModes).build());
        }

        /**
         * <p>
         * Information about any object type conflicts in a merge operation.
         * </p>
         * 
         * @param objectTypes
         *        Information about any object type conflicts in a merge operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypes(ObjectTypes objectTypes);

        /**
         * <p>
         * Information about any object type conflicts in a merge operation.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectTypes.Builder} avoiding the need to create
         * one manually via {@link ObjectTypes#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectTypes.Builder#build()} is called immediately and its result
         * is passed to {@link #objectTypes(ObjectTypes)}.
         * 
         * @param objectTypes
         *        a consumer that will call methods on {@link ObjectTypes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectTypes(ObjectTypes)
         */
        default Builder objectTypes(Consumer<ObjectTypes.Builder> objectTypes) {
            return objectTypes(ObjectTypes.builder().applyMutation(objectTypes).build());
        }

        /**
         * <p>
         * The number of conflicts, including both hunk conflicts and metadata conflicts.
         * </p>
         * 
         * @param numberOfConflicts
         *        The number of conflicts, including both hunk conflicts and metadata conflicts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfConflicts(Integer numberOfConflicts);

        /**
         * <p>
         * A boolean value (true or false) indicating whether the file is binary or textual in the source, destination,
         * and base of the merge.
         * </p>
         * 
         * @param isBinaryFile
         *        A boolean value (true or false) indicating whether the file is binary or textual in the source,
         *        destination, and base of the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isBinaryFile(IsBinaryFile isBinaryFile);

        /**
         * <p>
         * A boolean value (true or false) indicating whether the file is binary or textual in the source, destination,
         * and base of the merge.
         * </p>
         * This is a convenience that creates an instance of the {@link IsBinaryFile.Builder} avoiding the need to
         * create one manually via {@link IsBinaryFile#builder()}.
         *
         * When the {@link Consumer} completes, {@link IsBinaryFile.Builder#build()} is called immediately and its
         * result is passed to {@link #isBinaryFile(IsBinaryFile)}.
         * 
         * @param isBinaryFile
         *        a consumer that will call methods on {@link IsBinaryFile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #isBinaryFile(IsBinaryFile)
         */
        default Builder isBinaryFile(Consumer<IsBinaryFile.Builder> isBinaryFile) {
            return isBinaryFile(IsBinaryFile.builder().applyMutation(isBinaryFile).build());
        }

        /**
         * <p>
         * A boolean value indicating whether there are conflicts in the content of a file.
         * </p>
         * 
         * @param contentConflict
         *        A boolean value indicating whether there are conflicts in the content of a file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentConflict(Boolean contentConflict);

        /**
         * <p>
         * A boolean value indicating whether there are conflicts in the file mode of a file.
         * </p>
         * 
         * @param fileModeConflict
         *        A boolean value indicating whether there are conflicts in the file mode of a file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileModeConflict(Boolean fileModeConflict);

        /**
         * <p>
         * A boolean value (true or false) indicating whether there are conflicts between the branches in the object
         * type of a file, folder, or submodule.
         * </p>
         * 
         * @param objectTypeConflict
         *        A boolean value (true or false) indicating whether there are conflicts between the branches in the
         *        object type of a file, folder, or submodule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeConflict(Boolean objectTypeConflict);

        /**
         * <p>
         * Whether an add, modify, or delete operation caused the conflict between the source and destination of the
         * merge.
         * </p>
         * 
         * @param mergeOperations
         *        Whether an add, modify, or delete operation caused the conflict between the source and destination of
         *        the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeOperations(MergeOperations mergeOperations);

        /**
         * <p>
         * Whether an add, modify, or delete operation caused the conflict between the source and destination of the
         * merge.
         * </p>
         * This is a convenience that creates an instance of the {@link MergeOperations.Builder} avoiding the need to
         * create one manually via {@link MergeOperations#builder()}.
         *
         * When the {@link Consumer} completes, {@link MergeOperations.Builder#build()} is called immediately and its
         * result is passed to {@link #mergeOperations(MergeOperations)}.
         * 
         * @param mergeOperations
         *        a consumer that will call methods on {@link MergeOperations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mergeOperations(MergeOperations)
         */
        default Builder mergeOperations(Consumer<MergeOperations.Builder> mergeOperations) {
            return mergeOperations(MergeOperations.builder().applyMutation(mergeOperations).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filePath;

        private FileSizes fileSizes;

        private FileModes fileModes;

        private ObjectTypes objectTypes;

        private Integer numberOfConflicts;

        private IsBinaryFile isBinaryFile;

        private Boolean contentConflict;

        private Boolean fileModeConflict;

        private Boolean objectTypeConflict;

        private MergeOperations mergeOperations;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictMetadata model) {
            filePath(model.filePath);
            fileSizes(model.fileSizes);
            fileModes(model.fileModes);
            objectTypes(model.objectTypes);
            numberOfConflicts(model.numberOfConflicts);
            isBinaryFile(model.isBinaryFile);
            contentConflict(model.contentConflict);
            fileModeConflict(model.fileModeConflict);
            objectTypeConflict(model.objectTypeConflict);
            mergeOperations(model.mergeOperations);
        }

        public final String getFilePath() {
            return filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public final FileSizes.Builder getFileSizes() {
            return fileSizes != null ? fileSizes.toBuilder() : null;
        }

        @Override
        public final Builder fileSizes(FileSizes fileSizes) {
            this.fileSizes = fileSizes;
            return this;
        }

        public final void setFileSizes(FileSizes.BuilderImpl fileSizes) {
            this.fileSizes = fileSizes != null ? fileSizes.build() : null;
        }

        public final FileModes.Builder getFileModes() {
            return fileModes != null ? fileModes.toBuilder() : null;
        }

        @Override
        public final Builder fileModes(FileModes fileModes) {
            this.fileModes = fileModes;
            return this;
        }

        public final void setFileModes(FileModes.BuilderImpl fileModes) {
            this.fileModes = fileModes != null ? fileModes.build() : null;
        }

        public final ObjectTypes.Builder getObjectTypes() {
            return objectTypes != null ? objectTypes.toBuilder() : null;
        }

        @Override
        public final Builder objectTypes(ObjectTypes objectTypes) {
            this.objectTypes = objectTypes;
            return this;
        }

        public final void setObjectTypes(ObjectTypes.BuilderImpl objectTypes) {
            this.objectTypes = objectTypes != null ? objectTypes.build() : null;
        }

        public final Integer getNumberOfConflicts() {
            return numberOfConflicts;
        }

        @Override
        public final Builder numberOfConflicts(Integer numberOfConflicts) {
            this.numberOfConflicts = numberOfConflicts;
            return this;
        }

        public final void setNumberOfConflicts(Integer numberOfConflicts) {
            this.numberOfConflicts = numberOfConflicts;
        }

        public final IsBinaryFile.Builder getIsBinaryFile() {
            return isBinaryFile != null ? isBinaryFile.toBuilder() : null;
        }

        @Override
        public final Builder isBinaryFile(IsBinaryFile isBinaryFile) {
            this.isBinaryFile = isBinaryFile;
            return this;
        }

        public final void setIsBinaryFile(IsBinaryFile.BuilderImpl isBinaryFile) {
            this.isBinaryFile = isBinaryFile != null ? isBinaryFile.build() : null;
        }

        public final Boolean getContentConflict() {
            return contentConflict;
        }

        @Override
        public final Builder contentConflict(Boolean contentConflict) {
            this.contentConflict = contentConflict;
            return this;
        }

        public final void setContentConflict(Boolean contentConflict) {
            this.contentConflict = contentConflict;
        }

        public final Boolean getFileModeConflict() {
            return fileModeConflict;
        }

        @Override
        public final Builder fileModeConflict(Boolean fileModeConflict) {
            this.fileModeConflict = fileModeConflict;
            return this;
        }

        public final void setFileModeConflict(Boolean fileModeConflict) {
            this.fileModeConflict = fileModeConflict;
        }

        public final Boolean getObjectTypeConflict() {
            return objectTypeConflict;
        }

        @Override
        public final Builder objectTypeConflict(Boolean objectTypeConflict) {
            this.objectTypeConflict = objectTypeConflict;
            return this;
        }

        public final void setObjectTypeConflict(Boolean objectTypeConflict) {
            this.objectTypeConflict = objectTypeConflict;
        }

        public final MergeOperations.Builder getMergeOperations() {
            return mergeOperations != null ? mergeOperations.toBuilder() : null;
        }

        @Override
        public final Builder mergeOperations(MergeOperations mergeOperations) {
            this.mergeOperations = mergeOperations;
            return this;
        }

        public final void setMergeOperations(MergeOperations.BuilderImpl mergeOperations) {
            this.mergeOperations = mergeOperations != null ? mergeOperations.build() : null;
        }

        @Override
        public ConflictMetadata build() {
            return new ConflictMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
