/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about a specific comment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Comment implements SdkPojo, Serializable, ToCopyableBuilder<Comment.Builder, Comment> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commentId").getter(getter(Comment::commentId)).setter(setter(Builder::commentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commentId").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(Comment::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> IN_REPLY_TO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inReplyTo").getter(getter(Comment::inReplyTo)).setter(setter(Builder::inReplyTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inReplyTo").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(Comment::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(Comment::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<String> AUTHOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorArn").getter(getter(Comment::authorArn)).setter(setter(Builder::authorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorArn").build()).build();

    private static final SdkField<Boolean> DELETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleted").getter(getter(Comment::deleted)).setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(Comment::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<List<String>> CALLER_REACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("callerReactions")
            .getter(getter(Comment::callerReactions))
            .setter(setter(Builder::callerReactions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callerReactions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, Integer>> REACTION_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("reactionCounts")
            .getter(getter(Comment::reactionCounts))
            .setter(setter(Builder::reactionCounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reactionCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD,
            CONTENT_FIELD, IN_REPLY_TO_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, AUTHOR_ARN_FIELD, DELETED_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, CALLER_REACTIONS_FIELD, REACTION_COUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String commentId;

    private final String content;

    private final String inReplyTo;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final String authorArn;

    private final Boolean deleted;

    private final String clientRequestToken;

    private final List<String> callerReactions;

    private final Map<String, Integer> reactionCounts;

    private Comment(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.content = builder.content;
        this.inReplyTo = builder.inReplyTo;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.authorArn = builder.authorArn;
        this.deleted = builder.deleted;
        this.clientRequestToken = builder.clientRequestToken;
        this.callerReactions = builder.callerReactions;
        this.reactionCounts = builder.reactionCounts;
    }

    /**
     * <p>
     * The system-generated comment ID.
     * </p>
     * 
     * @return The system-generated comment ID.
     */
    public final String commentId() {
        return commentId;
    }

    /**
     * <p>
     * The content of the comment.
     * </p>
     * 
     * @return The content of the comment.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The ID of the comment for which this comment is a reply, if any.
     * </p>
     * 
     * @return The ID of the comment for which this comment is a reply, if any.
     */
    public final String inReplyTo() {
        return inReplyTo;
    }

    /**
     * <p>
     * The date and time the comment was created, in timestamp format.
     * </p>
     * 
     * @return The date and time the comment was created, in timestamp format.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time the comment was most recently modified, in timestamp format.
     * </p>
     * 
     * @return The date and time the comment was most recently modified, in timestamp format.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the person who posted the comment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the person who posted the comment.
     */
    public final String authorArn() {
        return authorArn;
    }

    /**
     * <p>
     * A Boolean value indicating whether the comment has been deleted.
     * </p>
     * 
     * @return A Boolean value indicating whether the comment has been deleted.
     */
    public final Boolean deleted() {
        return deleted;
    }

    /**
     * <p>
     * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be
     * repeated with a changed parameter. If a request is received with the same parameters and a token is included, the
     * request returns information about the initial request that used that token.
     * </p>
     * 
     * @return A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns true if the CallerReactions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCallerReactions() {
        return callerReactions != null && !(callerReactions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the call to
     * the API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCallerReactions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the
     *         call to the API.
     */
    public final List<String> callerReactions() {
        return callerReactions;
    }

    /**
     * Returns true if the ReactionCounts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasReactionCounts() {
        return reactionCounts != null && !(reactionCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A string to integer map that represents the number of individual users who have responded to a comment with the
     * specified reactions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReactionCounts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A string to integer map that represents the number of individual users who have responded to a comment
     *         with the specified reactions.
     */
    public final Map<String, Integer> reactionCounts() {
        return reactionCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commentId());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(inReplyTo());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(authorArn());
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCallerReactions() ? callerReactions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReactionCounts() ? reactionCounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Comment)) {
            return false;
        }
        Comment other = (Comment) obj;
        return Objects.equals(commentId(), other.commentId()) && Objects.equals(content(), other.content())
                && Objects.equals(inReplyTo(), other.inReplyTo()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(authorArn(), other.authorArn())
                && Objects.equals(deleted(), other.deleted()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && hasCallerReactions() == other.hasCallerReactions()
                && Objects.equals(callerReactions(), other.callerReactions()) && hasReactionCounts() == other.hasReactionCounts()
                && Objects.equals(reactionCounts(), other.reactionCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Comment").add("CommentId", commentId()).add("Content", content()).add("InReplyTo", inReplyTo())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate()).add("AuthorArn", authorArn())
                .add("Deleted", deleted()).add("ClientRequestToken", clientRequestToken())
                .add("CallerReactions", hasCallerReactions() ? callerReactions() : null)
                .add("ReactionCounts", hasReactionCounts() ? reactionCounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commentId":
            return Optional.ofNullable(clazz.cast(commentId()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "inReplyTo":
            return Optional.ofNullable(clazz.cast(inReplyTo()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "authorArn":
            return Optional.ofNullable(clazz.cast(authorArn()));
        case "deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "callerReactions":
            return Optional.ofNullable(clazz.cast(callerReactions()));
        case "reactionCounts":
            return Optional.ofNullable(clazz.cast(reactionCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Comment, T> g) {
        return obj -> g.apply((Comment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Comment> {
        /**
         * <p>
         * The system-generated comment ID.
         * </p>
         * 
         * @param commentId
         *        The system-generated comment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentId(String commentId);

        /**
         * <p>
         * The content of the comment.
         * </p>
         * 
         * @param content
         *        The content of the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The ID of the comment for which this comment is a reply, if any.
         * </p>
         * 
         * @param inReplyTo
         *        The ID of the comment for which this comment is a reply, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inReplyTo(String inReplyTo);

        /**
         * <p>
         * The date and time the comment was created, in timestamp format.
         * </p>
         * 
         * @param creationDate
         *        The date and time the comment was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time the comment was most recently modified, in timestamp format.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time the comment was most recently modified, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the person who posted the comment.
         * </p>
         * 
         * @param authorArn
         *        The Amazon Resource Name (ARN) of the person who posted the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorArn(String authorArn);

        /**
         * <p>
         * A Boolean value indicating whether the comment has been deleted.
         * </p>
         * 
         * @param deleted
         *        A Boolean value indicating whether the comment has been deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Boolean deleted);

        /**
         * <p>
         * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be
         * repeated with a changed parameter. If a request is received with the same parameters and a token is included,
         * the request returns information about the initial request that used that token.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, client-generated idempotency token that, when provided in a request, ensures the request
         *        cannot be repeated with a changed parameter. If a request is received with the same parameters and a
         *        token is included, the request returns information about the initial request that used that token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the
         * call to the API.
         * </p>
         * 
         * @param callerReactions
         *        The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with
         *        the call to the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReactions(Collection<String> callerReactions);

        /**
         * <p>
         * The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the
         * call to the API.
         * </p>
         * 
         * @param callerReactions
         *        The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with
         *        the call to the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReactions(String... callerReactions);

        /**
         * <p>
         * A string to integer map that represents the number of individual users who have responded to a comment with
         * the specified reactions.
         * </p>
         * 
         * @param reactionCounts
         *        A string to integer map that represents the number of individual users who have responded to a comment
         *        with the specified reactions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reactionCounts(Map<String, Integer> reactionCounts);
    }

    static final class BuilderImpl implements Builder {
        private String commentId;

        private String content;

        private String inReplyTo;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private String authorArn;

        private Boolean deleted;

        private String clientRequestToken;

        private List<String> callerReactions = DefaultSdkAutoConstructList.getInstance();

        private Map<String, Integer> reactionCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Comment model) {
            commentId(model.commentId);
            content(model.content);
            inReplyTo(model.inReplyTo);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            authorArn(model.authorArn);
            deleted(model.deleted);
            clientRequestToken(model.clientRequestToken);
            callerReactions(model.callerReactions);
            reactionCounts(model.reactionCounts);
        }

        public final String getCommentId() {
            return commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getInReplyTo() {
            return inReplyTo;
        }

        @Override
        public final Builder inReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
            return this;
        }

        public final void setInReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getAuthorArn() {
            return authorArn;
        }

        @Override
        public final Builder authorArn(String authorArn) {
            this.authorArn = authorArn;
            return this;
        }

        public final void setAuthorArn(String authorArn) {
            this.authorArn = authorArn;
        }

        public final Boolean getDeleted() {
            return deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<String> getCallerReactions() {
            if (callerReactions instanceof SdkAutoConstructList) {
                return null;
            }
            return callerReactions;
        }

        @Override
        public final Builder callerReactions(Collection<String> callerReactions) {
            this.callerReactions = CallerReactionsCopier.copy(callerReactions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callerReactions(String... callerReactions) {
            callerReactions(Arrays.asList(callerReactions));
            return this;
        }

        public final void setCallerReactions(Collection<String> callerReactions) {
            this.callerReactions = CallerReactionsCopier.copy(callerReactions);
        }

        public final Map<String, Integer> getReactionCounts() {
            if (reactionCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return reactionCounts;
        }

        @Override
        public final Builder reactionCounts(Map<String, Integer> reactionCounts) {
            this.reactionCounts = ReactionCountsMapCopier.copy(reactionCounts);
            return this;
        }

        public final void setReactionCounts(Map<String, Integer> reactionCounts) {
            this.reactionCounts = ReactionCountsMapCopier.copy(reactionCounts);
        }

        @Override
        public Comment build() {
            return new Comment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
