/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse extends CodeCommitResponse
        implements
        ToCopyableBuilder<BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse.Builder, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> {
    private static final SdkField<List<String>> DISASSOCIATED_REPOSITORY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("disassociatedRepositoryNames")
            .getter(getter(BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse::disassociatedRepositoryNames))
            .setter(setter(Builder::disassociatedRepositoryNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disassociatedRepositoryNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>> ERRORS_FIELD = SdkField
            .<List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(BatchDisassociateApprovalRuleTemplateFromRepositoriesError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DISASSOCIATED_REPOSITORY_NAMES_FIELD, ERRORS_FIELD));

    private final List<String> disassociatedRepositoryNames;

    private final List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> errors;

    private BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.disassociatedRepositoryNames = builder.disassociatedRepositoryNames;
        this.errors = builder.errors;
    }

    /**
     * Returns true if the DisassociatedRepositoryNames property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasDisassociatedRepositoryNames() {
        return disassociatedRepositoryNames != null && !(disassociatedRepositoryNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of repository names that have had their association with the template removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDisassociatedRepositoryNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of repository names that have had their association with the template removed.
     */
    public final List<String> disassociatedRepositoryNames() {
        return disassociatedRepositoryNames;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of any errors that might have occurred while attempting to remove the association between the template and
     * the repositories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of any errors that might have occurred while attempting to remove the association between the
     *         template and the repositories.
     */
    public final List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDisassociatedRepositoryNames() ? disassociatedRepositoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse)) {
            return false;
        }
        BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse other = (BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse) obj;
        return hasDisassociatedRepositoryNames() == other.hasDisassociatedRepositoryNames()
                && Objects.equals(disassociatedRepositoryNames(), other.disassociatedRepositoryNames())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse")
                .add("DisassociatedRepositoryNames", hasDisassociatedRepositoryNames() ? disassociatedRepositoryNames() : null)
                .add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "disassociatedRepositoryNames":
            return Optional.ofNullable(clazz.cast(disassociatedRepositoryNames()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse, T> g) {
        return obj -> g.apply((BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> {
        /**
         * <p>
         * A list of repository names that have had their association with the template removed.
         * </p>
         * 
         * @param disassociatedRepositoryNames
         *        A list of repository names that have had their association with the template removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociatedRepositoryNames(Collection<String> disassociatedRepositoryNames);

        /**
         * <p>
         * A list of repository names that have had their association with the template removed.
         * </p>
         * 
         * @param disassociatedRepositoryNames
         *        A list of repository names that have had their association with the template removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociatedRepositoryNames(String... disassociatedRepositoryNames);

        /**
         * <p>
         * A list of any errors that might have occurred while attempting to remove the association between the template
         * and the repositories.
         * </p>
         * 
         * @param errors
         *        A list of any errors that might have occurred while attempting to remove the association between the
         *        template and the repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> errors);

        /**
         * <p>
         * A list of any errors that might have occurred while attempting to remove the association between the template
         * and the repositories.
         * </p>
         * 
         * @param errors
         *        A list of any errors that might have occurred while attempting to remove the association between the
         *        template and the repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchDisassociateApprovalRuleTemplateFromRepositoriesError... errors);

        /**
         * <p>
         * A list of any errors that might have occurred while attempting to remove the association between the template
         * and the repositories.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <BatchDisassociateApprovalRuleTemplateFromRepositoriesError>.Builder} avoiding the need to create one
         * manually via {@link List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <BatchDisassociateApprovalRuleTemplateFromRepositoriesError>.Builder#build()} is called immediately and its
         * result is passed to {@link #errors(List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List
         *        <BatchDisassociateApprovalRuleTemplateFromRepositoriesError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>)
         */
        Builder errors(Consumer<BatchDisassociateApprovalRuleTemplateFromRepositoriesError.Builder>... errors);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<String> disassociatedRepositoryNames = DefaultSdkAutoConstructList.getInstance();

        private List<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> errors = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse model) {
            super(model);
            disassociatedRepositoryNames(model.disassociatedRepositoryNames);
            errors(model.errors);
        }

        public final Collection<String> getDisassociatedRepositoryNames() {
            if (disassociatedRepositoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return disassociatedRepositoryNames;
        }

        @Override
        public final Builder disassociatedRepositoryNames(Collection<String> disassociatedRepositoryNames) {
            this.disassociatedRepositoryNames = RepositoryNameListCopier.copy(disassociatedRepositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disassociatedRepositoryNames(String... disassociatedRepositoryNames) {
            disassociatedRepositoryNames(Arrays.asList(disassociatedRepositoryNames));
            return this;
        }

        public final void setDisassociatedRepositoryNames(Collection<String> disassociatedRepositoryNames) {
            this.disassociatedRepositoryNames = RepositoryNameListCopier.copy(disassociatedRepositoryNames);
        }

        public final Collection<BatchDisassociateApprovalRuleTemplateFromRepositoriesError.Builder> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors != null ? errors.stream().map(BatchDisassociateApprovalRuleTemplateFromRepositoriesError::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<BatchDisassociateApprovalRuleTemplateFromRepositoriesError> errors) {
            this.errors = BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDisassociateApprovalRuleTemplateFromRepositoriesError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDisassociateApprovalRuleTemplateFromRepositoriesError.Builder>... errors) {
            errors(Stream.of(errors)
                    .map(c -> BatchDisassociateApprovalRuleTemplateFromRepositoriesError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<BatchDisassociateApprovalRuleTemplateFromRepositoriesError.BuilderImpl> errors) {
            this.errors = BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse build() {
            return new BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
