/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.CreateBranchRequest;
import software.amazon.awssdk.services.codecommit.model.CreateBranchResponse;
import software.amazon.awssdk.services.codecommit.model.CreateCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateCommitResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteFileRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteFileResponse;
import software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleRequest;
import software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse;
import software.amazon.awssdk.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesRequest;
import software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse;
import software.amazon.awssdk.services.codecommit.model.GetApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.GetApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.GetBlobRequest;
import software.amazon.awssdk.services.codecommit.model.GetBlobResponse;
import software.amazon.awssdk.services.codecommit.model.GetBranchRequest;
import software.amazon.awssdk.services.codecommit.model.GetBranchResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse;
import software.amazon.awssdk.services.codecommit.model.GetFileRequest;
import software.amazon.awssdk.services.codecommit.model.GetFileResponse;
import software.amazon.awssdk.services.codecommit.model.GetFolderRequest;
import software.amazon.awssdk.services.codecommit.model.GetFolderResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse;
import software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.ListBranchesRequest;
import software.amazon.awssdk.services.codecommit.model.ListBranchesResponse;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesRequest;
import software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyResponse;
import software.amazon.awssdk.services.codecommit.model.PutCommentReactionRequest;
import software.amazon.awssdk.services.codecommit.model.PutCommentReactionResponse;
import software.amazon.awssdk.services.codecommit.model.PutFileRequest;
import software.amazon.awssdk.services.codecommit.model.PutFileResponse;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.TagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.TagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.UntagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.UntagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameResponse;
import software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentReactionsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetDifferencesPublisher;
import software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListApprovalRuleTemplatesPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListAssociatedApprovalRuleTemplatesForRepositoryPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListBranchesPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsPublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesForApprovalRuleTemplatePublisher;
import software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher;

/**
 * Service client for accessing CodeCommit asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>AWS CodeCommit</fullname>
 * <p>
 * This is the <i>AWS CodeCommit API Reference</i>. This reference provides descriptions of the operations and data
 * types for AWS CodeCommit API along with usage examples.
 * </p>
 * <p>
 * You can use the AWS CodeCommit API to work with the following objects:
 * </p>
 * <p>
 * Repositories, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>BatchGetRepositories</a>, which returns information about one or more repositories associated with your AWS
 * account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateRepository</a>, which creates an AWS CodeCommit repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteRepository</a>, which deletes an AWS CodeCommit repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetRepository</a>, which returns information about a specified repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListRepositories</a>, which lists all AWS CodeCommit repositories associated with your AWS account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateRepositoryDescription</a>, which sets or updates the description of the repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateRepositoryName</a>, which changes the name of the repository. If you change the name of a repository, no
 * other users of that repository can access it until you send them the new HTTPS or SSH URL to use.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Branches, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreateBranch</a>, which creates a branch in a specified repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteBranch</a>, which deletes the specified branch in a repository unless it is the default branch.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetBranch</a>, which returns information about a specified branch.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListBranches</a>, which lists all branches for a specified repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateDefaultBranch</a>, which changes the default branch for a repository.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Files, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DeleteFile</a>, which deletes the content of a specified file from a specified branch.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetBlob</a>, which returns the base-64 encoded content of an individual Git blob object in a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetFile</a>, which returns the base-64 encoded content of a specified file.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetFolder</a>, which returns the contents of a specified folder or directory.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PutFile</a>, which adds or modifies a single file in a specified repository and branch.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Commits, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>BatchGetCommits</a>, which returns information about one or more commits in a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateCommit</a>, which creates a commit for changes to a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetCommit</a>, which returns information about a commit, including commit messages and author and committer
 * information.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetDifferences</a>, which returns information about the differences in a valid commit specifier (such as a branch,
 * tag, HEAD, commit ID, or other fully qualified reference).
 * </p>
 * </li>
 * </ul>
 * <p>
 * Merges, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>BatchDescribeMergeConflicts</a>, which returns information about conflicts in a merge between commits in a
 * repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateUnreferencedMergeCommit</a>, which creates an unreferenced commit between two branches or commits for the
 * purpose of comparing them and identifying any potential conflicts.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribeMergeConflicts</a>, which returns information about merge conflicts between the base, source, and
 * destination versions of a file in a potential merge.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetMergeCommit</a>, which returns information about the merge between a source and destination commit.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetMergeConflicts</a>, which returns information about merge conflicts between the source and destination branch
 * in a pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetMergeOptions</a>, which returns information about the available merge options between two branches or commit
 * specifiers.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>MergeBranchesByFastForward</a>, which merges two branches using the fast-forward merge option.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>MergeBranchesBySquash</a>, which merges two branches using the squash merge option.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>MergeBranchesByThreeWay</a>, which merges two branches using the three-way merge option.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Pull requests, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>CreatePullRequest</a>, which creates a pull request in a specified repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreatePullRequestApprovalRule</a>, which creates an approval rule for a specified pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeletePullRequestApprovalRule</a>, which deletes an approval rule for a specified pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DescribePullRequestEvents</a>, which returns information about one or more pull request events.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>EvaluatePullRequestApprovalRules</a>, which evaluates whether a pull request has met all the conditions specified
 * in its associated approval rules.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetCommentsForPullRequest</a>, which returns information about comments on a specified pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetPullRequest</a>, which returns information about a specified pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetPullRequestApprovalStates</a>, which returns information about the approval states for a specified pull
 * request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetPullRequestOverrideState</a>, which returns information about whether approval rules have been set aside
 * (overriden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the
 * rules and their requirements for the pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListPullRequests</a>, which lists all pull requests for a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>MergePullRequestByFastForward</a>, which merges the source destination branch of a pull request into the specified
 * destination branch for that pull request using the fast-forward merge option.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>MergePullRequestBySquash</a>, which merges the source destination branch of a pull request into the specified
 * destination branch for that pull request using the squash merge option.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>MergePullRequestByThreeWay</a>. which merges the source destination branch of a pull request into the specified
 * destination branch for that pull request using the three-way merge option.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>OverridePullRequestApprovalRules</a>, which sets aside all approval rule requirements for a pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PostCommentForPullRequest</a>, which posts a comment to a pull request at the specified line, file, or request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdatePullRequestApprovalRuleContent</a>, which updates the structure of an approval rule for a pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdatePullRequestApprovalState</a>, which updates the state of an approval on a pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdatePullRequestDescription</a>, which updates the description of a pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdatePullRequestStatus</a>, which updates the status of a pull request.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdatePullRequestTitle</a>, which updates the title of a pull request.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Approval rule templates, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>AssociateApprovalRuleTemplateWithRepository</a>, which associates a template with a specified repository. After
 * the template is associated with a repository, AWS CodeCommit creates approval rules that match the template
 * conditions on every pull request created in the specified repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>BatchAssociateApprovalRuleTemplateWithRepositories</a>, which associates a template with one or more specified
 * repositories. After the template is associated with a repository, AWS CodeCommit creates approval rules that match
 * the template conditions on every pull request created in the specified repositories.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>BatchDisassociateApprovalRuleTemplateFromRepositories</a>, which removes the association between a template and
 * specified repositories so that approval rules based on the template are not automatically created when pull requests
 * are created in those repositories.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>CreateApprovalRuleTemplate</a>, which creates a template for approval rules that can then be associated with one
 * or more repositories in your AWS account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DeleteApprovalRuleTemplate</a>, which deletes the specified template. It does not remove approval rules on pull
 * requests already created with the template.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>DisassociateApprovalRuleTemplateFromRepository</a>, which removes the association between a template and a
 * repository so that approval rules based on the template are not automatically created when pull requests are created
 * in the specified repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetApprovalRuleTemplate</a>, which returns information about an approval rule template.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListApprovalRuleTemplates</a>, which lists all approval rule templates in the AWS Region in your AWS account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListAssociatedApprovalRuleTemplatesForRepository</a>, which lists all approval rule templates that are associated
 * with a specified repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>ListRepositoriesForApprovalRuleTemplate</a>, which lists all repositories associated with the specified approval
 * rule template.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateApprovalRuleTemplateDescription</a>, which updates the description of an approval rule template.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateApprovalRuleTemplateName</a>, which updates the name of an approval rule template.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateApprovalRuleTemplateContent</a>, which updates the content of an approval rule template.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Comments in a repository, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>DeleteCommentContent</a>, which deletes the content of a comment on a commit in a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetComment</a>, which returns information about a comment on a commit.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetCommentReactions</a>, which returns information about emoji reactions to comments.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GetCommentsForComparedCommit</a>, which returns information about comments on the comparison between two commit
 * specifiers in a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PostCommentForComparedCommit</a>, which creates a comment on the comparison between two commit specifiers in a
 * repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PostCommentReply</a>, which creates a reply to a comment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PutCommentReaction</a>, which creates or updates an emoji reaction to a comment.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateComment</a>, which updates the content of a comment on a commit in a repository.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Tags used to tag resources in AWS CodeCommit (not Git tags), by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ListTagsForResource</a>, which gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS
 * CodeCommit.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>TagResource</a>, which adds or updates tags for a resource in AWS CodeCommit.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UntagResource</a>, which removes tags for a resource in AWS CodeCommit.
 * </p>
 * </li>
 * </ul>
 * <p>
 * Triggers, by calling the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>GetRepositoryTriggers</a>, which returns information about triggers configured for a repository.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>PutRepositoryTriggers</a>, which replaces all triggers for a repository and can be used to create or delete
 * triggers.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>TestRepositoryTriggers</a>, which tests the functionality of a repository trigger by sending data to the trigger
 * target.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For information about how to use AWS CodeCommit, see the <a
 * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CodeCommitAsyncClient extends SdkClient {
    String SERVICE_NAME = "codecommit";

    /**
     * Create a {@link CodeCommitAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeCommitAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeCommitAsyncClient}.
     */
    static CodeCommitAsyncClientBuilder builder() {
        return new DefaultCodeCommitAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates an association between an approval rule template and a specified repository. Then, the next time a pull
     * request is created in the repository where the destination reference (if specified) matches the destination
     * reference (branch) for the pull request, an approval rule that matches the template conditions is automatically
     * created for that pull request. If no destination references are specified in the template, an approval rule that
     * matches the template contents is created for all pull requests in that repository.
     * </p>
     *
     * @param associateApprovalRuleTemplateWithRepositoryRequest
     * @return A Java Future containing the result of the AssociateApprovalRuleTemplateWithRepository operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>MaximumRuleTemplatesAssociatedWithRepositoryException The maximum number of approval rule templates
     *         for a repository has been exceeded. You cannot associate more than 25 approval rule templates with a
     *         repository.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.AssociateApprovalRuleTemplateWithRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/AssociateApprovalRuleTemplateWithRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateApprovalRuleTemplateWithRepositoryResponse> associateApprovalRuleTemplateWithRepository(
            AssociateApprovalRuleTemplateWithRepositoryRequest associateApprovalRuleTemplateWithRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between an approval rule template and a specified repository. Then, the next time a pull
     * request is created in the repository where the destination reference (if specified) matches the destination
     * reference (branch) for the pull request, an approval rule that matches the template conditions is automatically
     * created for that pull request. If no destination references are specified in the template, an approval rule that
     * matches the template contents is created for all pull requests in that repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateApprovalRuleTemplateWithRepositoryRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateApprovalRuleTemplateWithRepositoryRequest#builder()}
     * </p>
     *
     * @param associateApprovalRuleTemplateWithRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link AssociateApprovalRuleTemplateWithRepositoryInput.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateApprovalRuleTemplateWithRepository operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>MaximumRuleTemplatesAssociatedWithRepositoryException The maximum number of approval rule templates
     *         for a repository has been exceeded. You cannot associate more than 25 approval rule templates with a
     *         repository.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.AssociateApprovalRuleTemplateWithRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/AssociateApprovalRuleTemplateWithRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateApprovalRuleTemplateWithRepositoryResponse> associateApprovalRuleTemplateWithRepository(
            Consumer<AssociateApprovalRuleTemplateWithRepositoryRequest.Builder> associateApprovalRuleTemplateWithRepositoryRequest) {
        return associateApprovalRuleTemplateWithRepository(AssociateApprovalRuleTemplateWithRepositoryRequest.builder()
                .applyMutation(associateApprovalRuleTemplateWithRepositoryRequest).build());
    }

    /**
     * <p>
     * Creates an association between an approval rule template and one or more specified repositories.
     * </p>
     *
     * @param batchAssociateApprovalRuleTemplateWithRepositoriesRequest
     * @return A Java Future containing the result of the BatchAssociateApprovalRuleTemplateWithRepositories operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>RepositoryNamesRequiredException At least one repository name object is required, but was not
     *         specified.</li>
     *         <li>MaximumRepositoryNamesExceededException The maximum number of allowed repository names was exceeded.
     *         Currently, this number is 100.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchAssociateApprovalRuleTemplateWithRepositories
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchAssociateApprovalRuleTemplateWithRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> batchAssociateApprovalRuleTemplateWithRepositories(
            BatchAssociateApprovalRuleTemplateWithRepositoriesRequest batchAssociateApprovalRuleTemplateWithRepositoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between an approval rule template and one or more specified repositories.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.Builder} avoiding the need to create one
     * manually via {@link BatchAssociateApprovalRuleTemplateWithRepositoriesRequest#builder()}
     * </p>
     *
     * @param batchAssociateApprovalRuleTemplateWithRepositoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link BatchAssociateApprovalRuleTemplateWithRepositoriesInput.Builder} to create a request.
     * @return A Java Future containing the result of the BatchAssociateApprovalRuleTemplateWithRepositories operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>RepositoryNamesRequiredException At least one repository name object is required, but was not
     *         specified.</li>
     *         <li>MaximumRepositoryNamesExceededException The maximum number of allowed repository names was exceeded.
     *         Currently, this number is 100.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchAssociateApprovalRuleTemplateWithRepositories
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchAssociateApprovalRuleTemplateWithRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> batchAssociateApprovalRuleTemplateWithRepositories(
            Consumer<BatchAssociateApprovalRuleTemplateWithRepositoriesRequest.Builder> batchAssociateApprovalRuleTemplateWithRepositoriesRequest) {
        return batchAssociateApprovalRuleTemplateWithRepositories(BatchAssociateApprovalRuleTemplateWithRepositoriesRequest
                .builder().applyMutation(batchAssociateApprovalRuleTemplateWithRepositoriesRequest).build());
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy.
     * </p>
     *
     * @param batchDescribeMergeConflictsRequest
     * @return A Java Future containing the result of the BatchDescribeMergeConflicts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidMaxConflictFilesException The specified value for the number of conflict files to return is
     *         not valid.</li>
     *         <li>InvalidMaxMergeHunksException The specified value for the number of merge hunks to return is not
     *         valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchDescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchDescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeMergeConflictsResponse> batchDescribeMergeConflicts(
            BatchDescribeMergeConflictsRequest batchDescribeMergeConflictsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDescribeMergeConflictsRequest.Builder}
     * avoiding the need to create one manually via {@link BatchDescribeMergeConflictsRequest#builder()}
     * </p>
     *
     * @param batchDescribeMergeConflictsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDescribeMergeConflictsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDescribeMergeConflicts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidMaxConflictFilesException The specified value for the number of conflict files to return is
     *         not valid.</li>
     *         <li>InvalidMaxMergeHunksException The specified value for the number of merge hunks to return is not
     *         valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchDescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchDescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeMergeConflictsResponse> batchDescribeMergeConflicts(
            Consumer<BatchDescribeMergeConflictsRequest.Builder> batchDescribeMergeConflictsRequest) {
        return batchDescribeMergeConflicts(BatchDescribeMergeConflictsRequest.builder()
                .applyMutation(batchDescribeMergeConflictsRequest).build());
    }

    /**
     * <p>
     * Removes the association between an approval rule template and one or more specified repositories.
     * </p>
     *
     * @param batchDisassociateApprovalRuleTemplateFromRepositoriesRequest
     * @return A Java Future containing the result of the BatchDisassociateApprovalRuleTemplateFromRepositories
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>RepositoryNamesRequiredException At least one repository name object is required, but was not
     *         specified.</li>
     *         <li>MaximumRepositoryNamesExceededException The maximum number of allowed repository names was exceeded.
     *         Currently, this number is 100.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchDisassociateApprovalRuleTemplateFromRepositories
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchDisassociateApprovalRuleTemplateFromRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> batchDisassociateApprovalRuleTemplateFromRepositories(
            BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest batchDisassociateApprovalRuleTemplateFromRepositoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between an approval rule template and one or more specified repositories.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest.Builder} avoiding the need to create one
     * manually via {@link BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest#builder()}
     * </p>
     *
     * @param batchDisassociateApprovalRuleTemplateFromRepositoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link BatchDisassociateApprovalRuleTemplateFromRepositoriesInput.Builder} to create a request.
     * @return A Java Future containing the result of the BatchDisassociateApprovalRuleTemplateFromRepositories
     *         operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>RepositoryNamesRequiredException At least one repository name object is required, but was not
     *         specified.</li>
     *         <li>MaximumRepositoryNamesExceededException The maximum number of allowed repository names was exceeded.
     *         Currently, this number is 100.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchDisassociateApprovalRuleTemplateFromRepositories
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchDisassociateApprovalRuleTemplateFromRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> batchDisassociateApprovalRuleTemplateFromRepositories(
            Consumer<BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest.Builder> batchDisassociateApprovalRuleTemplateFromRepositoriesRequest) {
        return batchDisassociateApprovalRuleTemplateFromRepositories(BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest
                .builder().applyMutation(batchDisassociateApprovalRuleTemplateFromRepositoriesRequest).build());
    }

    /**
     * <p>
     * Returns information about the contents of one or more commits in a repository.
     * </p>
     *
     * @param batchGetCommitsRequest
     * @return A Java Future containing the result of the BatchGetCommits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommitIdsListRequiredException A list of commit IDs is required, but was either not specified or the
     *         list was empty.</li>
     *         <li>CommitIdsLimitExceededException The maximum number of allowed commit IDs in a batch request is 100.
     *         Verify that your batch requests contains no more than 100 commit IDs, and then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchGetCommits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetCommits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetCommitsResponse> batchGetCommits(BatchGetCommitsRequest batchGetCommitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the contents of one or more commits in a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetCommitsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetCommitsRequest#builder()}
     * </p>
     *
     * @param batchGetCommitsRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetCommitsInput.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetCommits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommitIdsListRequiredException A list of commit IDs is required, but was either not specified or the
     *         list was empty.</li>
     *         <li>CommitIdsLimitExceededException The maximum number of allowed commit IDs in a batch request is 100.
     *         Verify that your batch requests contains no more than 100 commit IDs, and then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchGetCommits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetCommits" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchGetCommitsResponse> batchGetCommits(
            Consumer<BatchGetCommitsRequest.Builder> batchGetCommitsRequest) {
        return batchGetCommits(BatchGetCommitsRequest.builder().applyMutation(batchGetCommitsRequest).build());
    }

    /**
     * <p>
     * Returns information about one or more repositories.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a webpage.
     * </p>
     * </note>
     *
     * @param batchGetRepositoriesRequest
     *        Represents the input of a batch get repositories operation.
     * @return A Java Future containing the result of the BatchGetRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNamesRequiredException At least one repository name object is required, but was not
     *         specified.</li>
     *         <li>MaximumRepositoryNamesExceededException The maximum number of allowed repository names was exceeded.
     *         Currently, this number is 100.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchGetRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRepositoriesResponse> batchGetRepositories(
            BatchGetRepositoriesRequest batchGetRepositoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about one or more repositories.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a webpage.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetRepositoriesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetRepositoriesRequest#builder()}
     * </p>
     *
     * @param batchGetRepositoriesRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetRepositoriesInput.Builder} to create a
     *        request. Represents the input of a batch get repositories operation.
     * @return A Java Future containing the result of the BatchGetRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNamesRequiredException At least one repository name object is required, but was not
     *         specified.</li>
     *         <li>MaximumRepositoryNamesExceededException The maximum number of allowed repository names was exceeded.
     *         Currently, this number is 100.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.BatchGetRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetRepositoriesResponse> batchGetRepositories(
            Consumer<BatchGetRepositoriesRequest.Builder> batchGetRepositoriesRequest) {
        return batchGetRepositories(BatchGetRepositoriesRequest.builder().applyMutation(batchGetRepositoriesRequest).build());
    }

    /**
     * <p>
     * Creates a template for approval rules that can then be associated with one or more repositories in your AWS
     * account. When you associate a template with a repository, AWS CodeCommit creates an approval rule that matches
     * the conditions of the template for all pull requests that meet the conditions of the template. For more
     * information, see <a>AssociateApprovalRuleTemplateWithRepository</a>.
     * </p>
     *
     * @param createApprovalRuleTemplateRequest
     * @return A Java Future containing the result of the CreateApprovalRuleTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateNameAlreadyExistsException You cannot create an approval rule template with that
     *         name because a template with that name already exists in this AWS Region for your AWS account. Approval
     *         rule template names must be unique.</li>
     *         <li>ApprovalRuleTemplateContentRequiredException The content for the approval rule template is empty. You
     *         must provide some content for an approval rule template. The content cannot be null.</li>
     *         <li>InvalidApprovalRuleTemplateContentException The content of the approval rule template is not valid.</li>
     *         <li>InvalidApprovalRuleTemplateDescriptionException The description for the approval rule template is not
     *         valid because it exceeds the maximum characters allowed for a description. For more information about
     *         limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     *         </li>
     *         <li>NumberOfRuleTemplatesExceededException The maximum number of approval rule templates has been
     *         exceeded for this AWS Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateApprovalRuleTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApprovalRuleTemplateResponse> createApprovalRuleTemplate(
            CreateApprovalRuleTemplateRequest createApprovalRuleTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a template for approval rules that can then be associated with one or more repositories in your AWS
     * account. When you associate a template with a repository, AWS CodeCommit creates an approval rule that matches
     * the conditions of the template for all pull requests that meet the conditions of the template. For more
     * information, see <a>AssociateApprovalRuleTemplateWithRepository</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApprovalRuleTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateApprovalRuleTemplateRequest#builder()}
     * </p>
     *
     * @param createApprovalRuleTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateApprovalRuleTemplateInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateApprovalRuleTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateNameAlreadyExistsException You cannot create an approval rule template with that
     *         name because a template with that name already exists in this AWS Region for your AWS account. Approval
     *         rule template names must be unique.</li>
     *         <li>ApprovalRuleTemplateContentRequiredException The content for the approval rule template is empty. You
     *         must provide some content for an approval rule template. The content cannot be null.</li>
     *         <li>InvalidApprovalRuleTemplateContentException The content of the approval rule template is not valid.</li>
     *         <li>InvalidApprovalRuleTemplateDescriptionException The description for the approval rule template is not
     *         valid because it exceeds the maximum characters allowed for a description. For more information about
     *         limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     *         </li>
     *         <li>NumberOfRuleTemplatesExceededException The maximum number of approval rule templates has been
     *         exceeded for this AWS Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateApprovalRuleTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApprovalRuleTemplateResponse> createApprovalRuleTemplate(
            Consumer<CreateApprovalRuleTemplateRequest.Builder> createApprovalRuleTemplateRequest) {
        return createApprovalRuleTemplate(CreateApprovalRuleTemplateRequest.builder()
                .applyMutation(createApprovalRuleTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a branch in a repository and points the branch to a commit.
     * </p>
     * <note>
     * <p>
     * Calling the create branch operation does not set a repository's default branch. To do this, call the update
     * default branch operation.
     * </p>
     * </note>
     *
     * @param createBranchRequest
     *        Represents the input of a create branch operation.
     * @return A Java Future containing the result of the CreateBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>BranchNameExistsException Cannot create the branch with the specified name because the commit
     *         conflicts with an existing branch with the same name. Branch names must be unique.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBranchResponse> createBranch(CreateBranchRequest createBranchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a branch in a repository and points the branch to a commit.
     * </p>
     * <note>
     * <p>
     * Calling the create branch operation does not set a repository's default branch. To do this, call the update
     * default branch operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBranchRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBranchRequest#builder()}
     * </p>
     *
     * @param createBranchRequest
     *        A {@link Consumer} that will call methods on {@link CreateBranchInput.Builder} to create a request.
     *        Represents the input of a create branch operation.
     * @return A Java Future containing the result of the CreateBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>BranchNameExistsException Cannot create the branch with the specified name because the commit
     *         conflicts with an existing branch with the same name. Branch names must be unique.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBranchResponse> createBranch(Consumer<CreateBranchRequest.Builder> createBranchRequest) {
        return createBranch(CreateBranchRequest.builder().applyMutation(createBranchRequest).build());
    }

    /**
     * <p>
     * Creates a commit for a repository on the tip of a specified branch.
     * </p>
     *
     * @param createCommitRequest
     * @return A Java Future containing the result of the CreateCommit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ParentCommitIdRequiredException A parent commit ID is required. To view the full commit ID of a
     *         branch in a repository, use <a>GetBranch</a> or a Git command (for example, git pull or git log).</li>
     *         <li>InvalidParentCommitIdException The parent commit ID is not valid. The commit ID cannot be empty, and
     *         must match the head commit ID for the branch of the repository where you want to add or update a file.</li>
     *         <li>ParentCommitDoesNotExistException The parent commit ID is not valid because it does not exist. The
     *         specified parent commit ID does not exist in the specified branch of the repository.</li>
     *         <li>ParentCommitIdOutdatedException The file could not be added because the provided parent commit ID is
     *         not the current tip of the specified branch. To view the full commit ID of the current head of the
     *         branch, use <a>GetBranch</a>.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>FileEntryRequiredException The commit cannot be created because no files have been specified as
     *         added, updated, or changed (PutFile or DeleteFile) for the commit.</li>
     *         <li>MaximumFileEntriesExceededException The number of specified files to change as part of this commit
     *         exceeds the maximum number of files that can be changed in a single commit. Consider using a Git client
     *         for these changes.</li>
     *         <li>PutFileEntryConflictException The commit cannot be created because one or more files specified in the
     *         commit reference both a file and a folder.</li>
     *         <li>SourceFileOrContentRequiredException The commit cannot be created because no source files or file
     *         content have been specified for the commit.</li>
     *         <li>FileContentAndSourceFileSpecifiedException The commit cannot be created because both a source file
     *         and file content have been specified for the same file. You cannot provide both. Either specify a source
     *         file or provide the file content directly.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>SamePathRequestException The commit cannot be created because one or more changes in this commit
     *         duplicate actions in the same file path. For example, you cannot make the same delete request to the same
     *         file in the same file path twice, or make a delete request and a move request to the same file as part of
     *         the same commit.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have used the correct
     *         file name, full path, and extension.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>InvalidDeletionParameterException The specified deletion parameter is not valid.</li>
     *         <li>RestrictedSourceFileException The commit cannot be created because one of the changes specifies
     *         copying or moving a .gitkeep file.</li>
     *         <li>FileModeRequiredException The commit cannot be created because no file mode has been specified. A
     *         file mode is required to update mode permissions for a file.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>NoChangeException The commit cannot be created because no changes will be made to the repository as a
     *         result of this commit. A commit must contain at least one change.</li>
     *         <li>FileNameConflictsWithDirectoryNameException A file cannot be added to the repository because the
     *         specified file name has the same name as a directory in this repository. Either provide another name for
     *         the file, or add the file in a directory that does not match the file name.</li>
     *         <li>DirectoryNameConflictsWithFileNameException A file cannot be added to the repository because the
     *         specified path name has the same name as a file that already exists in this repository. Either provide a
     *         different name for the file, or specify a different path for the file.</li>
     *         <li>FilePathConflictsWithSubmodulePathException The commit cannot be created because a specified file
     *         path points to a submodule. Verify that the destination files have valid file paths that do not point to
     *         a submodule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateCommit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCommitResponse> createCommit(CreateCommitRequest createCommitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a commit for a repository on the tip of a specified branch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCommitRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCommitRequest#builder()}
     * </p>
     *
     * @param createCommitRequest
     *        A {@link Consumer} that will call methods on {@link CreateCommitInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCommit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ParentCommitIdRequiredException A parent commit ID is required. To view the full commit ID of a
     *         branch in a repository, use <a>GetBranch</a> or a Git command (for example, git pull or git log).</li>
     *         <li>InvalidParentCommitIdException The parent commit ID is not valid. The commit ID cannot be empty, and
     *         must match the head commit ID for the branch of the repository where you want to add or update a file.</li>
     *         <li>ParentCommitDoesNotExistException The parent commit ID is not valid because it does not exist. The
     *         specified parent commit ID does not exist in the specified branch of the repository.</li>
     *         <li>ParentCommitIdOutdatedException The file could not be added because the provided parent commit ID is
     *         not the current tip of the specified branch. To view the full commit ID of the current head of the
     *         branch, use <a>GetBranch</a>.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>FileEntryRequiredException The commit cannot be created because no files have been specified as
     *         added, updated, or changed (PutFile or DeleteFile) for the commit.</li>
     *         <li>MaximumFileEntriesExceededException The number of specified files to change as part of this commit
     *         exceeds the maximum number of files that can be changed in a single commit. Consider using a Git client
     *         for these changes.</li>
     *         <li>PutFileEntryConflictException The commit cannot be created because one or more files specified in the
     *         commit reference both a file and a folder.</li>
     *         <li>SourceFileOrContentRequiredException The commit cannot be created because no source files or file
     *         content have been specified for the commit.</li>
     *         <li>FileContentAndSourceFileSpecifiedException The commit cannot be created because both a source file
     *         and file content have been specified for the same file. You cannot provide both. Either specify a source
     *         file or provide the file content directly.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>SamePathRequestException The commit cannot be created because one or more changes in this commit
     *         duplicate actions in the same file path. For example, you cannot make the same delete request to the same
     *         file in the same file path twice, or make a delete request and a move request to the same file as part of
     *         the same commit.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have used the correct
     *         file name, full path, and extension.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>InvalidDeletionParameterException The specified deletion parameter is not valid.</li>
     *         <li>RestrictedSourceFileException The commit cannot be created because one of the changes specifies
     *         copying or moving a .gitkeep file.</li>
     *         <li>FileModeRequiredException The commit cannot be created because no file mode has been specified. A
     *         file mode is required to update mode permissions for a file.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>NoChangeException The commit cannot be created because no changes will be made to the repository as a
     *         result of this commit. A commit must contain at least one change.</li>
     *         <li>FileNameConflictsWithDirectoryNameException A file cannot be added to the repository because the
     *         specified file name has the same name as a directory in this repository. Either provide another name for
     *         the file, or add the file in a directory that does not match the file name.</li>
     *         <li>DirectoryNameConflictsWithFileNameException A file cannot be added to the repository because the
     *         specified path name has the same name as a file that already exists in this repository. Either provide a
     *         different name for the file, or specify a different path for the file.</li>
     *         <li>FilePathConflictsWithSubmodulePathException The commit cannot be created because a specified file
     *         path points to a submodule. Verify that the destination files have valid file paths that do not point to
     *         a submodule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateCommit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCommitResponse> createCommit(Consumer<CreateCommitRequest.Builder> createCommitRequest) {
        return createCommit(CreateCommitRequest.builder().applyMutation(createCommitRequest).build());
    }

    /**
     * <p>
     * Creates a pull request in the specified repository.
     * </p>
     *
     * @param createPullRequestRequest
     * @return A Java Future containing the result of the CreatePullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be reused.</li>
     *         <li>ReferenceNameRequiredException A reference name is required, but none was provided.</li>
     *         <li>InvalidReferenceNameException The specified reference name format is not valid. Reference names must
     *         conform to the Git references format (for example, refs/heads/master). For more information, see <a
     *         href="https://git-scm.com/book/en/v2/Git-Internals-Git-References">Git Internals - Git References</a> or
     *         consult your Git documentation.</li>
     *         <li>ReferenceDoesNotExistException The specified reference does not exist. You must provide a full commit
     *         ID.</li>
     *         <li>ReferenceTypeNotSupportedException The specified reference is not a supported type.</li>
     *         <li>TitleRequiredException A pull request title is required. It cannot be empty or null.</li>
     *         <li>InvalidTitleException The title of the pull request is not valid. Pull request titles cannot exceed
     *         100 characters in length.</li>
     *         <li>InvalidDescriptionException The pull request description is not valid. Descriptions cannot be more
     *         than 1,000 characters.</li>
     *         <li>TargetsRequiredException An array of target objects is required. It cannot be empty or null.</li>
     *         <li>InvalidTargetsException The targets for the pull request is not valid or not in a valid format.
     *         Targets are a list of target objects. Each target object must contain the full values for the repository
     *         name, source branch, and destination branch for a pull request.</li>
     *         <li>TargetRequiredException A pull request target is required. It cannot be empty or null. A pull request
     *         target must contain the full values for the repository name, source branch, and destination branch for
     *         the pull request.</li>
     *         <li>InvalidTargetException The target for the pull request is not valid. A target must contain the full
     *         values for the repository name, source branch, and destination branch for the pull request.</li>
     *         <li>MultipleRepositoriesInPullRequestException You cannot include more than one repository in a pull
     *         request. Make sure you have specified only one repository name in your request, and then try again.</li>
     *         <li>MaximumOpenPullRequestsExceededException You cannot create the pull request because the repository
     *         has too many open pull requests. The maximum number of open pull requests for a repository is 1,000.
     *         Close one or more open pull requests, and then try again.</li>
     *         <li>SourceAndDestinationAreSameException The source branch and destination branch for the pull request
     *         are the same. You must specify different branches for the source and destination.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreatePullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequest" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePullRequestResponse> createPullRequest(CreatePullRequestRequest createPullRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pull request in the specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePullRequestRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePullRequestRequest#builder()}
     * </p>
     *
     * @param createPullRequestRequest
     *        A {@link Consumer} that will call methods on {@link CreatePullRequestInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be reused.</li>
     *         <li>ReferenceNameRequiredException A reference name is required, but none was provided.</li>
     *         <li>InvalidReferenceNameException The specified reference name format is not valid. Reference names must
     *         conform to the Git references format (for example, refs/heads/master). For more information, see <a
     *         href="https://git-scm.com/book/en/v2/Git-Internals-Git-References">Git Internals - Git References</a> or
     *         consult your Git documentation.</li>
     *         <li>ReferenceDoesNotExistException The specified reference does not exist. You must provide a full commit
     *         ID.</li>
     *         <li>ReferenceTypeNotSupportedException The specified reference is not a supported type.</li>
     *         <li>TitleRequiredException A pull request title is required. It cannot be empty or null.</li>
     *         <li>InvalidTitleException The title of the pull request is not valid. Pull request titles cannot exceed
     *         100 characters in length.</li>
     *         <li>InvalidDescriptionException The pull request description is not valid. Descriptions cannot be more
     *         than 1,000 characters.</li>
     *         <li>TargetsRequiredException An array of target objects is required. It cannot be empty or null.</li>
     *         <li>InvalidTargetsException The targets for the pull request is not valid or not in a valid format.
     *         Targets are a list of target objects. Each target object must contain the full values for the repository
     *         name, source branch, and destination branch for a pull request.</li>
     *         <li>TargetRequiredException A pull request target is required. It cannot be empty or null. A pull request
     *         target must contain the full values for the repository name, source branch, and destination branch for
     *         the pull request.</li>
     *         <li>InvalidTargetException The target for the pull request is not valid. A target must contain the full
     *         values for the repository name, source branch, and destination branch for the pull request.</li>
     *         <li>MultipleRepositoriesInPullRequestException You cannot include more than one repository in a pull
     *         request. Make sure you have specified only one repository name in your request, and then try again.</li>
     *         <li>MaximumOpenPullRequestsExceededException You cannot create the pull request because the repository
     *         has too many open pull requests. The maximum number of open pull requests for a repository is 1,000.
     *         Close one or more open pull requests, and then try again.</li>
     *         <li>SourceAndDestinationAreSameException The source branch and destination branch for the pull request
     *         are the same. You must specify different branches for the source and destination.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreatePullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequest" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePullRequestResponse> createPullRequest(
            Consumer<CreatePullRequestRequest.Builder> createPullRequestRequest) {
        return createPullRequest(CreatePullRequestRequest.builder().applyMutation(createPullRequestRequest).build());
    }

    /**
     * <p>
     * Creates an approval rule for a pull request.
     * </p>
     *
     * @param createPullRequestApprovalRuleRequest
     * @return A Java Future containing the result of the CreatePullRequestApprovalRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleNameRequiredException An approval rule name is required, but was not specified.</li>
     *         <li>InvalidApprovalRuleNameException The name for the approval rule is not valid.</li>
     *         <li>ApprovalRuleNameAlreadyExistsException An approval rule with that name already exists. Approval rule
     *         names must be unique within the scope of a pull request.</li>
     *         <li>ApprovalRuleContentRequiredException The content for the approval rule is empty. You must provide
     *         some content for an approval rule. The content cannot be null.</li>
     *         <li>InvalidApprovalRuleContentException The content for the approval rule is not valid.</li>
     *         <li>NumberOfRulesExceededException The approval rule cannot be added. The pull request has the maximum
     *         number of approval rules associated with it.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreatePullRequestApprovalRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequestApprovalRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePullRequestApprovalRuleResponse> createPullRequestApprovalRule(
            CreatePullRequestApprovalRuleRequest createPullRequestApprovalRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an approval rule for a pull request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePullRequestApprovalRuleRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePullRequestApprovalRuleRequest#builder()}
     * </p>
     *
     * @param createPullRequestApprovalRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreatePullRequestApprovalRuleInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreatePullRequestApprovalRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleNameRequiredException An approval rule name is required, but was not specified.</li>
     *         <li>InvalidApprovalRuleNameException The name for the approval rule is not valid.</li>
     *         <li>ApprovalRuleNameAlreadyExistsException An approval rule with that name already exists. Approval rule
     *         names must be unique within the scope of a pull request.</li>
     *         <li>ApprovalRuleContentRequiredException The content for the approval rule is empty. You must provide
     *         some content for an approval rule. The content cannot be null.</li>
     *         <li>InvalidApprovalRuleContentException The content for the approval rule is not valid.</li>
     *         <li>NumberOfRulesExceededException The approval rule cannot be added. The pull request has the maximum
     *         number of approval rules associated with it.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreatePullRequestApprovalRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequestApprovalRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePullRequestApprovalRuleResponse> createPullRequestApprovalRule(
            Consumer<CreatePullRequestApprovalRuleRequest.Builder> createPullRequestApprovalRuleRequest) {
        return createPullRequestApprovalRule(CreatePullRequestApprovalRuleRequest.builder()
                .applyMutation(createPullRequestApprovalRuleRequest).build());
    }

    /**
     * <p>
     * Creates a new, empty repository.
     * </p>
     *
     * @param createRepositoryRequest
     *        Represents the input of a create repository operation.
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameExistsException The specified repository name already exists.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidRepositoryDescriptionException The specified repository description is not valid.</li>
     *         <li>RepositoryLimitExceededException A repository resource limit was exceeded.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>InvalidTagsMapException The map of tags is not valid.</li>
     *         <li>TooManyTagsException The maximum number of tags for an AWS CodeCommit resource has been exceeded.</li>
     *         <li>InvalidSystemTagUsageException The specified tag is not valid. Key names cannot be prefixed with
     *         aws:.</li>
     *         <li>TagPolicyException The tag policy is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest createRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new, empty repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRepositoryRequest#builder()}
     * </p>
     *
     * @param createRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link CreateRepositoryInput.Builder} to create a request.
     *        Represents the input of a create repository operation.
     * @return A Java Future containing the result of the CreateRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameExistsException The specified repository name already exists.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidRepositoryDescriptionException The specified repository description is not valid.</li>
     *         <li>RepositoryLimitExceededException A repository resource limit was exceeded.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>InvalidTagsMapException The map of tags is not valid.</li>
     *         <li>TooManyTagsException The maximum number of tags for an AWS CodeCommit resource has been exceeded.</li>
     *         <li>InvalidSystemTagUsageException The specified tag is not valid. Key names cannot be prefixed with
     *         aws:.</li>
     *         <li>TagPolicyException The tag policy is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateRepositoryResponse> createRepository(
            Consumer<CreateRepositoryRequest.Builder> createRepositoryRequest) {
        return createRepository(CreateRepositoryRequest.builder().applyMutation(createRepositoryRequest).build());
    }

    /**
     * <p>
     * Creates an unreferenced commit that represents the result of merging two branches using a specified merge
     * strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the
     * fast-forward merge strategy because that strategy does not create a merge commit.
     * </p>
     * <note>
     * <p>
     * This unreferenced merge commit can only be accessed using the GetCommit API or through git commands such as git
     * fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.
     * </p>
     * </note>
     *
     * @param createUnreferencedMergeCommitRequest
     * @return A Java Future containing the result of the CreateUnreferencedMergeCommit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified, but no replacement content has
     *         been provided.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>FileModeRequiredException The commit cannot be created because no file mode has been specified. A
     *         file mode is required to update mode permissions for a file.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateUnreferencedMergeCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateUnreferencedMergeCommit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUnreferencedMergeCommitResponse> createUnreferencedMergeCommit(
            CreateUnreferencedMergeCommitRequest createUnreferencedMergeCommitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an unreferenced commit that represents the result of merging two branches using a specified merge
     * strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the
     * fast-forward merge strategy because that strategy does not create a merge commit.
     * </p>
     * <note>
     * <p>
     * This unreferenced merge commit can only be accessed using the GetCommit API or through git commands such as git
     * fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUnreferencedMergeCommitRequest.Builder}
     * avoiding the need to create one manually via {@link CreateUnreferencedMergeCommitRequest#builder()}
     * </p>
     *
     * @param createUnreferencedMergeCommitRequest
     *        A {@link Consumer} that will call methods on {@link CreateUnreferencedMergeCommitInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateUnreferencedMergeCommit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified, but no replacement content has
     *         been provided.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>FileModeRequiredException The commit cannot be created because no file mode has been specified. A
     *         file mode is required to update mode permissions for a file.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.CreateUnreferencedMergeCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateUnreferencedMergeCommit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUnreferencedMergeCommitResponse> createUnreferencedMergeCommit(
            Consumer<CreateUnreferencedMergeCommitRequest.Builder> createUnreferencedMergeCommitRequest) {
        return createUnreferencedMergeCommit(CreateUnreferencedMergeCommitRequest.builder()
                .applyMutation(createUnreferencedMergeCommitRequest).build());
    }

    /**
     * <p>
     * Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests
     * already created with the template.
     * </p>
     *
     * @param deleteApprovalRuleTemplateRequest
     * @return A Java Future containing the result of the DeleteApprovalRuleTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateInUseException The approval rule template is associated with one or more
     *         repositories. You cannot delete a template that is associated with a repository. Remove all associations,
     *         and then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteApprovalRuleTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApprovalRuleTemplateResponse> deleteApprovalRuleTemplate(
            DeleteApprovalRuleTemplateRequest deleteApprovalRuleTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests
     * already created with the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApprovalRuleTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteApprovalRuleTemplateRequest#builder()}
     * </p>
     *
     * @param deleteApprovalRuleTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApprovalRuleTemplateInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApprovalRuleTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateInUseException The approval rule template is associated with one or more
     *         repositories. You cannot delete a template that is associated with a repository. Remove all associations,
     *         and then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteApprovalRuleTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApprovalRuleTemplateResponse> deleteApprovalRuleTemplate(
            Consumer<DeleteApprovalRuleTemplateRequest.Builder> deleteApprovalRuleTemplateRequest) {
        return deleteApprovalRuleTemplate(DeleteApprovalRuleTemplateRequest.builder()
                .applyMutation(deleteApprovalRuleTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a branch from a repository, unless that branch is the default branch for the repository.
     * </p>
     *
     * @param deleteBranchRequest
     *        Represents the input of a delete branch operation.
     * @return A Java Future containing the result of the DeleteBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>DefaultBranchCannotBeDeletedException The specified branch is the default branch for the repository,
     *         and cannot be deleted. To delete this branch, you must first set another branch as the default branch.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBranchResponse> deleteBranch(DeleteBranchRequest deleteBranchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a branch from a repository, unless that branch is the default branch for the repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBranchRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBranchRequest#builder()}
     * </p>
     *
     * @param deleteBranchRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBranchInput.Builder} to create a request.
     *        Represents the input of a delete branch operation.
     * @return A Java Future containing the result of the DeleteBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>DefaultBranchCannotBeDeletedException The specified branch is the default branch for the repository,
     *         and cannot be deleted. To delete this branch, you must first set another branch as the default branch.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBranchResponse> deleteBranch(Consumer<DeleteBranchRequest.Builder> deleteBranchRequest) {
        return deleteBranch(DeleteBranchRequest.builder().applyMutation(deleteBranchRequest).build());
    }

    /**
     * <p>
     * Deletes the content of a comment made on a change, file, or commit in a repository.
     * </p>
     *
     * @param deleteCommentContentRequest
     * @return A Java Future containing the result of the DeleteCommentContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteCommentContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteCommentContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCommentContentResponse> deleteCommentContent(
            DeleteCommentContentRequest deleteCommentContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the content of a comment made on a change, file, or commit in a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCommentContentRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCommentContentRequest#builder()}
     * </p>
     *
     * @param deleteCommentContentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCommentContentInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCommentContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteCommentContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteCommentContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCommentContentResponse> deleteCommentContent(
            Consumer<DeleteCommentContentRequest.Builder> deleteCommentContentRequest) {
        return deleteCommentContent(DeleteCommentContentRequest.builder().applyMutation(deleteCommentContentRequest).build());
    }

    /**
     * <p>
     * Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision.
     * The file still exists in the commits earlier to the commit that contains the deletion.
     * </p>
     *
     * @param deleteFileRequest
     * @return A Java Future containing the result of the DeleteFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ParentCommitIdRequiredException A parent commit ID is required. To view the full commit ID of a
     *         branch in a repository, use <a>GetBranch</a> or a Git command (for example, git pull or git log).</li>
     *         <li>InvalidParentCommitIdException The parent commit ID is not valid. The commit ID cannot be empty, and
     *         must match the head commit ID for the branch of the repository where you want to add or update a file.</li>
     *         <li>ParentCommitDoesNotExistException The parent commit ID is not valid because it does not exist. The
     *         specified parent commit ID does not exist in the specified branch of the repository.</li>
     *         <li>ParentCommitIdOutdatedException The file could not be added because the provided parent commit ID is
     *         not the current tip of the specified branch. To view the full commit ID of the current head of the
     *         branch, use <a>GetBranch</a>.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have used the correct
     *         file name, full path, and extension.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteFile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFileResponse> deleteFile(DeleteFileRequest deleteFileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision.
     * The file still exists in the commits earlier to the commit that contains the deletion.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFileRequest#builder()}
     * </p>
     *
     * @param deleteFileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFileInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ParentCommitIdRequiredException A parent commit ID is required. To view the full commit ID of a
     *         branch in a repository, use <a>GetBranch</a> or a Git command (for example, git pull or git log).</li>
     *         <li>InvalidParentCommitIdException The parent commit ID is not valid. The commit ID cannot be empty, and
     *         must match the head commit ID for the branch of the repository where you want to add or update a file.</li>
     *         <li>ParentCommitDoesNotExistException The parent commit ID is not valid because it does not exist. The
     *         specified parent commit ID does not exist in the specified branch of the repository.</li>
     *         <li>ParentCommitIdOutdatedException The file could not be added because the provided parent commit ID is
     *         not the current tip of the specified branch. To view the full commit ID of the current head of the
     *         branch, use <a>GetBranch</a>.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have used the correct
     *         file name, full path, and extension.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteFile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFileResponse> deleteFile(Consumer<DeleteFileRequest.Builder> deleteFileRequest) {
        return deleteFile(DeleteFileRequest.builder().applyMutation(deleteFileRequest).build());
    }

    /**
     * <p>
     * Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if
     * the pull request is open, and if the approval rule was created specifically for a pull request and not generated
     * from an approval rule template associated with the repository where the pull request was created. You cannot
     * delete an approval rule from a merged or closed pull request.
     * </p>
     *
     * @param deletePullRequestApprovalRuleRequest
     * @return A Java Future containing the result of the DeletePullRequestApprovalRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>ApprovalRuleNameRequiredException An approval rule name is required, but was not specified.</li>
     *         <li>InvalidApprovalRuleNameException The name for the approval rule is not valid.</li>
     *         <li>CannotDeleteApprovalRuleFromTemplateException The approval rule cannot be deleted from the pull
     *         request because it was created by an approval rule template and applied to the pull request
     *         automatically.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeletePullRequestApprovalRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeletePullRequestApprovalRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePullRequestApprovalRuleResponse> deletePullRequestApprovalRule(
            DeletePullRequestApprovalRuleRequest deletePullRequestApprovalRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if
     * the pull request is open, and if the approval rule was created specifically for a pull request and not generated
     * from an approval rule template associated with the repository where the pull request was created. You cannot
     * delete an approval rule from a merged or closed pull request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePullRequestApprovalRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePullRequestApprovalRuleRequest#builder()}
     * </p>
     *
     * @param deletePullRequestApprovalRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeletePullRequestApprovalRuleInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeletePullRequestApprovalRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>ApprovalRuleNameRequiredException An approval rule name is required, but was not specified.</li>
     *         <li>InvalidApprovalRuleNameException The name for the approval rule is not valid.</li>
     *         <li>CannotDeleteApprovalRuleFromTemplateException The approval rule cannot be deleted from the pull
     *         request because it was created by an approval rule template and applied to the pull request
     *         automatically.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeletePullRequestApprovalRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeletePullRequestApprovalRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePullRequestApprovalRuleResponse> deletePullRequestApprovalRule(
            Consumer<DeletePullRequestApprovalRuleRequest.Builder> deletePullRequestApprovalRuleRequest) {
        return deletePullRequestApprovalRule(DeletePullRequestApprovalRuleRequest.builder()
                .applyMutation(deletePullRequestApprovalRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a repository. If a specified repository was already deleted, a null repository ID is returned.
     * </p>
     * <important>
     * <p>
     * Deleting a repository also deletes all associated objects and metadata. After a repository is deleted, all future
     * push calls to the deleted repository fail.
     * </p>
     * </important>
     *
     * @param deleteRepositoryRequest
     *        Represents the input of a delete repository operation.
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a repository. If a specified repository was already deleted, a null repository ID is returned.
     * </p>
     * <important>
     * <p>
     * Deleting a repository also deletes all associated objects and metadata. After a repository is deleted, all future
     * push calls to the deleted repository fail.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRepositoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRepositoryRequest#builder()}
     * </p>
     *
     * @param deleteRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRepositoryInput.Builder} to create a request.
     *        Represents the input of a delete repository operation.
     * @return A Java Future containing the result of the DeleteRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DeleteRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteRepository" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteRepositoryResponse> deleteRepository(
            Consumer<DeleteRepositoryRequest.Builder> deleteRepositoryRequest) {
        return deleteRepository(DeleteRepositoryRequest.builder().applyMutation(deleteRepositoryRequest).build());
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy. If the merge option for the attempted merge is specified as
     * FAST_FORWARD_MERGE, an exception is thrown.
     * </p>
     *
     * @param describeMergeConflictsRequest
     * @return A Java Future containing the result of the DescribeMergeConflicts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have used the correct
     *         file name, full path, and extension.</li>
     *         <li>InvalidMaxMergeHunksException The specified value for the number of merge hunks to return is not
     *         valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMergeConflictsResponse> describeMergeConflicts(
            DescribeMergeConflictsRequest describeMergeConflictsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy. If the merge option for the attempted merge is specified as
     * FAST_FORWARD_MERGE, an exception is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMergeConflictsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMergeConflictsRequest#builder()}
     * </p>
     *
     * @param describeMergeConflictsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMergeConflictsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeMergeConflicts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have used the correct
     *         file name, full path, and extension.</li>
     *         <li>InvalidMaxMergeHunksException The specified value for the number of merge hunks to return is not
     *         valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMergeConflictsResponse> describeMergeConflicts(
            Consumer<DescribeMergeConflictsRequest.Builder> describeMergeConflictsRequest) {
        return describeMergeConflicts(DescribeMergeConflictsRequest.builder().applyMutation(describeMergeConflictsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy. If the merge option for the attempted merge is specified as
     * FAST_FORWARD_MERGE, an exception is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMergeConflicts(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsPublisher publisher = client.describeMergeConflictsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsPublisher publisher = client.describeMergeConflictsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxMergeHunks won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMergeConflicts(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMergeConflictsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have used the correct
     *         file name, full path, and extension.</li>
     *         <li>InvalidMaxMergeHunksException The specified value for the number of merge hunks to return is not
     *         valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMergeConflictsPublisher describeMergeConflictsPaginator(
            DescribeMergeConflictsRequest describeMergeConflictsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy. If the merge option for the attempted merge is specified as
     * FAST_FORWARD_MERGE, an exception is thrown.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMergeConflicts(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsPublisher publisher = client.describeMergeConflictsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribeMergeConflictsPublisher publisher = client.describeMergeConflictsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxMergeHunks won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMergeConflicts(software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMergeConflictsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMergeConflictsRequest#builder()}
     * </p>
     *
     * @param describeMergeConflictsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMergeConflictsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have used the correct
     *         file name, full path, and extension.</li>
     *         <li>InvalidMaxMergeHunksException The specified value for the number of merge hunks to return is not
     *         valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribeMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMergeConflictsPublisher describeMergeConflictsPaginator(
            Consumer<DescribeMergeConflictsRequest.Builder> describeMergeConflictsRequest) {
        return describeMergeConflictsPaginator(DescribeMergeConflictsRequest.builder()
                .applyMutation(describeMergeConflictsRequest).build());
    }

    /**
     * <p>
     * Returns information about one or more pull request events.
     * </p>
     *
     * @param describePullRequestEventsRequest
     * @return A Java Future containing the result of the DescribePullRequestEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestEventTypeException The pull request event type is not valid.</li>
     *         <li>InvalidActorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the user who initiated the change for the pull request, and then try again.</li>
     *         <li>ActorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribePullRequestEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribePullRequestEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePullRequestEventsResponse> describePullRequestEvents(
            DescribePullRequestEventsRequest describePullRequestEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about one or more pull request events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePullRequestEventsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePullRequestEventsRequest#builder()}
     * </p>
     *
     * @param describePullRequestEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePullRequestEventsInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePullRequestEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestEventTypeException The pull request event type is not valid.</li>
     *         <li>InvalidActorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the user who initiated the change for the pull request, and then try again.</li>
     *         <li>ActorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribePullRequestEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribePullRequestEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePullRequestEventsResponse> describePullRequestEvents(
            Consumer<DescribePullRequestEventsRequest.Builder> describePullRequestEventsRequest) {
        return describePullRequestEvents(DescribePullRequestEventsRequest.builder()
                .applyMutation(describePullRequestEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about one or more pull request events.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePullRequestEvents(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsPublisher publisher = client.describePullRequestEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsPublisher publisher = client.describePullRequestEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePullRequestEvents(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePullRequestEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestEventTypeException The pull request event type is not valid.</li>
     *         <li>InvalidActorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the user who initiated the change for the pull request, and then try again.</li>
     *         <li>ActorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribePullRequestEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribePullRequestEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePullRequestEventsPublisher describePullRequestEventsPaginator(
            DescribePullRequestEventsRequest describePullRequestEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about one or more pull request events.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePullRequestEvents(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsPublisher publisher = client.describePullRequestEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.DescribePullRequestEventsPublisher publisher = client.describePullRequestEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePullRequestEvents(software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePullRequestEventsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePullRequestEventsRequest#builder()}
     * </p>
     *
     * @param describePullRequestEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePullRequestEventsInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestEventTypeException The pull request event type is not valid.</li>
     *         <li>InvalidActorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the user who initiated the change for the pull request, and then try again.</li>
     *         <li>ActorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DescribePullRequestEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribePullRequestEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePullRequestEventsPublisher describePullRequestEventsPaginator(
            Consumer<DescribePullRequestEventsRequest.Builder> describePullRequestEventsRequest) {
        return describePullRequestEventsPaginator(DescribePullRequestEventsRequest.builder()
                .applyMutation(describePullRequestEventsRequest).build());
    }

    /**
     * <p>
     * Removes the association between a template and a repository so that approval rules based on the template are not
     * automatically created when pull requests are created in the specified repository. This does not delete any
     * approval rules previously created for pull requests through the template association.
     * </p>
     *
     * @param disassociateApprovalRuleTemplateFromRepositoryRequest
     * @return A Java Future containing the result of the DisassociateApprovalRuleTemplateFromRepository operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DisassociateApprovalRuleTemplateFromRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DisassociateApprovalRuleTemplateFromRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateApprovalRuleTemplateFromRepositoryResponse> disassociateApprovalRuleTemplateFromRepository(
            DisassociateApprovalRuleTemplateFromRepositoryRequest disassociateApprovalRuleTemplateFromRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between a template and a repository so that approval rules based on the template are not
     * automatically created when pull requests are created in the specified repository. This does not delete any
     * approval rules previously created for pull requests through the template association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateApprovalRuleTemplateFromRepositoryRequest.Builder} avoiding the need to create one manually
     * via {@link DisassociateApprovalRuleTemplateFromRepositoryRequest#builder()}
     * </p>
     *
     * @param disassociateApprovalRuleTemplateFromRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisassociateApprovalRuleTemplateFromRepositoryInput.Builder} to create a request.
     * @return A Java Future containing the result of the DisassociateApprovalRuleTemplateFromRepository operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.DisassociateApprovalRuleTemplateFromRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DisassociateApprovalRuleTemplateFromRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateApprovalRuleTemplateFromRepositoryResponse> disassociateApprovalRuleTemplateFromRepository(
            Consumer<DisassociateApprovalRuleTemplateFromRepositoryRequest.Builder> disassociateApprovalRuleTemplateFromRepositoryRequest) {
        return disassociateApprovalRuleTemplateFromRepository(DisassociateApprovalRuleTemplateFromRepositoryRequest.builder()
                .applyMutation(disassociateApprovalRuleTemplateFromRepositoryRequest).build());
    }

    /**
     * <p>
     * Evaluates whether a pull request has met all the conditions specified in its associated approval rules.
     * </p>
     *
     * @param evaluatePullRequestApprovalRulesRequest
     * @return A Java Future containing the result of the EvaluatePullRequestApprovalRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidRevisionIdException The revision ID is not valid. Use GetPullRequest to determine the value.</li>
     *         <li>RevisionIdRequiredException A revision ID is required, but was not provided.</li>
     *         <li>RevisionNotCurrentException The revision ID provided in the request does not match the current
     *         revision ID. Use GetPullRequest to retrieve the current revision ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.EvaluatePullRequestApprovalRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/EvaluatePullRequestApprovalRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EvaluatePullRequestApprovalRulesResponse> evaluatePullRequestApprovalRules(
            EvaluatePullRequestApprovalRulesRequest evaluatePullRequestApprovalRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates whether a pull request has met all the conditions specified in its associated approval rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EvaluatePullRequestApprovalRulesRequest.Builder}
     * avoiding the need to create one manually via {@link EvaluatePullRequestApprovalRulesRequest#builder()}
     * </p>
     *
     * @param evaluatePullRequestApprovalRulesRequest
     *        A {@link Consumer} that will call methods on {@link EvaluatePullRequestApprovalRulesInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the EvaluatePullRequestApprovalRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidRevisionIdException The revision ID is not valid. Use GetPullRequest to determine the value.</li>
     *         <li>RevisionIdRequiredException A revision ID is required, but was not provided.</li>
     *         <li>RevisionNotCurrentException The revision ID provided in the request does not match the current
     *         revision ID. Use GetPullRequest to retrieve the current revision ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.EvaluatePullRequestApprovalRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/EvaluatePullRequestApprovalRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<EvaluatePullRequestApprovalRulesResponse> evaluatePullRequestApprovalRules(
            Consumer<EvaluatePullRequestApprovalRulesRequest.Builder> evaluatePullRequestApprovalRulesRequest) {
        return evaluatePullRequestApprovalRules(EvaluatePullRequestApprovalRulesRequest.builder()
                .applyMutation(evaluatePullRequestApprovalRulesRequest).build());
    }

    /**
     * <p>
     * Returns information about a specified approval rule template.
     * </p>
     *
     * @param getApprovalRuleTemplateRequest
     * @return A Java Future containing the result of the GetApprovalRuleTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetApprovalRuleTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApprovalRuleTemplateResponse> getApprovalRuleTemplate(
            GetApprovalRuleTemplateRequest getApprovalRuleTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specified approval rule template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApprovalRuleTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetApprovalRuleTemplateRequest#builder()}
     * </p>
     *
     * @param getApprovalRuleTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetApprovalRuleTemplateInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApprovalRuleTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetApprovalRuleTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApprovalRuleTemplateResponse> getApprovalRuleTemplate(
            Consumer<GetApprovalRuleTemplateRequest.Builder> getApprovalRuleTemplateRequest) {
        return getApprovalRuleTemplate(GetApprovalRuleTemplateRequest.builder().applyMutation(getApprovalRuleTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Returns the base-64 encoded content of an individual blob in a repository.
     * </p>
     *
     * @param getBlobRequest
     *        Represents the input of a get blob operation.
     * @return A Java Future containing the result of the GetBlob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>BlobIdRequiredException A blob ID is required, but was not specified.</li>
     *         <li>InvalidBlobIdException The specified blob is not valid.</li>
     *         <li>BlobIdDoesNotExistException The specified blob does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>FileTooLargeException The specified file exceeds the file size limit for AWS CodeCommit. For more
     *         information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBlob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlobResponse> getBlob(GetBlobRequest getBlobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the base-64 encoded content of an individual blob in a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlobRequest.Builder} avoiding the need to create
     * one manually via {@link GetBlobRequest#builder()}
     * </p>
     *
     * @param getBlobRequest
     *        A {@link Consumer} that will call methods on {@link GetBlobInput.Builder} to create a request. Represents
     *        the input of a get blob operation.
     * @return A Java Future containing the result of the GetBlob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>BlobIdRequiredException A blob ID is required, but was not specified.</li>
     *         <li>InvalidBlobIdException The specified blob is not valid.</li>
     *         <li>BlobIdDoesNotExistException The specified blob does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>FileTooLargeException The specified file exceeds the file size limit for AWS CodeCommit. For more
     *         information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetBlob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBlob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlobResponse> getBlob(Consumer<GetBlobRequest.Builder> getBlobRequest) {
        return getBlob(GetBlobRequest.builder().applyMutation(getBlobRequest).build());
    }

    /**
     * <p>
     * Returns information about a repository branch, including its name and the last commit ID.
     * </p>
     *
     * @param getBranchRequest
     *        Represents the input of a get branch operation.
     * @return A Java Future containing the result of the GetBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBranchResponse> getBranch(GetBranchRequest getBranchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a repository branch, including its name and the last commit ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBranchRequest.Builder} avoiding the need to
     * create one manually via {@link GetBranchRequest#builder()}
     * </p>
     *
     * @param getBranchRequest
     *        A {@link Consumer} that will call methods on {@link GetBranchInput.Builder} to create a request.
     *        Represents the input of a get branch operation.
     * @return A Java Future containing the result of the GetBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBranch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBranchResponse> getBranch(Consumer<GetBranchRequest.Builder> getBranchRequest) {
        return getBranch(GetBranchRequest.builder().applyMutation(getBranchRequest).build());
    }

    /**
     * <p>
     * Returns the content of a comment made on a change, file, or commit in a repository.
     * </p>
     * <note>
     * <p>
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a
     * count of reactions from active identities, use GetCommentReactions.
     * </p>
     * </note>
     *
     * @param getCommentRequest
     * @return A Java Future containing the result of the GetComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetComment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCommentResponse> getComment(GetCommentRequest getCommentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the content of a comment made on a change, file, or commit in a repository.
     * </p>
     * <note>
     * <p>
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a
     * count of reactions from active identities, use GetCommentReactions.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCommentRequest.Builder} avoiding the need to
     * create one manually via {@link GetCommentRequest#builder()}
     * </p>
     *
     * @param getCommentRequest
     *        A {@link Consumer} that will call methods on {@link GetCommentInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetComment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCommentResponse> getComment(Consumer<GetCommentRequest.Builder> getCommentRequest) {
        return getComment(GetCommentRequest.builder().applyMutation(getCommentRequest).build());
    }

    /**
     * <p>
     * Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will
     * not be included in the count.
     * </p>
     *
     * @param getCommentReactionsRequest
     * @return A Java Future containing the result of the GetCommentReactions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>InvalidReactionUserArnException The Amazon Resource Name (ARN) of the user or identity is not valid.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentReactions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentReactions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCommentReactionsResponse> getCommentReactions(
            GetCommentReactionsRequest getCommentReactionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will
     * not be included in the count.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCommentReactionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetCommentReactionsRequest#builder()}
     * </p>
     *
     * @param getCommentReactionsRequest
     *        A {@link Consumer} that will call methods on {@link GetCommentReactionsInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetCommentReactions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>InvalidReactionUserArnException The Amazon Resource Name (ARN) of the user or identity is not valid.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentReactions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentReactions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCommentReactionsResponse> getCommentReactions(
            Consumer<GetCommentReactionsRequest.Builder> getCommentReactionsRequest) {
        return getCommentReactions(GetCommentReactionsRequest.builder().applyMutation(getCommentReactionsRequest).build());
    }

    /**
     * <p>
     * Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will
     * not be included in the count.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCommentReactions(software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentReactionsPublisher publisher = client.getCommentReactionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentReactionsPublisher publisher = client.getCommentReactionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCommentReactions(software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCommentReactionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>InvalidReactionUserArnException The Amazon Resource Name (ARN) of the user or identity is not valid.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentReactions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentReactions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCommentReactionsPublisher getCommentReactionsPaginator(GetCommentReactionsRequest getCommentReactionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will
     * not be included in the count.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getCommentReactions(software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentReactionsPublisher publisher = client.getCommentReactionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentReactionsPublisher publisher = client.getCommentReactionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCommentReactions(software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCommentReactionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetCommentReactionsRequest#builder()}
     * </p>
     *
     * @param getCommentReactionsRequest
     *        A {@link Consumer} that will call methods on {@link GetCommentReactionsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>InvalidReactionUserArnException The Amazon Resource Name (ARN) of the user or identity is not valid.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentReactions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentReactions" target="_top">AWS
     *      API Documentation</a>
     */
    default GetCommentReactionsPublisher getCommentReactionsPaginator(
            Consumer<GetCommentReactionsRequest.Builder> getCommentReactionsRequest) {
        return getCommentReactionsPaginator(GetCommentReactionsRequest.builder().applyMutation(getCommentReactionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about comments made on the comparison between two commits.
     * </p>
     * <note>
     * <p>
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a
     * count of reactions from active identities, use GetCommentReactions.
     * </p>
     * </note>
     *
     * @param getCommentsForComparedCommitRequest
     * @return A Java Future containing the result of the GetCommentsForComparedCommit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCommentsForComparedCommitResponse> getCommentsForComparedCommit(
            GetCommentsForComparedCommitRequest getCommentsForComparedCommitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about comments made on the comparison between two commits.
     * </p>
     * <note>
     * <p>
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a
     * count of reactions from active identities, use GetCommentReactions.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCommentsForComparedCommitRequest.Builder}
     * avoiding the need to create one manually via {@link GetCommentsForComparedCommitRequest#builder()}
     * </p>
     *
     * @param getCommentsForComparedCommitRequest
     *        A {@link Consumer} that will call methods on {@link GetCommentsForComparedCommitInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCommentsForComparedCommit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCommentsForComparedCommitResponse> getCommentsForComparedCommit(
            Consumer<GetCommentsForComparedCommitRequest.Builder> getCommentsForComparedCommitRequest) {
        return getCommentsForComparedCommit(GetCommentsForComparedCommitRequest.builder()
                .applyMutation(getCommentsForComparedCommitRequest).build());
    }

    /**
     * <p>
     * Returns information about comments made on the comparison between two commits.
     * </p>
     * <note>
     * <p>
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a
     * count of reactions from active identities, use GetCommentReactions.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getCommentsForComparedCommit(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitPublisher publisher = client.getCommentsForComparedCommitPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitPublisher publisher = client.getCommentsForComparedCommitPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCommentsForComparedCommit(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCommentsForComparedCommitRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCommentsForComparedCommitPublisher getCommentsForComparedCommitPaginator(
            GetCommentsForComparedCommitRequest getCommentsForComparedCommitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about comments made on the comparison between two commits.
     * </p>
     * <note>
     * <p>
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a
     * count of reactions from active identities, use GetCommentReactions.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getCommentsForComparedCommit(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitPublisher publisher = client.getCommentsForComparedCommitPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForComparedCommitPublisher publisher = client.getCommentsForComparedCommitPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCommentsForComparedCommit(software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCommentsForComparedCommitRequest.Builder}
     * avoiding the need to create one manually via {@link GetCommentsForComparedCommitRequest#builder()}
     * </p>
     *
     * @param getCommentsForComparedCommitRequest
     *        A {@link Consumer} that will call methods on {@link GetCommentsForComparedCommitInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCommentsForComparedCommitPublisher getCommentsForComparedCommitPaginator(
            Consumer<GetCommentsForComparedCommitRequest.Builder> getCommentsForComparedCommitRequest) {
        return getCommentsForComparedCommitPaginator(GetCommentsForComparedCommitRequest.builder()
                .applyMutation(getCommentsForComparedCommitRequest).build());
    }

    /**
     * <p>
     * Returns comments made on a pull request.
     * </p>
     * <note>
     * <p>
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a
     * count of reactions from active identities, use GetCommentReactions.
     * </p>
     * </note>
     *
     * @param getCommentsForPullRequestRequest
     * @return A Java Future containing the result of the GetCommentsForPullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCommentsForPullRequestResponse> getCommentsForPullRequest(
            GetCommentsForPullRequestRequest getCommentsForPullRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns comments made on a pull request.
     * </p>
     * <note>
     * <p>
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a
     * count of reactions from active identities, use GetCommentReactions.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCommentsForPullRequestRequest.Builder} avoiding
     * the need to create one manually via {@link GetCommentsForPullRequestRequest#builder()}
     * </p>
     *
     * @param getCommentsForPullRequestRequest
     *        A {@link Consumer} that will call methods on {@link GetCommentsForPullRequestInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCommentsForPullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCommentsForPullRequestResponse> getCommentsForPullRequest(
            Consumer<GetCommentsForPullRequestRequest.Builder> getCommentsForPullRequestRequest) {
        return getCommentsForPullRequest(GetCommentsForPullRequestRequest.builder()
                .applyMutation(getCommentsForPullRequestRequest).build());
    }

    /**
     * <p>
     * Returns comments made on a pull request.
     * </p>
     * <note>
     * <p>
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a
     * count of reactions from active identities, use GetCommentReactions.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getCommentsForPullRequest(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestPublisher publisher = client.getCommentsForPullRequestPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestPublisher publisher = client.getCommentsForPullRequestPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCommentsForPullRequest(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest)}
     * operation.</b>
     * </p>
     *
     * @param getCommentsForPullRequestRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCommentsForPullRequestPublisher getCommentsForPullRequestPaginator(
            GetCommentsForPullRequestRequest getCommentsForPullRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns comments made on a pull request.
     * </p>
     * <note>
     * <p>
     * Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a
     * count of reactions from active identities, use GetCommentReactions.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getCommentsForPullRequest(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestPublisher publisher = client.getCommentsForPullRequestPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetCommentsForPullRequestPublisher publisher = client.getCommentsForPullRequestPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCommentsForPullRequest(software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCommentsForPullRequestRequest.Builder} avoiding
     * the need to create one manually via {@link GetCommentsForPullRequestRequest#builder()}
     * </p>
     *
     * @param getCommentsForPullRequestRequest
     *        A {@link Consumer} that will call methods on {@link GetCommentsForPullRequestInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommentsForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCommentsForPullRequestPublisher getCommentsForPullRequestPaginator(
            Consumer<GetCommentsForPullRequestRequest.Builder> getCommentsForPullRequestRequest) {
        return getCommentsForPullRequestPaginator(GetCommentsForPullRequestRequest.builder()
                .applyMutation(getCommentsForPullRequestRequest).build());
    }

    /**
     * <p>
     * Returns information about a commit, including commit message and committer information.
     * </p>
     *
     * @param getCommitRequest
     *        Represents the input of a get commit operation.
     * @return A Java Future containing the result of the GetCommit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitIdDoesNotExistException The specified commit ID does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCommitResponse> getCommit(GetCommitRequest getCommitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a commit, including commit message and committer information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCommitRequest.Builder} avoiding the need to
     * create one manually via {@link GetCommitRequest#builder()}
     * </p>
     *
     * @param getCommitRequest
     *        A {@link Consumer} that will call methods on {@link GetCommitInput.Builder} to create a request.
     *        Represents the input of a get commit operation.
     * @return A Java Future containing the result of the GetCommit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitIdDoesNotExistException The specified commit ID does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCommitResponse> getCommit(Consumer<GetCommitRequest.Builder> getCommitRequest) {
        return getCommit(GetCommitRequest.builder().applyMutation(getCommitRequest).build());
    }

    /**
     * <p>
     * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or
     * other fully qualified reference). Results can be limited to a specified path.
     * </p>
     *
     * @param getDifferencesRequest
     * @return A Java Future containing the result of the GetDifferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetDifferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDifferencesResponse> getDifferences(GetDifferencesRequest getDifferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or
     * other fully qualified reference). Results can be limited to a specified path.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDifferencesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDifferencesRequest#builder()}
     * </p>
     *
     * @param getDifferencesRequest
     *        A {@link Consumer} that will call methods on {@link GetDifferencesInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetDifferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetDifferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDifferencesResponse> getDifferences(Consumer<GetDifferencesRequest.Builder> getDifferencesRequest) {
        return getDifferences(GetDifferencesRequest.builder().applyMutation(getDifferencesRequest).build());
    }

    /**
     * <p>
     * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or
     * other fully qualified reference). Results can be limited to a specified path.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDifferences(software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetDifferencesPublisher publisher = client.getDifferencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetDifferencesPublisher publisher = client.getDifferencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDifferences(software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest)} operation.</b>
     * </p>
     *
     * @param getDifferencesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetDifferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDifferencesPublisher getDifferencesPaginator(GetDifferencesRequest getDifferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or
     * other fully qualified reference). Results can be limited to a specified path.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDifferences(software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetDifferencesPublisher publisher = client.getDifferencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetDifferencesPublisher publisher = client.getDifferencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDifferences(software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDifferencesRequest.Builder} avoiding the need to
     * create one manually via {@link GetDifferencesRequest#builder()}
     * </p>
     *
     * @param getDifferencesRequest
     *        A {@link Consumer} that will call methods on {@link GetDifferencesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetDifferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDifferencesPublisher getDifferencesPaginator(Consumer<GetDifferencesRequest.Builder> getDifferencesRequest) {
        return getDifferencesPaginator(GetDifferencesRequest.builder().applyMutation(getDifferencesRequest).build());
    }

    /**
     * <p>
     * Returns the base-64 encoded contents of a specified file and its metadata.
     * </p>
     *
     * @param getFileRequest
     * @return A Java Future containing the result of the GetFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have used the correct
     *         file name, full path, and extension.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>FileTooLargeException The specified file exceeds the file size limit for AWS CodeCommit. For more
     *         information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetFile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFileResponse> getFile(GetFileRequest getFileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the base-64 encoded contents of a specified file and its metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFileRequest.Builder} avoiding the need to create
     * one manually via {@link GetFileRequest#builder()}
     * </p>
     *
     * @param getFileRequest
     *        A {@link Consumer} that will call methods on {@link GetFileInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileDoesNotExistException The specified file does not exist. Verify that you have used the correct
     *         file name, full path, and extension.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>FileTooLargeException The specified file exceeds the file size limit for AWS CodeCommit. For more
     *         information about limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetFile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFileResponse> getFile(Consumer<GetFileRequest.Builder> getFileRequest) {
        return getFile(GetFileRequest.builder().applyMutation(getFileRequest).build());
    }

    /**
     * <p>
     * Returns the contents of a specified folder in a repository.
     * </p>
     *
     * @param getFolderRequest
     * @return A Java Future containing the result of the GetFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FolderDoesNotExistException The specified folder does not exist. Either the folder name is not
     *         correct, or you did not enter the full path to the folder.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetFolder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFolderResponse> getFolder(GetFolderRequest getFolderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the contents of a specified folder in a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFolderRequest.Builder} avoiding the need to
     * create one manually via {@link GetFolderRequest#builder()}
     * </p>
     *
     * @param getFolderRequest
     *        A {@link Consumer} that will call methods on {@link GetFolderInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FolderDoesNotExistException The specified folder does not exist. Either the folder name is not
     *         correct, or you did not enter the full path to the folder.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetFolder
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetFolder" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFolderResponse> getFolder(Consumer<GetFolderRequest.Builder> getFolderRequest) {
        return getFolder(GetFolderRequest.builder().applyMutation(getFolderRequest).build());
    }

    /**
     * <p>
     * Returns information about a specified merge commit.
     * </p>
     *
     * @param getMergeCommitRequest
     * @return A Java Future containing the result of the GetMergeCommit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeCommit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMergeCommitResponse> getMergeCommit(GetMergeCommitRequest getMergeCommitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specified merge commit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMergeCommitRequest.Builder} avoiding the need to
     * create one manually via {@link GetMergeCommitRequest#builder()}
     * </p>
     *
     * @param getMergeCommitRequest
     *        A {@link Consumer} that will call methods on {@link GetMergeCommitInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetMergeCommit operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeCommit" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMergeCommitResponse> getMergeCommit(Consumer<GetMergeCommitRequest.Builder> getMergeCommitRequest) {
        return getMergeCommit(GetMergeCommitRequest.builder().applyMutation(getMergeCommitRequest).build());
    }

    /**
     * <p>
     * Returns information about merge conflicts between the before and after commit IDs for a pull request in a
     * repository.
     * </p>
     *
     * @param getMergeConflictsRequest
     * @return A Java Future containing the result of the GetMergeConflicts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidMaxConflictFilesException The specified value for the number of conflict files to return is
     *         not valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidDestinationCommitSpecifierException The destination commit specifier is not valid. You must
     *         provide a valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidSourceCommitSpecifierException The source commit specifier is not valid. You must provide a
     *         valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMergeConflictsResponse> getMergeConflicts(GetMergeConflictsRequest getMergeConflictsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about merge conflicts between the before and after commit IDs for a pull request in a
     * repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMergeConflictsRequest.Builder} avoiding the need
     * to create one manually via {@link GetMergeConflictsRequest#builder()}
     * </p>
     *
     * @param getMergeConflictsRequest
     *        A {@link Consumer} that will call methods on {@link GetMergeConflictsInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetMergeConflicts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidMaxConflictFilesException The specified value for the number of conflict files to return is
     *         not valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidDestinationCommitSpecifierException The destination commit specifier is not valid. You must
     *         provide a valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidSourceCommitSpecifierException The source commit specifier is not valid. You must provide a
     *         valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMergeConflictsResponse> getMergeConflicts(
            Consumer<GetMergeConflictsRequest.Builder> getMergeConflictsRequest) {
        return getMergeConflicts(GetMergeConflictsRequest.builder().applyMutation(getMergeConflictsRequest).build());
    }

    /**
     * <p>
     * Returns information about merge conflicts between the before and after commit IDs for a pull request in a
     * repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getMergeConflicts(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsPublisher publisher = client.getMergeConflictsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsPublisher publisher = client.getMergeConflictsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxConflictFiles won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMergeConflicts(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getMergeConflictsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidMaxConflictFilesException The specified value for the number of conflict files to return is
     *         not valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidDestinationCommitSpecifierException The destination commit specifier is not valid. You must
     *         provide a valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidSourceCommitSpecifierException The source commit specifier is not valid. You must provide a
     *         valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMergeConflictsPublisher getMergeConflictsPaginator(GetMergeConflictsRequest getMergeConflictsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about merge conflicts between the before and after commit IDs for a pull request in a
     * repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getMergeConflicts(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsPublisher publisher = client.getMergeConflictsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.GetMergeConflictsPublisher publisher = client.getMergeConflictsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxConflictFiles won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getMergeConflicts(software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMergeConflictsRequest.Builder} avoiding the need
     * to create one manually via {@link GetMergeConflictsRequest#builder()}
     * </p>
     *
     * @param getMergeConflictsRequest
     *        A {@link Consumer} that will call methods on {@link GetMergeConflictsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>MergeOptionRequiredException A merge option or stategy is required, and none was provided.</li>
     *         <li>InvalidMergeOptionException The specified merge option is not valid for this operation. Not all merge
     *         strategies are supported for all operations.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidMaxConflictFilesException The specified value for the number of conflict files to return is
     *         not valid.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidDestinationCommitSpecifierException The destination commit specifier is not valid. You must
     *         provide a valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidSourceCommitSpecifierException The source commit specifier is not valid. You must provide a
     *         valid branch name, tag, or full commit ID.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeConflicts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMergeConflictsPublisher getMergeConflictsPaginator(
            Consumer<GetMergeConflictsRequest.Builder> getMergeConflictsRequest) {
        return getMergeConflictsPaginator(GetMergeConflictsRequest.builder().applyMutation(getMergeConflictsRequest).build());
    }

    /**
     * <p>
     * Returns information about the merge options available for merging two specified branches. For details about why a
     * merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.
     * </p>
     *
     * @param getMergeOptionsRequest
     * @return A Java Future containing the result of the GetMergeOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMergeOptionsResponse> getMergeOptions(GetMergeOptionsRequest getMergeOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the merge options available for merging two specified branches. For details about why a
     * merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMergeOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link GetMergeOptionsRequest#builder()}
     * </p>
     *
     * @param getMergeOptionsRequest
     *        A {@link Consumer} that will call methods on {@link GetMergeOptionsInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetMergeOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetMergeOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeOptions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMergeOptionsResponse> getMergeOptions(
            Consumer<GetMergeOptionsRequest.Builder> getMergeOptionsRequest) {
        return getMergeOptions(GetMergeOptionsRequest.builder().applyMutation(getMergeOptionsRequest).build());
    }

    /**
     * <p>
     * Gets information about a pull request in a specified repository.
     * </p>
     *
     * @param getPullRequestRequest
     * @return A Java Future containing the result of the GetPullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequest" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPullRequestResponse> getPullRequest(GetPullRequestRequest getPullRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a pull request in a specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPullRequestRequest.Builder} avoiding the need to
     * create one manually via {@link GetPullRequestRequest#builder()}
     * </p>
     *
     * @param getPullRequestRequest
     *        A {@link Consumer} that will call methods on {@link GetPullRequestInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetPullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequest" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPullRequestResponse> getPullRequest(Consumer<GetPullRequestRequest.Builder> getPullRequestRequest) {
        return getPullRequest(GetPullRequestRequest.builder().applyMutation(getPullRequestRequest).build());
    }

    /**
     * <p>
     * Gets information about the approval states for a specified pull request. Approval states only apply to pull
     * requests that have one or more approval rules applied to them.
     * </p>
     *
     * @param getPullRequestApprovalStatesRequest
     * @return A Java Future containing the result of the GetPullRequestApprovalStates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidRevisionIdException The revision ID is not valid. Use GetPullRequest to determine the value.</li>
     *         <li>RevisionIdRequiredException A revision ID is required, but was not provided.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetPullRequestApprovalStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequestApprovalStates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPullRequestApprovalStatesResponse> getPullRequestApprovalStates(
            GetPullRequestApprovalStatesRequest getPullRequestApprovalStatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the approval states for a specified pull request. Approval states only apply to pull
     * requests that have one or more approval rules applied to them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPullRequestApprovalStatesRequest.Builder}
     * avoiding the need to create one manually via {@link GetPullRequestApprovalStatesRequest#builder()}
     * </p>
     *
     * @param getPullRequestApprovalStatesRequest
     *        A {@link Consumer} that will call methods on {@link GetPullRequestApprovalStatesInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPullRequestApprovalStates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidRevisionIdException The revision ID is not valid. Use GetPullRequest to determine the value.</li>
     *         <li>RevisionIdRequiredException A revision ID is required, but was not provided.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetPullRequestApprovalStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequestApprovalStates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPullRequestApprovalStatesResponse> getPullRequestApprovalStates(
            Consumer<GetPullRequestApprovalStatesRequest.Builder> getPullRequestApprovalStatesRequest) {
        return getPullRequestApprovalStates(GetPullRequestApprovalStatesRequest.builder()
                .applyMutation(getPullRequestApprovalStatesRequest).build());
    }

    /**
     * <p>
     * Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so,
     * the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the
     * pull request.
     * </p>
     *
     * @param getPullRequestOverrideStateRequest
     * @return A Java Future containing the result of the GetPullRequestOverrideState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidRevisionIdException The revision ID is not valid. Use GetPullRequest to determine the value.</li>
     *         <li>RevisionIdRequiredException A revision ID is required, but was not provided.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetPullRequestOverrideState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequestOverrideState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPullRequestOverrideStateResponse> getPullRequestOverrideState(
            GetPullRequestOverrideStateRequest getPullRequestOverrideStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so,
     * the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the
     * pull request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPullRequestOverrideStateRequest.Builder}
     * avoiding the need to create one manually via {@link GetPullRequestOverrideStateRequest#builder()}
     * </p>
     *
     * @param getPullRequestOverrideStateRequest
     *        A {@link Consumer} that will call methods on {@link GetPullRequestOverrideStateInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPullRequestOverrideState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidRevisionIdException The revision ID is not valid. Use GetPullRequest to determine the value.</li>
     *         <li>RevisionIdRequiredException A revision ID is required, but was not provided.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetPullRequestOverrideState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequestOverrideState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPullRequestOverrideStateResponse> getPullRequestOverrideState(
            Consumer<GetPullRequestOverrideStateRequest.Builder> getPullRequestOverrideStateRequest) {
        return getPullRequestOverrideState(GetPullRequestOverrideStateRequest.builder()
                .applyMutation(getPullRequestOverrideStateRequest).build());
    }

    /**
     * <p>
     * Returns information about a repository.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a webpage.
     * </p>
     * </note>
     *
     * @param getRepositoryRequest
     *        Represents the input of a get repository operation.
     * @return A Java Future containing the result of the GetRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRepositoryResponse> getRepository(GetRepositoryRequest getRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a repository.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a webpage.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetRepositoryRequest#builder()}
     * </p>
     *
     * @param getRepositoryRequest
     *        A {@link Consumer} that will call methods on {@link GetRepositoryInput.Builder} to create a request.
     *        Represents the input of a get repository operation.
     * @return A Java Future containing the result of the GetRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetRepository
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepository" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRepositoryResponse> getRepository(Consumer<GetRepositoryRequest.Builder> getRepositoryRequest) {
        return getRepository(GetRepositoryRequest.builder().applyMutation(getRepositoryRequest).build());
    }

    /**
     * <p>
     * Gets information about triggers configured for a repository.
     * </p>
     *
     * @param getRepositoryTriggersRequest
     *        Represents the input of a get repository triggers operation.
     * @return A Java Future containing the result of the GetRepositoryTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryTriggersResponse> getRepositoryTriggers(
            GetRepositoryTriggersRequest getRepositoryTriggersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about triggers configured for a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRepositoryTriggersRequest.Builder} avoiding the
     * need to create one manually via {@link GetRepositoryTriggersRequest#builder()}
     * </p>
     *
     * @param getRepositoryTriggersRequest
     *        A {@link Consumer} that will call methods on {@link GetRepositoryTriggersInput.Builder} to create a
     *        request. Represents the input of a get repository triggers operation.
     * @return A Java Future containing the result of the GetRepositoryTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.GetRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRepositoryTriggersResponse> getRepositoryTriggers(
            Consumer<GetRepositoryTriggersRequest.Builder> getRepositoryTriggersRequest) {
        return getRepositoryTriggers(GetRepositoryTriggersRequest.builder().applyMutation(getRepositoryTriggersRequest).build());
    }

    /**
     * <p>
     * Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not
     * specified, the AWS Region where you are signed in is used.
     * </p>
     *
     * @param listApprovalRuleTemplatesRequest
     * @return A Java Future containing the result of the ListApprovalRuleTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListApprovalRuleTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListApprovalRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApprovalRuleTemplatesResponse> listApprovalRuleTemplates(
            ListApprovalRuleTemplatesRequest listApprovalRuleTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not
     * specified, the AWS Region where you are signed in is used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApprovalRuleTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListApprovalRuleTemplatesRequest#builder()}
     * </p>
     *
     * @param listApprovalRuleTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListApprovalRuleTemplatesInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApprovalRuleTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListApprovalRuleTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListApprovalRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApprovalRuleTemplatesResponse> listApprovalRuleTemplates(
            Consumer<ListApprovalRuleTemplatesRequest.Builder> listApprovalRuleTemplatesRequest) {
        return listApprovalRuleTemplates(ListApprovalRuleTemplatesRequest.builder()
                .applyMutation(listApprovalRuleTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not
     * specified, the AWS Region where you are signed in is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApprovalRuleTemplates(software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListApprovalRuleTemplatesPublisher publisher = client.listApprovalRuleTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListApprovalRuleTemplatesPublisher publisher = client.listApprovalRuleTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApprovalRuleTemplates(software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApprovalRuleTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListApprovalRuleTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListApprovalRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApprovalRuleTemplatesPublisher listApprovalRuleTemplatesPaginator(
            ListApprovalRuleTemplatesRequest listApprovalRuleTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not
     * specified, the AWS Region where you are signed in is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApprovalRuleTemplates(software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListApprovalRuleTemplatesPublisher publisher = client.listApprovalRuleTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListApprovalRuleTemplatesPublisher publisher = client.listApprovalRuleTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApprovalRuleTemplates(software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApprovalRuleTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListApprovalRuleTemplatesRequest#builder()}
     * </p>
     *
     * @param listApprovalRuleTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListApprovalRuleTemplatesInput.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListApprovalRuleTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListApprovalRuleTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApprovalRuleTemplatesPublisher listApprovalRuleTemplatesPaginator(
            Consumer<ListApprovalRuleTemplatesRequest.Builder> listApprovalRuleTemplatesRequest) {
        return listApprovalRuleTemplatesPaginator(ListApprovalRuleTemplatesRequest.builder()
                .applyMutation(listApprovalRuleTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all approval rule templates that are associated with a specified repository.
     * </p>
     *
     * @param listAssociatedApprovalRuleTemplatesForRepositoryRequest
     * @return A Java Future containing the result of the ListAssociatedApprovalRuleTemplatesForRepository operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListAssociatedApprovalRuleTemplatesForRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListAssociatedApprovalRuleTemplatesForRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociatedApprovalRuleTemplatesForRepositoryResponse> listAssociatedApprovalRuleTemplatesForRepository(
            ListAssociatedApprovalRuleTemplatesForRepositoryRequest listAssociatedApprovalRuleTemplatesForRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all approval rule templates that are associated with a specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssociatedApprovalRuleTemplatesForRepositoryRequest.Builder} avoiding the need to create one manually
     * via {@link ListAssociatedApprovalRuleTemplatesForRepositoryRequest#builder()}
     * </p>
     *
     * @param listAssociatedApprovalRuleTemplatesForRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAssociatedApprovalRuleTemplatesForRepositoryInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListAssociatedApprovalRuleTemplatesForRepository operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListAssociatedApprovalRuleTemplatesForRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListAssociatedApprovalRuleTemplatesForRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssociatedApprovalRuleTemplatesForRepositoryResponse> listAssociatedApprovalRuleTemplatesForRepository(
            Consumer<ListAssociatedApprovalRuleTemplatesForRepositoryRequest.Builder> listAssociatedApprovalRuleTemplatesForRepositoryRequest) {
        return listAssociatedApprovalRuleTemplatesForRepository(ListAssociatedApprovalRuleTemplatesForRepositoryRequest.builder()
                .applyMutation(listAssociatedApprovalRuleTemplatesForRepositoryRequest).build());
    }

    /**
     * <p>
     * Lists all approval rule templates that are associated with a specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedApprovalRuleTemplatesForRepository(software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListAssociatedApprovalRuleTemplatesForRepositoryPublisher publisher = client.listAssociatedApprovalRuleTemplatesForRepositoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListAssociatedApprovalRuleTemplatesForRepositoryPublisher publisher = client.listAssociatedApprovalRuleTemplatesForRepositoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedApprovalRuleTemplatesForRepository(software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociatedApprovalRuleTemplatesForRepositoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListAssociatedApprovalRuleTemplatesForRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListAssociatedApprovalRuleTemplatesForRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedApprovalRuleTemplatesForRepositoryPublisher listAssociatedApprovalRuleTemplatesForRepositoryPaginator(
            ListAssociatedApprovalRuleTemplatesForRepositoryRequest listAssociatedApprovalRuleTemplatesForRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all approval rule templates that are associated with a specified repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedApprovalRuleTemplatesForRepository(software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListAssociatedApprovalRuleTemplatesForRepositoryPublisher publisher = client.listAssociatedApprovalRuleTemplatesForRepositoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListAssociatedApprovalRuleTemplatesForRepositoryPublisher publisher = client.listAssociatedApprovalRuleTemplatesForRepositoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedApprovalRuleTemplatesForRepository(software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAssociatedApprovalRuleTemplatesForRepositoryRequest.Builder} avoiding the need to create one manually
     * via {@link ListAssociatedApprovalRuleTemplatesForRepositoryRequest#builder()}
     * </p>
     *
     * @param listAssociatedApprovalRuleTemplatesForRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListAssociatedApprovalRuleTemplatesForRepositoryInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListAssociatedApprovalRuleTemplatesForRepository
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListAssociatedApprovalRuleTemplatesForRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedApprovalRuleTemplatesForRepositoryPublisher listAssociatedApprovalRuleTemplatesForRepositoryPaginator(
            Consumer<ListAssociatedApprovalRuleTemplatesForRepositoryRequest.Builder> listAssociatedApprovalRuleTemplatesForRepositoryRequest) {
        return listAssociatedApprovalRuleTemplatesForRepositoryPaginator(ListAssociatedApprovalRuleTemplatesForRepositoryRequest
                .builder().applyMutation(listAssociatedApprovalRuleTemplatesForRepositoryRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more branches in a repository.
     * </p>
     *
     * @param listBranchesRequest
     *        Represents the input of a list branches operation.
     * @return A Java Future containing the result of the ListBranches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBranchesResponse> listBranches(ListBranchesRequest listBranchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more branches in a repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBranchesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBranchesRequest#builder()}
     * </p>
     *
     * @param listBranchesRequest
     *        A {@link Consumer} that will call methods on {@link ListBranchesInput.Builder} to create a request.
     *        Represents the input of a list branches operation.
     * @return A Java Future containing the result of the ListBranches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBranchesResponse> listBranches(Consumer<ListBranchesRequest.Builder> listBranchesRequest) {
        return listBranches(ListBranchesRequest.builder().applyMutation(listBranchesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more branches in a repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBranches(software.amazon.awssdk.services.codecommit.model.ListBranchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListBranchesPublisher publisher = client.listBranchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListBranchesPublisher publisher = client.listBranchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListBranchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListBranchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBranches(software.amazon.awssdk.services.codecommit.model.ListBranchesRequest)} operation.</b>
     * </p>
     *
     * @param listBranchesRequest
     *        Represents the input of a list branches operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBranchesPublisher listBranchesPaginator(ListBranchesRequest listBranchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more branches in a repository.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBranches(software.amazon.awssdk.services.codecommit.model.ListBranchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListBranchesPublisher publisher = client.listBranchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListBranchesPublisher publisher = client.listBranchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListBranchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListBranchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBranches(software.amazon.awssdk.services.codecommit.model.ListBranchesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBranchesRequest.Builder} avoiding the need to
     * create one manually via {@link ListBranchesRequest#builder()}
     * </p>
     *
     * @param listBranchesRequest
     *        A {@link Consumer} that will call methods on {@link ListBranchesInput.Builder} to create a request.
     *        Represents the input of a list branches operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListBranches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBranchesPublisher listBranchesPaginator(Consumer<ListBranchesRequest.Builder> listBranchesRequest) {
        return listBranchesPaginator(ListBranchesRequest.builder().applyMutation(listBranchesRequest).build());
    }

    /**
     * <p>
     * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status
     * or pull request author ARN.
     * </p>
     *
     * @param listPullRequestsRequest
     * @return A Java Future containing the result of the ListPullRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPullRequestStatusException The pull request status is not valid. The only valid values are
     *         <code>OPEN</code> and <code>CLOSED</code>.</li>
     *         <li>InvalidAuthorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the author of the pull request, and then try again.</li>
     *         <li>AuthorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListPullRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPullRequestsResponse> listPullRequests(ListPullRequestsRequest listPullRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status
     * or pull request author ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPullRequestsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPullRequestsRequest#builder()}
     * </p>
     *
     * @param listPullRequestsRequest
     *        A {@link Consumer} that will call methods on {@link ListPullRequestsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListPullRequests operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPullRequestStatusException The pull request status is not valid. The only valid values are
     *         <code>OPEN</code> and <code>CLOSED</code>.</li>
     *         <li>InvalidAuthorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the author of the pull request, and then try again.</li>
     *         <li>AuthorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListPullRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPullRequestsResponse> listPullRequests(
            Consumer<ListPullRequestsRequest.Builder> listPullRequestsRequest) {
        return listPullRequests(ListPullRequestsRequest.builder().applyMutation(listPullRequestsRequest).build());
    }

    /**
     * <p>
     * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status
     * or pull request author ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPullRequests(software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsPublisher publisher = client.listPullRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsPublisher publisher = client.listPullRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPullRequests(software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPullRequestsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPullRequestStatusException The pull request status is not valid. The only valid values are
     *         <code>OPEN</code> and <code>CLOSED</code>.</li>
     *         <li>InvalidAuthorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the author of the pull request, and then try again.</li>
     *         <li>AuthorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListPullRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPullRequestsPublisher listPullRequestsPaginator(ListPullRequestsRequest listPullRequestsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of pull requests for a specified repository. The return list can be refined by pull request status
     * or pull request author ARN.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPullRequests(software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsPublisher publisher = client.listPullRequestsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListPullRequestsPublisher publisher = client.listPullRequestsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPullRequests(software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPullRequestsRequest.Builder} avoiding the need
     * to create one manually via {@link ListPullRequestsRequest#builder()}
     * </p>
     *
     * @param listPullRequestsRequest
     *        A {@link Consumer} that will call methods on {@link ListPullRequestsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPullRequestStatusException The pull request status is not valid. The only valid values are
     *         <code>OPEN</code> and <code>CLOSED</code>.</li>
     *         <li>InvalidAuthorArnException The Amazon Resource Name (ARN) is not valid. Make sure that you have
     *         provided the full ARN for the author of the pull request, and then try again.</li>
     *         <li>AuthorDoesNotExistException The specified Amazon Resource Name (ARN) does not exist in the AWS
     *         account.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListPullRequests
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPullRequestsPublisher listPullRequestsPaginator(Consumer<ListPullRequestsRequest.Builder> listPullRequestsRequest) {
        return listPullRequestsPaginator(ListPullRequestsRequest.builder().applyMutation(listPullRequestsRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more repositories.
     * </p>
     *
     * @param listRepositoriesRequest
     *        Represents the input of a list repositories operation.
     * @return A Java Future containing the result of the ListRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSortByException The specified sort by value is not valid.</li>
     *         <li>InvalidOrderException The specified sort order is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRepositoriesResponse> listRepositories(ListRepositoriesRequest listRepositoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more repositories.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRepositoriesRequest#builder()}
     * </p>
     *
     * @param listRepositoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListRepositoriesInput.Builder} to create a request.
     *        Represents the input of a list repositories operation.
     * @return A Java Future containing the result of the ListRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSortByException The specified sort by value is not valid.</li>
     *         <li>InvalidOrderException The specified sort order is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRepositoriesResponse> listRepositories(
            Consumer<ListRepositoriesRequest.Builder> listRepositoriesRequest) {
        return listRepositories(ListRepositoriesRequest.builder().applyMutation(listRepositoriesRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more repositories.
     * </p>
     *
     * @return A Java Future containing the result of the ListRepositories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSortByException The specified sort by value is not valid.</li>
     *         <li>InvalidOrderException The specified sort order is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListRepositoriesResponse> listRepositories() {
        return listRepositories(ListRepositoriesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all repositories associated with the specified approval rule template.
     * </p>
     *
     * @param listRepositoriesForApprovalRuleTemplateRequest
     * @return A Java Future containing the result of the ListRepositoriesForApprovalRuleTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositoriesForApprovalRuleTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositoriesForApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRepositoriesForApprovalRuleTemplateResponse> listRepositoriesForApprovalRuleTemplate(
            ListRepositoriesForApprovalRuleTemplateRequest listRepositoriesForApprovalRuleTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all repositories associated with the specified approval rule template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRepositoriesForApprovalRuleTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link ListRepositoriesForApprovalRuleTemplateRequest#builder()}
     * </p>
     *
     * @param listRepositoriesForApprovalRuleTemplateRequest
     *        A {@link Consumer} that will call methods on {@link ListRepositoriesForApprovalRuleTemplateInput.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListRepositoriesForApprovalRuleTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositoriesForApprovalRuleTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositoriesForApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRepositoriesForApprovalRuleTemplateResponse> listRepositoriesForApprovalRuleTemplate(
            Consumer<ListRepositoriesForApprovalRuleTemplateRequest.Builder> listRepositoriesForApprovalRuleTemplateRequest) {
        return listRepositoriesForApprovalRuleTemplate(ListRepositoriesForApprovalRuleTemplateRequest.builder()
                .applyMutation(listRepositoriesForApprovalRuleTemplateRequest).build());
    }

    /**
     * <p>
     * Lists all repositories associated with the specified approval rule template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositoriesForApprovalRuleTemplate(software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesForApprovalRuleTemplatePublisher publisher = client.listRepositoriesForApprovalRuleTemplatePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesForApprovalRuleTemplatePublisher publisher = client.listRepositoriesForApprovalRuleTemplatePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositoriesForApprovalRuleTemplate(software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRepositoriesForApprovalRuleTemplateRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositoriesForApprovalRuleTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositoriesForApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositoriesForApprovalRuleTemplatePublisher listRepositoriesForApprovalRuleTemplatePaginator(
            ListRepositoriesForApprovalRuleTemplateRequest listRepositoriesForApprovalRuleTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all repositories associated with the specified approval rule template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositoriesForApprovalRuleTemplate(software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesForApprovalRuleTemplatePublisher publisher = client.listRepositoriesForApprovalRuleTemplatePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesForApprovalRuleTemplatePublisher publisher = client.listRepositoriesForApprovalRuleTemplatePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositoriesForApprovalRuleTemplate(software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRepositoriesForApprovalRuleTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link ListRepositoriesForApprovalRuleTemplateRequest#builder()}
     * </p>
     *
     * @param listRepositoriesForApprovalRuleTemplateRequest
     *        A {@link Consumer} that will call methods on {@link ListRepositoriesForApprovalRuleTemplateInput.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>InvalidMaxResultsException The specified number of maximum results is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositoriesForApprovalRuleTemplate
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositoriesForApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRepositoriesForApprovalRuleTemplatePublisher listRepositoriesForApprovalRuleTemplatePaginator(
            Consumer<ListRepositoriesForApprovalRuleTemplateRequest.Builder> listRepositoriesForApprovalRuleTemplateRequest) {
        return listRepositoriesForApprovalRuleTemplatePaginator(ListRepositoriesForApprovalRuleTemplateRequest.builder()
                .applyMutation(listRepositoriesForApprovalRuleTemplateRequest).build());
    }

    /**
     * <p>
     * Gets information about one or more repositories.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositories(software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositories(software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSortByException The specified sort by value is not valid.</li>
     *         <li>InvalidOrderException The specified sort order is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRepositoriesPublisher listRepositoriesPaginator() {
        return listRepositoriesPaginator(ListRepositoriesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about one or more repositories.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositories(software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositories(software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRepositoriesRequest
     *        Represents the input of a list repositories operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSortByException The specified sort by value is not valid.</li>
     *         <li>InvalidOrderException The specified sort order is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRepositoriesPublisher listRepositoriesPaginator(ListRepositoriesRequest listRepositoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about one or more repositories.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRepositories(software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codecommit.paginators.ListRepositoriesPublisher publisher = client.listRepositoriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRepositories(software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRepositoriesRequest.Builder} avoiding the need
     * to create one manually via {@link ListRepositoriesRequest#builder()}
     * </p>
     *
     * @param listRepositoriesRequest
     *        A {@link Consumer} that will call methods on {@link ListRepositoriesInput.Builder} to create a request.
     *        Represents the input of a list repositories operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidSortByException The specified sort by value is not valid.</li>
     *         <li>InvalidOrderException The specified sort order is not valid.</li>
     *         <li>InvalidContinuationTokenException The specified continuation token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListRepositories
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories" target="_top">AWS
     *      API Documentation</a>
     */
    default ListRepositoriesPublisher listRepositoriesPaginator(Consumer<ListRepositoriesRequest.Builder> listRepositoriesRequest) {
        return listRepositoriesPaginator(ListRepositoriesRequest.builder().applyMutation(listRepositoriesRequest).build());
    }

    /**
     * <p>
     * Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit. For a list of valid
     * resources in AWS CodeCommit, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the<i> AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ResourceArnRequiredException A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is
     *         required. For a list of valid resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>InvalidResourceArnException The value for the resource ARN is not valid. For more information about
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit. For a list of valid
     * resources in AWS CodeCommit, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the<i> AWS CodeCommit User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ResourceArnRequiredException A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is
     *         required. For a list of valid resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>InvalidResourceArnException The value for the resource ARN is not valid. For more information about
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Merges two branches using the fast-forward merge strategy.
     * </p>
     *
     * @param mergeBranchesByFastForwardRequest
     * @return A Java Future containing the result of the MergeBranchesByFastForward operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidTargetBranchException The specified target branch is not valid.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergeBranchesByFastForward
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesByFastForward"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergeBranchesByFastForwardResponse> mergeBranchesByFastForward(
            MergeBranchesByFastForwardRequest mergeBranchesByFastForwardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Merges two branches using the fast-forward merge strategy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MergeBranchesByFastForwardRequest.Builder} avoiding
     * the need to create one manually via {@link MergeBranchesByFastForwardRequest#builder()}
     * </p>
     *
     * @param mergeBranchesByFastForwardRequest
     *        A {@link Consumer} that will call methods on {@link MergeBranchesByFastForwardInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the MergeBranchesByFastForward operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidTargetBranchException The specified target branch is not valid.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergeBranchesByFastForward
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesByFastForward"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergeBranchesByFastForwardResponse> mergeBranchesByFastForward(
            Consumer<MergeBranchesByFastForwardRequest.Builder> mergeBranchesByFastForwardRequest) {
        return mergeBranchesByFastForward(MergeBranchesByFastForwardRequest.builder()
                .applyMutation(mergeBranchesByFastForwardRequest).build());
    }

    /**
     * <p>
     * Merges two branches using the squash merge strategy.
     * </p>
     *
     * @param mergeBranchesBySquashRequest
     * @return A Java Future containing the result of the MergeBranchesBySquash operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidTargetBranchException The specified target branch is not valid.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified, but no replacement content has
     *         been provided.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>FileModeRequiredException The commit cannot be created because no file mode has been specified. A
     *         file mode is required to update mode permissions for a file.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergeBranchesBySquash
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesBySquash"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergeBranchesBySquashResponse> mergeBranchesBySquash(
            MergeBranchesBySquashRequest mergeBranchesBySquashRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Merges two branches using the squash merge strategy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MergeBranchesBySquashRequest.Builder} avoiding the
     * need to create one manually via {@link MergeBranchesBySquashRequest#builder()}
     * </p>
     *
     * @param mergeBranchesBySquashRequest
     *        A {@link Consumer} that will call methods on {@link MergeBranchesBySquashInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the MergeBranchesBySquash operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidTargetBranchException The specified target branch is not valid.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified, but no replacement content has
     *         been provided.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>FileModeRequiredException The commit cannot be created because no file mode has been specified. A
     *         file mode is required to update mode permissions for a file.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergeBranchesBySquash
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesBySquash"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergeBranchesBySquashResponse> mergeBranchesBySquash(
            Consumer<MergeBranchesBySquashRequest.Builder> mergeBranchesBySquashRequest) {
        return mergeBranchesBySquash(MergeBranchesBySquashRequest.builder().applyMutation(mergeBranchesBySquashRequest).build());
    }

    /**
     * <p>
     * Merges two specified branches using the three-way merge strategy.
     * </p>
     *
     * @param mergeBranchesByThreeWayRequest
     * @return A Java Future containing the result of the MergeBranchesByThreeWay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidTargetBranchException The specified target branch is not valid.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified, but no replacement content has
     *         been provided.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>FileModeRequiredException The commit cannot be created because no file mode has been specified. A
     *         file mode is required to update mode permissions for a file.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergeBranchesByThreeWay
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesByThreeWay"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergeBranchesByThreeWayResponse> mergeBranchesByThreeWay(
            MergeBranchesByThreeWayRequest mergeBranchesByThreeWayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Merges two specified branches using the three-way merge strategy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MergeBranchesByThreeWayRequest.Builder} avoiding
     * the need to create one manually via {@link MergeBranchesByThreeWayRequest#builder()}
     * </p>
     *
     * @param mergeBranchesByThreeWayRequest
     *        A {@link Consumer} that will call methods on {@link MergeBranchesByThreeWayInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the MergeBranchesByThreeWay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>CommitRequiredException A commit was not specified.</li>
     *         <li>InvalidCommitException The specified commit is not valid.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidTargetBranchException The specified target branch is not valid.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified, but no replacement content has
     *         been provided.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>FileModeRequiredException The commit cannot be created because no file mode has been specified. A
     *         file mode is required to update mode permissions for a file.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergeBranchesByThreeWay
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergeBranchesByThreeWay"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergeBranchesByThreeWayResponse> mergeBranchesByThreeWay(
            Consumer<MergeBranchesByThreeWayRequest.Builder> mergeBranchesByThreeWayRequest) {
        return mergeBranchesByThreeWay(MergeBranchesByThreeWayRequest.builder().applyMutation(mergeBranchesByThreeWayRequest)
                .build());
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull
     * request.
     * </p>
     *
     * @param mergePullRequestByFastForwardRequest
     * @return A Java Future containing the result of the MergePullRequestByFastForward operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>TipOfSourceReferenceIsDifferentException The tip of the source branch in the destination repository
     *         does not match the tip of the source branch specified in your request. The pull request might have been
     *         updated. Make sure that you have the latest changes.</li>
     *         <li>ReferenceDoesNotExistException The specified reference does not exist. You must provide a full commit
     *         ID.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>PullRequestApprovalRulesNotSatisfiedException The pull request cannot be merged because one or more
     *         approval rules applied to the pull request have conditions that have not been met.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergePullRequestByFastForward
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestByFastForward"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergePullRequestByFastForwardResponse> mergePullRequestByFastForward(
            MergePullRequestByFastForwardRequest mergePullRequestByFastForwardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MergePullRequestByFastForwardRequest.Builder}
     * avoiding the need to create one manually via {@link MergePullRequestByFastForwardRequest#builder()}
     * </p>
     *
     * @param mergePullRequestByFastForwardRequest
     *        A {@link Consumer} that will call methods on {@link MergePullRequestByFastForwardInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the MergePullRequestByFastForward operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>TipOfSourceReferenceIsDifferentException The tip of the source branch in the destination repository
     *         does not match the tip of the source branch specified in your request. The pull request might have been
     *         updated. Make sure that you have the latest changes.</li>
     *         <li>ReferenceDoesNotExistException The specified reference does not exist. You must provide a full commit
     *         ID.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>PullRequestApprovalRulesNotSatisfiedException The pull request cannot be merged because one or more
     *         approval rules applied to the pull request have conditions that have not been met.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergePullRequestByFastForward
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestByFastForward"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergePullRequestByFastForwardResponse> mergePullRequestByFastForward(
            Consumer<MergePullRequestByFastForwardRequest.Builder> mergePullRequestByFastForwardRequest) {
        return mergePullRequestByFastForward(MergePullRequestByFastForwardRequest.builder()
                .applyMutation(mergePullRequestByFastForwardRequest).build());
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.
     * </p>
     *
     * @param mergePullRequestBySquashRequest
     * @return A Java Future containing the result of the MergePullRequestBySquash operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>TipOfSourceReferenceIsDifferentException The tip of the source branch in the destination repository
     *         does not match the tip of the source branch specified in your request. The pull request might have been
     *         updated. Make sure that you have the latest changes.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified, but no replacement content has
     *         been provided.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>PullRequestApprovalRulesNotSatisfiedException The pull request cannot be merged because one or more
     *         approval rules applied to the pull request have conditions that have not been met.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergePullRequestBySquash
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestBySquash"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergePullRequestBySquashResponse> mergePullRequestBySquash(
            MergePullRequestBySquashRequest mergePullRequestBySquashRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MergePullRequestBySquashRequest.Builder} avoiding
     * the need to create one manually via {@link MergePullRequestBySquashRequest#builder()}
     * </p>
     *
     * @param mergePullRequestBySquashRequest
     *        A {@link Consumer} that will call methods on {@link MergePullRequestBySquashInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the MergePullRequestBySquash operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>TipOfSourceReferenceIsDifferentException The tip of the source branch in the destination repository
     *         does not match the tip of the source branch specified in your request. The pull request might have been
     *         updated. Make sure that you have the latest changes.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified, but no replacement content has
     *         been provided.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>PullRequestApprovalRulesNotSatisfiedException The pull request cannot be merged because one or more
     *         approval rules applied to the pull request have conditions that have not been met.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergePullRequestBySquash
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestBySquash"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergePullRequestBySquashResponse> mergePullRequestBySquash(
            Consumer<MergePullRequestBySquashRequest.Builder> mergePullRequestBySquashRequest) {
        return mergePullRequestBySquash(MergePullRequestBySquashRequest.builder().applyMutation(mergePullRequestBySquashRequest)
                .build());
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull
     * request.
     * </p>
     *
     * @param mergePullRequestByThreeWayRequest
     * @return A Java Future containing the result of the MergePullRequestByThreeWay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>TipOfSourceReferenceIsDifferentException The tip of the source branch in the destination repository
     *         does not match the tip of the source branch specified in your request. The pull request might have been
     *         updated. Make sure that you have the latest changes.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified, but no replacement content has
     *         been provided.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>PullRequestApprovalRulesNotSatisfiedException The pull request cannot be merged because one or more
     *         approval rules applied to the pull request have conditions that have not been met.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergePullRequestByThreeWay
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestByThreeWay"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergePullRequestByThreeWayResponse> mergePullRequestByThreeWay(
            MergePullRequestByThreeWayRequest mergePullRequestByThreeWayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to merge the source commit of a pull request into the specified destination branch for that pull request
     * at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull
     * request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MergePullRequestByThreeWayRequest.Builder} avoiding
     * the need to create one manually via {@link MergePullRequestByThreeWayRequest#builder()}
     * </p>
     *
     * @param mergePullRequestByThreeWayRequest
     *        A {@link Consumer} that will call methods on {@link MergePullRequestByThreeWayInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the MergePullRequestByThreeWay operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>ManualMergeRequiredException The pull request cannot be merged automatically into the destination
     *         branch. You must manually merge the branches and resolve any conflicts.</li>
     *         <li>TipOfSourceReferenceIsDifferentException The tip of the source branch in the destination repository
     *         does not match the tip of the source branch specified in your request. The pull request might have been
     *         updated. Make sure that you have the latest changes.</li>
     *         <li>TipsDivergenceExceededException The divergence between the tips of the provided commit specifiers is
     *         too great to determine whether there might be any merge conflicts. Locally compare the specifiers using
     *         <code>git diff</code> or a diff tool.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>InvalidConflictDetailLevelException The specified conflict detail level is not valid.</li>
     *         <li>InvalidConflictResolutionStrategyException The specified conflict resolution strategy is not valid.</li>
     *         <li>InvalidConflictResolutionException The specified conflict resolution list is not valid.</li>
     *         <li>ReplacementTypeRequiredException A replacement type is required.</li>
     *         <li>InvalidReplacementTypeException Automerge was specified for resolving the conflict, but the specified
     *         replacement type is not valid.</li>
     *         <li>MultipleConflictResolutionEntriesException More than one conflict resolution entries exists for the
     *         conflict. A conflict can have only one conflict resolution entry.</li>
     *         <li>ReplacementContentRequiredException USE_NEW_CONTENT was specified, but no replacement content has
     *         been provided.</li>
     *         <li>MaximumConflictResolutionEntriesExceededException The number of allowed conflict resolution entries
     *         was exceeded.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>InvalidReplacementContentException Automerge was specified for resolving the conflict, but the
     *         replacement type is not valid or content is missing.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>MaximumFileContentToLoadExceededException The number of files to load exceeds the allowed limit.</li>
     *         <li>MaximumItemsToCompareExceededException The number of items to compare between the source or
     *         destination branches and the merge base has exceeded the maximum allowed.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>ConcurrentReferenceUpdateException The merge cannot be completed because the target branch has been
     *         modified. Another user might have modified the target branch while the merge was in progress. Wait a few
     *         minutes, and then try again.</li>
     *         <li>PullRequestApprovalRulesNotSatisfiedException The pull request cannot be merged because one or more
     *         approval rules applied to the pull request have conditions that have not been met.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.MergePullRequestByThreeWay
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestByThreeWay"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<MergePullRequestByThreeWayResponse> mergePullRequestByThreeWay(
            Consumer<MergePullRequestByThreeWayRequest.Builder> mergePullRequestByThreeWayRequest) {
        return mergePullRequestByThreeWay(MergePullRequestByThreeWayRequest.builder()
                .applyMutation(mergePullRequestByThreeWayRequest).build());
    }

    /**
     * <p>
     * Sets aside (overrides) all approval rule requirements for a specified pull request.
     * </p>
     *
     * @param overridePullRequestApprovalRulesRequest
     * @return A Java Future containing the result of the OverridePullRequestApprovalRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidRevisionIdException The revision ID is not valid. Use GetPullRequest to determine the value.</li>
     *         <li>RevisionIdRequiredException A revision ID is required, but was not provided.</li>
     *         <li>InvalidOverrideStatusException The override status is not valid. Valid statuses are OVERRIDE and
     *         REVOKE.</li>
     *         <li>OverrideStatusRequiredException An override status is required, but no value was provided. Valid
     *         values include OVERRIDE and REVOKE.</li>
     *         <li>OverrideAlreadySetException The pull request has already had its approval rules set to override.</li>
     *         <li>RevisionNotCurrentException The revision ID provided in the request does not match the current
     *         revision ID. Use GetPullRequest to retrieve the current revision ID.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.OverridePullRequestApprovalRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/OverridePullRequestApprovalRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OverridePullRequestApprovalRulesResponse> overridePullRequestApprovalRules(
            OverridePullRequestApprovalRulesRequest overridePullRequestApprovalRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets aside (overrides) all approval rule requirements for a specified pull request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OverridePullRequestApprovalRulesRequest.Builder}
     * avoiding the need to create one manually via {@link OverridePullRequestApprovalRulesRequest#builder()}
     * </p>
     *
     * @param overridePullRequestApprovalRulesRequest
     *        A {@link Consumer} that will call methods on {@link OverridePullRequestApprovalRulesInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the OverridePullRequestApprovalRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidRevisionIdException The revision ID is not valid. Use GetPullRequest to determine the value.</li>
     *         <li>RevisionIdRequiredException A revision ID is required, but was not provided.</li>
     *         <li>InvalidOverrideStatusException The override status is not valid. Valid statuses are OVERRIDE and
     *         REVOKE.</li>
     *         <li>OverrideStatusRequiredException An override status is required, but no value was provided. Valid
     *         values include OVERRIDE and REVOKE.</li>
     *         <li>OverrideAlreadySetException The pull request has already had its approval rules set to override.</li>
     *         <li>RevisionNotCurrentException The revision ID provided in the request does not match the current
     *         revision ID. Use GetPullRequest to retrieve the current revision ID.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.OverridePullRequestApprovalRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/OverridePullRequestApprovalRules"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<OverridePullRequestApprovalRulesResponse> overridePullRequestApprovalRules(
            Consumer<OverridePullRequestApprovalRulesRequest.Builder> overridePullRequestApprovalRulesRequest) {
        return overridePullRequestApprovalRules(OverridePullRequestApprovalRulesRequest.builder()
                .applyMutation(overridePullRequestApprovalRulesRequest).build());
    }

    /**
     * <p>
     * Posts a comment on the comparison between two commits.
     * </p>
     *
     * @param postCommentForComparedCommitRequest
     * @return A Java Future containing the result of the PostCommentForComparedCommit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be reused.</li>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>InvalidFileLocationException The location of the file is not valid. Make sure that you include the
     *         file name and extension.</li>
     *         <li>InvalidRelativeFileVersionEnumException Either the enum is not in a valid format, or the specified
     *         file version enum is not valid in respect to the current file version.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidFilePositionException The position is not valid. Make sure that the line number exists in the
     *         version of the file you want to comment on.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>BeforeCommitIdAndAfterCommitIdAreSameException The before commit ID and the after commit ID are the
     *         same, which is not valid. The before commit ID and the after commit ID must be different commit IDs.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PostCommentForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostCommentForComparedCommitResponse> postCommentForComparedCommit(
            PostCommentForComparedCommitRequest postCommentForComparedCommitRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Posts a comment on the comparison between two commits.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostCommentForComparedCommitRequest.Builder}
     * avoiding the need to create one manually via {@link PostCommentForComparedCommitRequest#builder()}
     * </p>
     *
     * @param postCommentForComparedCommitRequest
     *        A {@link Consumer} that will call methods on {@link PostCommentForComparedCommitInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PostCommentForComparedCommit operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be reused.</li>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>InvalidFileLocationException The location of the file is not valid. Make sure that you include the
     *         file name and extension.</li>
     *         <li>InvalidRelativeFileVersionEnumException Either the enum is not in a valid format, or the specified
     *         file version enum is not valid in respect to the current file version.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidFilePositionException The position is not valid. Make sure that the line number exists in the
     *         version of the file you want to comment on.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>BeforeCommitIdAndAfterCommitIdAreSameException The before commit ID and the after commit ID are the
     *         same, which is not valid. The before commit ID and the after commit ID must be different commit IDs.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PostCommentForComparedCommit
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForComparedCommit"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostCommentForComparedCommitResponse> postCommentForComparedCommit(
            Consumer<PostCommentForComparedCommitRequest.Builder> postCommentForComparedCommitRequest) {
        return postCommentForComparedCommit(PostCommentForComparedCommitRequest.builder()
                .applyMutation(postCommentForComparedCommitRequest).build());
    }

    /**
     * <p>
     * Posts a comment on a pull request.
     * </p>
     *
     * @param postCommentForPullRequestRequest
     * @return A Java Future containing the result of the PostCommentForPullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be reused.</li>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>InvalidFileLocationException The location of the file is not valid. Make sure that you include the
     *         file name and extension.</li>
     *         <li>InvalidRelativeFileVersionEnumException Either the enum is not in a valid format, or the specified
     *         file version enum is not valid in respect to the current file version.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidFilePositionException The position is not valid. Make sure that the line number exists in the
     *         version of the file you want to comment on.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>BeforeCommitIdAndAfterCommitIdAreSameException The before commit ID and the after commit ID are the
     *         same, which is not valid. The before commit ID and the after commit ID must be different commit IDs.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PostCommentForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostCommentForPullRequestResponse> postCommentForPullRequest(
            PostCommentForPullRequestRequest postCommentForPullRequestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Posts a comment on a pull request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostCommentForPullRequestRequest.Builder} avoiding
     * the need to create one manually via {@link PostCommentForPullRequestRequest#builder()}
     * </p>
     *
     * @param postCommentForPullRequestRequest
     *        A {@link Consumer} that will call methods on {@link PostCommentForPullRequestInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PostCommentForPullRequest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>RepositoryNotAssociatedWithPullRequestException The repository does not contain any pull requests
     *         with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request
     *         ID.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be reused.</li>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>InvalidFileLocationException The location of the file is not valid. Make sure that you include the
     *         file name and extension.</li>
     *         <li>InvalidRelativeFileVersionEnumException Either the enum is not in a valid format, or the specified
     *         file version enum is not valid in respect to the current file version.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidFilePositionException The position is not valid. Make sure that the line number exists in the
     *         version of the file you want to comment on.</li>
     *         <li>CommitIdRequiredException A commit ID was not specified.</li>
     *         <li>InvalidCommitIdException The specified commit ID is not valid.</li>
     *         <li>BeforeCommitIdAndAfterCommitIdAreSameException The before commit ID and the after commit ID are the
     *         same, which is not valid. The before commit ID and the after commit ID must be different commit IDs.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>CommitDoesNotExistException The specified commit does not exist or no commit was specified, and the
     *         specified repository has no default branch.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>PathDoesNotExistException The specified path does not exist.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PostCommentForPullRequest
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForPullRequest"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostCommentForPullRequestResponse> postCommentForPullRequest(
            Consumer<PostCommentForPullRequestRequest.Builder> postCommentForPullRequestRequest) {
        return postCommentForPullRequest(PostCommentForPullRequestRequest.builder()
                .applyMutation(postCommentForPullRequestRequest).build());
    }

    /**
     * <p>
     * Posts a comment in reply to an existing comment on a comparison between commits or a pull request.
     * </p>
     *
     * @param postCommentReplyRequest
     * @return A Java Future containing the result of the PostCommentReply operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be reused.</li>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PostCommentReply
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentReply" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PostCommentReplyResponse> postCommentReply(PostCommentReplyRequest postCommentReplyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Posts a comment in reply to an existing comment on a comparison between commits or a pull request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostCommentReplyRequest.Builder} avoiding the need
     * to create one manually via {@link PostCommentReplyRequest#builder()}
     * </p>
     *
     * @param postCommentReplyRequest
     *        A {@link Consumer} that will call methods on {@link PostCommentReplyInput.Builder} to create a request.
     * @return A Java Future containing the result of the PostCommentReply operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ClientRequestTokenRequiredException A client request token is required. A client request token is an
     *         unique, client-generated idempotency token that, when provided in a request, ensures the request cannot
     *         be repeated with a changed parameter. If a request is received with the same parameters and a token is
     *         included, the request returns information about the initial request that used that token.</li>
     *         <li>InvalidClientRequestTokenException The client request token is not valid.</li>
     *         <li>IdempotencyParameterMismatchException The client request token is not valid. Either the token is not
     *         in a valid format, or the token has been used in a previous request and cannot be reused.</li>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PostCommentReply
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentReply" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PostCommentReplyResponse> postCommentReply(
            Consumer<PostCommentReplyRequest.Builder> postCommentReplyRequest) {
        return postCommentReply(PostCommentReplyRequest.builder().applyMutation(postCommentReplyRequest).build());
    }

    /**
     * <p>
     * Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You
     * can only add or update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.
     * </p>
     *
     * @param putCommentReactionRequest
     * @return A Java Future containing the result of the PutCommentReaction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>InvalidReactionValueException The value of the reaction is not valid. For more information, see the
     *         <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit User
     *         Guide</a>.</li>
     *         <li>ReactionValueRequiredException A reaction value is required.</li>
     *         <li>ReactionLimitExceededException The number of reactions has been exceeded. Reactions are limited to
     *         one reaction per user for each individual comment ID.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PutCommentReaction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutCommentReaction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutCommentReactionResponse> putCommentReaction(PutCommentReactionRequest putCommentReactionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You
     * can only add or update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutCommentReactionRequest.Builder} avoiding the
     * need to create one manually via {@link PutCommentReactionRequest#builder()}
     * </p>
     *
     * @param putCommentReactionRequest
     *        A {@link Consumer} that will call methods on {@link PutCommentReactionInput.Builder} to create a request.
     * @return A Java Future containing the result of the PutCommentReaction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>InvalidReactionValueException The value of the reaction is not valid. For more information, see the
     *         <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit User
     *         Guide</a>.</li>
     *         <li>ReactionValueRequiredException A reaction value is required.</li>
     *         <li>ReactionLimitExceededException The number of reactions has been exceeded. Reactions are limited to
     *         one reaction per user for each individual comment ID.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PutCommentReaction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutCommentReaction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutCommentReactionResponse> putCommentReaction(
            Consumer<PutCommentReactionRequest.Builder> putCommentReactionRequest) {
        return putCommentReaction(PutCommentReactionRequest.builder().applyMutation(putCommentReactionRequest).build());
    }

    /**
     * <p>
     * Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in
     * the specified branch.
     * </p>
     *
     * @param putFileRequest
     * @return A Java Future containing the result of the PutFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ParentCommitIdRequiredException A parent commit ID is required. To view the full commit ID of a
     *         branch in a repository, use <a>GetBranch</a> or a Git command (for example, git pull or git log).</li>
     *         <li>InvalidParentCommitIdException The parent commit ID is not valid. The commit ID cannot be empty, and
     *         must match the head commit ID for the branch of the repository where you want to add or update a file.</li>
     *         <li>ParentCommitDoesNotExistException The parent commit ID is not valid because it does not exist. The
     *         specified parent commit ID does not exist in the specified branch of the repository.</li>
     *         <li>ParentCommitIdOutdatedException The file could not be added because the provided parent commit ID is
     *         not the current tip of the specified branch. To view the full commit ID of the current head of the
     *         branch, use <a>GetBranch</a>.</li>
     *         <li>FileContentRequiredException The file cannot be added because it is empty. Empty files cannot be
     *         added to the repository with this API.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>InvalidDeletionParameterException The specified deletion parameter is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SameFileContentException The file was not added or updated because the content of the file is exactly
     *         the same as the content of that file in the repository and branch that you specified.</li>
     *         <li>FileNameConflictsWithDirectoryNameException A file cannot be added to the repository because the
     *         specified file name has the same name as a directory in this repository. Either provide another name for
     *         the file, or add the file in a directory that does not match the file name.</li>
     *         <li>DirectoryNameConflictsWithFileNameException A file cannot be added to the repository because the
     *         specified path name has the same name as a file that already exists in this repository. Either provide a
     *         different name for the file, or specify a different path for the file.</li>
     *         <li>FilePathConflictsWithSubmodulePathException The commit cannot be created because a specified file
     *         path points to a submodule. Verify that the destination files have valid file paths that do not point to
     *         a submodule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PutFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutFile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutFileResponse> putFile(PutFileRequest putFileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in
     * the specified branch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFileRequest.Builder} avoiding the need to create
     * one manually via {@link PutFileRequest#builder()}
     * </p>
     *
     * @param putFileRequest
     *        A {@link Consumer} that will call methods on {@link PutFileInput.Builder} to create a request.
     * @return A Java Future containing the result of the PutFile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>ParentCommitIdRequiredException A parent commit ID is required. To view the full commit ID of a
     *         branch in a repository, use <a>GetBranch</a> or a Git command (for example, git pull or git log).</li>
     *         <li>InvalidParentCommitIdException The parent commit ID is not valid. The commit ID cannot be empty, and
     *         must match the head commit ID for the branch of the repository where you want to add or update a file.</li>
     *         <li>ParentCommitDoesNotExistException The parent commit ID is not valid because it does not exist. The
     *         specified parent commit ID does not exist in the specified branch of the repository.</li>
     *         <li>ParentCommitIdOutdatedException The file could not be added because the provided parent commit ID is
     *         not the current tip of the specified branch. To view the full commit ID of the current head of the
     *         branch, use <a>GetBranch</a>.</li>
     *         <li>FileContentRequiredException The file cannot be added because it is empty. Empty files cannot be
     *         added to the repository with this API.</li>
     *         <li>FileContentSizeLimitExceededException The file cannot be added because it is too large. The maximum
     *         file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using
     *         a Git client.</li>
     *         <li>FolderContentSizeLimitExceededException The commit cannot be created because at least one of the
     *         overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce
     *         the number and size of your changes, or split the changes across multiple folders.</li>
     *         <li>PathRequiredException The folderPath for a location cannot be null.</li>
     *         <li>InvalidPathException The specified path is not valid.</li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>BranchNameIsTagNameException The specified branch name is not valid because it is a tag name. Enter
     *         the name of a branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</li>
     *         <li>InvalidFileModeException The specified file mode permission is not valid. For a list of valid file
     *         mode permissions, see <a>PutFile</a>.</li>
     *         <li>NameLengthExceededException The user name is not valid because it has exceeded the character limit
     *         for author names.</li>
     *         <li>InvalidEmailException The specified email address either contains one or more characters that are not
     *         allowed, or it exceeds the maximum number of characters allowed for an email address.</li>
     *         <li>CommitMessageLengthExceededException The commit message is too long. Provide a shorter string.</li>
     *         <li>InvalidDeletionParameterException The specified deletion parameter is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SameFileContentException The file was not added or updated because the content of the file is exactly
     *         the same as the content of that file in the repository and branch that you specified.</li>
     *         <li>FileNameConflictsWithDirectoryNameException A file cannot be added to the repository because the
     *         specified file name has the same name as a directory in this repository. Either provide another name for
     *         the file, or add the file in a directory that does not match the file name.</li>
     *         <li>DirectoryNameConflictsWithFileNameException A file cannot be added to the repository because the
     *         specified path name has the same name as a file that already exists in this repository. Either provide a
     *         different name for the file, or specify a different path for the file.</li>
     *         <li>FilePathConflictsWithSubmodulePathException The commit cannot be created because a specified file
     *         path points to a submodule. Verify that the destination files have valid file paths that do not point to
     *         a submodule.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PutFile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutFile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutFileResponse> putFile(Consumer<PutFileRequest.Builder> putFileRequest) {
        return putFile(PutFileRequest.builder().applyMutation(putFileRequest).build());
    }

    /**
     * <p>
     * Replaces all triggers for a repository. Used to create or delete triggers.
     * </p>
     *
     * @param putRepositoryTriggersRequest
     *        Represents the input of a put repository triggers operation.
     * @return A Java Future containing the result of the PutRepositoryTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryTriggersListRequiredException The list of triggers for the repository is required, but was
     *         not specified.</li>
     *         <li>MaximumRepositoryTriggersExceededException The number of triggers allowed for the repository was
     *         exceeded.</li>
     *         <li>InvalidRepositoryTriggerNameException The name of the trigger is not valid.</li>
     *         <li>InvalidRepositoryTriggerDestinationArnException The Amazon Resource Name (ARN) for the trigger is not
     *         valid for the specified destination. The most common reason for this error is that the ARN does not meet
     *         the requirements for the service type.</li>
     *         <li>InvalidRepositoryTriggerRegionException The AWS Region for the trigger target does not match the AWS
     *         Region for the repository. Triggers must be created in the same Region as the target for the trigger.</li>
     *         <li>InvalidRepositoryTriggerCustomDataException The custom data provided for the trigger is not valid.</li>
     *         <li>MaximumBranchesExceededException The number of branches for the trigger was exceeded.</li>
     *         <li>InvalidRepositoryTriggerBranchNameException One or more branch names specified for the trigger is not
     *         valid.</li>
     *         <li>InvalidRepositoryTriggerEventsException One or more events specified for the trigger is not valid.
     *         Check to make sure that all events specified match the requirements for allowed events.</li>
     *         <li>RepositoryTriggerNameRequiredException A name for the trigger is required, but was not specified.</li>
     *         <li>RepositoryTriggerDestinationArnRequiredException A destination ARN for the target service for the
     *         trigger is required, but was not specified.</li>
     *         <li>RepositoryTriggerBranchNameListRequiredException At least one branch name is required, but was not
     *         specified in the trigger configuration.</li>
     *         <li>RepositoryTriggerEventsListRequiredException At least one event for the trigger is required, but was
     *         not specified.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PutRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRepositoryTriggersResponse> putRepositoryTriggers(
            PutRepositoryTriggersRequest putRepositoryTriggersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces all triggers for a repository. Used to create or delete triggers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRepositoryTriggersRequest.Builder} avoiding the
     * need to create one manually via {@link PutRepositoryTriggersRequest#builder()}
     * </p>
     *
     * @param putRepositoryTriggersRequest
     *        A {@link Consumer} that will call methods on {@link PutRepositoryTriggersInput.Builder} to create a
     *        request. Represents the input of a put repository triggers operation.
     * @return A Java Future containing the result of the PutRepositoryTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryTriggersListRequiredException The list of triggers for the repository is required, but was
     *         not specified.</li>
     *         <li>MaximumRepositoryTriggersExceededException The number of triggers allowed for the repository was
     *         exceeded.</li>
     *         <li>InvalidRepositoryTriggerNameException The name of the trigger is not valid.</li>
     *         <li>InvalidRepositoryTriggerDestinationArnException The Amazon Resource Name (ARN) for the trigger is not
     *         valid for the specified destination. The most common reason for this error is that the ARN does not meet
     *         the requirements for the service type.</li>
     *         <li>InvalidRepositoryTriggerRegionException The AWS Region for the trigger target does not match the AWS
     *         Region for the repository. Triggers must be created in the same Region as the target for the trigger.</li>
     *         <li>InvalidRepositoryTriggerCustomDataException The custom data provided for the trigger is not valid.</li>
     *         <li>MaximumBranchesExceededException The number of branches for the trigger was exceeded.</li>
     *         <li>InvalidRepositoryTriggerBranchNameException One or more branch names specified for the trigger is not
     *         valid.</li>
     *         <li>InvalidRepositoryTriggerEventsException One or more events specified for the trigger is not valid.
     *         Check to make sure that all events specified match the requirements for allowed events.</li>
     *         <li>RepositoryTriggerNameRequiredException A name for the trigger is required, but was not specified.</li>
     *         <li>RepositoryTriggerDestinationArnRequiredException A destination ARN for the target service for the
     *         trigger is required, but was not specified.</li>
     *         <li>RepositoryTriggerBranchNameListRequiredException At least one branch name is required, but was not
     *         specified in the trigger configuration.</li>
     *         <li>RepositoryTriggerEventsListRequiredException At least one event for the trigger is required, but was
     *         not specified.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.PutRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutRepositoryTriggersResponse> putRepositoryTriggers(
            Consumer<PutRepositoryTriggersRequest.Builder> putRepositoryTriggersRequest) {
        return putRepositoryTriggers(PutRepositoryTriggersRequest.builder().applyMutation(putRepositoryTriggersRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a
     * href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ResourceArnRequiredException A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is
     *         required. For a list of valid resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>InvalidResourceArnException The value for the resource ARN is not valid. For more information about
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>TagsMapRequiredException A map of tags is required.</li>
     *         <li>InvalidTagsMapException The map of tags is not valid.</li>
     *         <li>TooManyTagsException The maximum number of tags for an AWS CodeCommit resource has been exceeded.</li>
     *         <li>InvalidSystemTagUsageException The specified tag is not valid. Key names cannot be prefixed with
     *         aws:.</li>
     *         <li>TagPolicyException The tag policy is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a
     * href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ResourceArnRequiredException A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is
     *         required. For a list of valid resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>InvalidResourceArnException The value for the resource ARN is not valid. For more information about
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>TagsMapRequiredException A map of tags is required.</li>
     *         <li>InvalidTagsMapException The map of tags is not valid.</li>
     *         <li>TooManyTagsException The maximum number of tags for an AWS CodeCommit resource has been exceeded.</li>
     *         <li>InvalidSystemTagUsageException The specified tag is not valid. Key names cannot be prefixed with
     *         aws:.</li>
     *         <li>TagPolicyException The tag policy is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests the functionality of repository triggers by sending information to the trigger target. If real data is
     * available in the repository, the test sends data from the last commit. If no data is available, sample data is
     * generated.
     * </p>
     *
     * @param testRepositoryTriggersRequest
     *        Represents the input of a test repository triggers operation.
     * @return A Java Future containing the result of the TestRepositoryTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryTriggersListRequiredException The list of triggers for the repository is required, but was
     *         not specified.</li>
     *         <li>MaximumRepositoryTriggersExceededException The number of triggers allowed for the repository was
     *         exceeded.</li>
     *         <li>InvalidRepositoryTriggerNameException The name of the trigger is not valid.</li>
     *         <li>InvalidRepositoryTriggerDestinationArnException The Amazon Resource Name (ARN) for the trigger is not
     *         valid for the specified destination. The most common reason for this error is that the ARN does not meet
     *         the requirements for the service type.</li>
     *         <li>InvalidRepositoryTriggerRegionException The AWS Region for the trigger target does not match the AWS
     *         Region for the repository. Triggers must be created in the same Region as the target for the trigger.</li>
     *         <li>InvalidRepositoryTriggerCustomDataException The custom data provided for the trigger is not valid.</li>
     *         <li>MaximumBranchesExceededException The number of branches for the trigger was exceeded.</li>
     *         <li>InvalidRepositoryTriggerBranchNameException One or more branch names specified for the trigger is not
     *         valid.</li>
     *         <li>InvalidRepositoryTriggerEventsException One or more events specified for the trigger is not valid.
     *         Check to make sure that all events specified match the requirements for allowed events.</li>
     *         <li>RepositoryTriggerNameRequiredException A name for the trigger is required, but was not specified.</li>
     *         <li>RepositoryTriggerDestinationArnRequiredException A destination ARN for the target service for the
     *         trigger is required, but was not specified.</li>
     *         <li>RepositoryTriggerBranchNameListRequiredException At least one branch name is required, but was not
     *         specified in the trigger configuration.</li>
     *         <li>RepositoryTriggerEventsListRequiredException At least one event for the trigger is required, but was
     *         not specified.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.TestRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TestRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestRepositoryTriggersResponse> testRepositoryTriggers(
            TestRepositoryTriggersRequest testRepositoryTriggersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests the functionality of repository triggers by sending information to the trigger target. If real data is
     * available in the repository, the test sends data from the last commit. If no data is available, sample data is
     * generated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestRepositoryTriggersRequest.Builder} avoiding the
     * need to create one manually via {@link TestRepositoryTriggersRequest#builder()}
     * </p>
     *
     * @param testRepositoryTriggersRequest
     *        A {@link Consumer} that will call methods on {@link TestRepositoryTriggersInput.Builder} to create a
     *        request. Represents the input of a test repository triggers operation.
     * @return A Java Future containing the result of the TestRepositoryTriggers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>RepositoryTriggersListRequiredException The list of triggers for the repository is required, but was
     *         not specified.</li>
     *         <li>MaximumRepositoryTriggersExceededException The number of triggers allowed for the repository was
     *         exceeded.</li>
     *         <li>InvalidRepositoryTriggerNameException The name of the trigger is not valid.</li>
     *         <li>InvalidRepositoryTriggerDestinationArnException The Amazon Resource Name (ARN) for the trigger is not
     *         valid for the specified destination. The most common reason for this error is that the ARN does not meet
     *         the requirements for the service type.</li>
     *         <li>InvalidRepositoryTriggerRegionException The AWS Region for the trigger target does not match the AWS
     *         Region for the repository. Triggers must be created in the same Region as the target for the trigger.</li>
     *         <li>InvalidRepositoryTriggerCustomDataException The custom data provided for the trigger is not valid.</li>
     *         <li>MaximumBranchesExceededException The number of branches for the trigger was exceeded.</li>
     *         <li>InvalidRepositoryTriggerBranchNameException One or more branch names specified for the trigger is not
     *         valid.</li>
     *         <li>InvalidRepositoryTriggerEventsException One or more events specified for the trigger is not valid.
     *         Check to make sure that all events specified match the requirements for allowed events.</li>
     *         <li>RepositoryTriggerNameRequiredException A name for the trigger is required, but was not specified.</li>
     *         <li>RepositoryTriggerDestinationArnRequiredException A destination ARN for the target service for the
     *         trigger is required, but was not specified.</li>
     *         <li>RepositoryTriggerBranchNameListRequiredException At least one branch name is required, but was not
     *         specified in the trigger configuration.</li>
     *         <li>RepositoryTriggerEventsListRequiredException At least one event for the trigger is required, but was
     *         not specified.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.TestRepositoryTriggers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TestRepositoryTriggers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TestRepositoryTriggersResponse> testRepositoryTriggers(
            Consumer<TestRepositoryTriggersRequest.Builder> testRepositoryTriggersRequest) {
        return testRepositoryTriggers(TestRepositoryTriggersRequest.builder().applyMutation(testRepositoryTriggersRequest)
                .build());
    }

    /**
     * <p>
     * Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ResourceArnRequiredException A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is
     *         required. For a list of valid resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>InvalidResourceArnException The value for the resource ARN is not valid. For more information about
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>TagKeysListRequiredException A list of tag keys is required. The list cannot be empty or null.</li>
     *         <li>InvalidTagKeysListException The list of tags is not valid.</li>
     *         <li>TooManyTagsException The maximum number of tags for an AWS CodeCommit resource has been exceeded.</li>
     *         <li>InvalidSystemTagUsageException The specified tag is not valid. Key names cannot be prefixed with
     *         aws:.</li>
     *         <li>TagPolicyException The tag policy is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     * >CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>ResourceArnRequiredException A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is
     *         required. For a list of valid resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>InvalidResourceArnException The value for the resource ARN is not valid. For more information about
     *         resources in AWS CodeCommit, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats"
     *         >CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</li>
     *         <li>TagKeysListRequiredException A list of tag keys is required. The list cannot be empty or null.</li>
     *         <li>InvalidTagKeysListException The list of tags is not valid.</li>
     *         <li>TooManyTagsException The maximum number of tags for an AWS CodeCommit resource has been exceeded.</li>
     *         <li>InvalidSystemTagUsageException The specified tag is not valid. Key names cannot be prefixed with
     *         aws:.</li>
     *         <li>TagPolicyException The tag policy is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the content of an approval rule template. You can change the number of required approvals, the membership
     * of the approval rule, and whether an approval pool is defined.
     * </p>
     *
     * @param updateApprovalRuleTemplateContentRequest
     * @return A Java Future containing the result of the UpdateApprovalRuleTemplateContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>InvalidApprovalRuleTemplateContentException The content of the approval rule template is not valid.</li>
     *         <li>InvalidRuleContentSha256Exception The SHA-256 hash signature for the rule content is not valid.</li>
     *         <li>ApprovalRuleTemplateContentRequiredException The content for the approval rule template is empty. You
     *         must provide some content for an approval rule template. The content cannot be null.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateApprovalRuleTemplateContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateApprovalRuleTemplateContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApprovalRuleTemplateContentResponse> updateApprovalRuleTemplateContent(
            UpdateApprovalRuleTemplateContentRequest updateApprovalRuleTemplateContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the content of an approval rule template. You can change the number of required approvals, the membership
     * of the approval rule, and whether an approval pool is defined.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApprovalRuleTemplateContentRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateApprovalRuleTemplateContentRequest#builder()}
     * </p>
     *
     * @param updateApprovalRuleTemplateContentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApprovalRuleTemplateContentInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateApprovalRuleTemplateContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>InvalidApprovalRuleTemplateContentException The content of the approval rule template is not valid.</li>
     *         <li>InvalidRuleContentSha256Exception The SHA-256 hash signature for the rule content is not valid.</li>
     *         <li>ApprovalRuleTemplateContentRequiredException The content for the approval rule template is empty. You
     *         must provide some content for an approval rule template. The content cannot be null.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateApprovalRuleTemplateContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateApprovalRuleTemplateContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApprovalRuleTemplateContentResponse> updateApprovalRuleTemplateContent(
            Consumer<UpdateApprovalRuleTemplateContentRequest.Builder> updateApprovalRuleTemplateContentRequest) {
        return updateApprovalRuleTemplateContent(UpdateApprovalRuleTemplateContentRequest.builder()
                .applyMutation(updateApprovalRuleTemplateContentRequest).build());
    }

    /**
     * <p>
     * Updates the description for a specified approval rule template.
     * </p>
     *
     * @param updateApprovalRuleTemplateDescriptionRequest
     * @return A Java Future containing the result of the UpdateApprovalRuleTemplateDescription operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>InvalidApprovalRuleTemplateDescriptionException The description for the approval rule template is not
     *         valid because it exceeds the maximum characters allowed for a description. For more information about
     *         limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateApprovalRuleTemplateDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateApprovalRuleTemplateDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApprovalRuleTemplateDescriptionResponse> updateApprovalRuleTemplateDescription(
            UpdateApprovalRuleTemplateDescriptionRequest updateApprovalRuleTemplateDescriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description for a specified approval rule template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateApprovalRuleTemplateDescriptionRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateApprovalRuleTemplateDescriptionRequest#builder()}
     * </p>
     *
     * @param updateApprovalRuleTemplateDescriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApprovalRuleTemplateDescriptionInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateApprovalRuleTemplateDescription operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>InvalidApprovalRuleTemplateDescriptionException The description for the approval rule template is not
     *         valid because it exceeds the maximum characters allowed for a description. For more information about
     *         limits in AWS CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateApprovalRuleTemplateDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateApprovalRuleTemplateDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApprovalRuleTemplateDescriptionResponse> updateApprovalRuleTemplateDescription(
            Consumer<UpdateApprovalRuleTemplateDescriptionRequest.Builder> updateApprovalRuleTemplateDescriptionRequest) {
        return updateApprovalRuleTemplateDescription(UpdateApprovalRuleTemplateDescriptionRequest.builder()
                .applyMutation(updateApprovalRuleTemplateDescriptionRequest).build());
    }

    /**
     * <p>
     * Updates the name of a specified approval rule template.
     * </p>
     *
     * @param updateApprovalRuleTemplateNameRequest
     * @return A Java Future containing the result of the UpdateApprovalRuleTemplateName operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>ApprovalRuleTemplateNameAlreadyExistsException You cannot create an approval rule template with that
     *         name because a template with that name already exists in this AWS Region for your AWS account. Approval
     *         rule template names must be unique.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateApprovalRuleTemplateName
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateApprovalRuleTemplateName"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApprovalRuleTemplateNameResponse> updateApprovalRuleTemplateName(
            UpdateApprovalRuleTemplateNameRequest updateApprovalRuleTemplateNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name of a specified approval rule template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApprovalRuleTemplateNameRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateApprovalRuleTemplateNameRequest#builder()}
     * </p>
     *
     * @param updateApprovalRuleTemplateNameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApprovalRuleTemplateNameInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateApprovalRuleTemplateName operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidApprovalRuleTemplateNameException The name of the approval rule template is not valid.
     *         Template names must be between 1 and 100 valid characters in length. For more information about limits in
     *         AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
     *         CodeCommit User Guide</a>.</li>
     *         <li>ApprovalRuleTemplateNameRequiredException An approval rule template name is required, but was not
     *         specified.</li>
     *         <li>ApprovalRuleTemplateDoesNotExistException The specified approval rule template does not exist. Verify
     *         that the name is correct and that you are signed in to the AWS Region where the template was created, and
     *         then try again.</li>
     *         <li>ApprovalRuleTemplateNameAlreadyExistsException You cannot create an approval rule template with that
     *         name because a template with that name already exists in this AWS Region for your AWS account. Approval
     *         rule template names must be unique.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateApprovalRuleTemplateName
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateApprovalRuleTemplateName"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApprovalRuleTemplateNameResponse> updateApprovalRuleTemplateName(
            Consumer<UpdateApprovalRuleTemplateNameRequest.Builder> updateApprovalRuleTemplateNameRequest) {
        return updateApprovalRuleTemplateName(UpdateApprovalRuleTemplateNameRequest.builder()
                .applyMutation(updateApprovalRuleTemplateNameRequest).build());
    }

    /**
     * <p>
     * Replaces the contents of a comment.
     * </p>
     *
     * @param updateCommentRequest
     * @return A Java Future containing the result of the UpdateComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>CommentNotCreatedByCallerException You cannot modify or delete this comment. Only comment authors can
     *         modify or delete their comments.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateComment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateCommentResponse> updateComment(UpdateCommentRequest updateCommentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the contents of a comment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCommentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCommentRequest#builder()}
     * </p>
     *
     * @param updateCommentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCommentInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CommentContentRequiredException The comment is empty. You must provide some content for a comment.
     *         The content cannot be null.</li>
     *         <li>CommentContentSizeLimitExceededException The comment is too large. Comments are limited to 1,000
     *         characters.</li>
     *         <li>CommentDoesNotExistException No comment exists with the provided ID. Verify that you have used the
     *         correct ID, and then try again.</li>
     *         <li>CommentIdRequiredException The comment ID is missing or null. A comment ID is required.</li>
     *         <li>InvalidCommentIdException The comment ID is not in a valid format. Make sure that you have provided
     *         the full comment ID.</li>
     *         <li>CommentNotCreatedByCallerException You cannot modify or delete this comment. Only comment authors can
     *         modify or delete their comments.</li>
     *         <li>CommentDeletedException This comment has already been deleted. You cannot edit or delete a deleted
     *         comment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateComment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateCommentResponse> updateComment(Consumer<UpdateCommentRequest.Builder> updateCommentRequest) {
        return updateComment(UpdateCommentRequest.builder().applyMutation(updateCommentRequest).build());
    }

    /**
     * <p>
     * Sets or changes the default branch name for the specified repository.
     * </p>
     * <note>
     * <p>
     * If you use this operation to change the default branch name to the current default branch name, a success message
     * is returned even though the default branch did not change.
     * </p>
     * </note>
     *
     * @param updateDefaultBranchRequest
     *        Represents the input of an update default branch operation.
     * @return A Java Future containing the result of the UpdateDefaultBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateDefaultBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDefaultBranchResponse> updateDefaultBranch(
            UpdateDefaultBranchRequest updateDefaultBranchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets or changes the default branch name for the specified repository.
     * </p>
     * <note>
     * <p>
     * If you use this operation to change the default branch name to the current default branch name, a success message
     * is returned even though the default branch did not change.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDefaultBranchRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDefaultBranchRequest#builder()}
     * </p>
     *
     * @param updateDefaultBranchRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDefaultBranchInput.Builder} to create a request.
     *        Represents the input of an update default branch operation.
     * @return A Java Future containing the result of the UpdateDefaultBranch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>BranchNameRequiredException A branch name is required, but was not specified.</li>
     *         <li>InvalidBranchNameException The specified reference name is not valid.</li>
     *         <li>BranchDoesNotExistException The specified branch does not exist.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateDefaultBranch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDefaultBranchResponse> updateDefaultBranch(
            Consumer<UpdateDefaultBranchRequest.Builder> updateDefaultBranchRequest) {
        return updateDefaultBranch(UpdateDefaultBranchRequest.builder().applyMutation(updateDefaultBranchRequest).build());
    }

    /**
     * <p>
     * Updates the structure of an approval rule created specifically for a pull request. For example, you can change
     * the number of required approvers and the approval pool for approvers.
     * </p>
     *
     * @param updatePullRequestApprovalRuleContentRequest
     * @return A Java Future containing the result of the UpdatePullRequestApprovalRuleContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>ApprovalRuleNameRequiredException An approval rule name is required, but was not specified.</li>
     *         <li>InvalidApprovalRuleNameException The name for the approval rule is not valid.</li>
     *         <li>ApprovalRuleDoesNotExistException The specified approval rule does not exist.</li>
     *         <li>InvalidRuleContentSha256Exception The SHA-256 hash signature for the rule content is not valid.</li>
     *         <li>ApprovalRuleContentRequiredException The content for the approval rule is empty. You must provide
     *         some content for an approval rule. The content cannot be null.</li>
     *         <li>InvalidApprovalRuleContentException The content for the approval rule is not valid.</li>
     *         <li>CannotModifyApprovalRuleFromTemplateException The approval rule cannot be modified for the pull
     *         request because it was created by an approval rule template and applied to the pull request
     *         automatically.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestApprovalRuleContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestApprovalRuleContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullRequestApprovalRuleContentResponse> updatePullRequestApprovalRuleContent(
            UpdatePullRequestApprovalRuleContentRequest updatePullRequestApprovalRuleContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the structure of an approval rule created specifically for a pull request. For example, you can change
     * the number of required approvers and the approval pool for approvers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdatePullRequestApprovalRuleContentRequest.Builder} avoiding the need to create one manually via
     * {@link UpdatePullRequestApprovalRuleContentRequest#builder()}
     * </p>
     *
     * @param updatePullRequestApprovalRuleContentRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePullRequestApprovalRuleContentInput.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdatePullRequestApprovalRuleContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>ApprovalRuleNameRequiredException An approval rule name is required, but was not specified.</li>
     *         <li>InvalidApprovalRuleNameException The name for the approval rule is not valid.</li>
     *         <li>ApprovalRuleDoesNotExistException The specified approval rule does not exist.</li>
     *         <li>InvalidRuleContentSha256Exception The SHA-256 hash signature for the rule content is not valid.</li>
     *         <li>ApprovalRuleContentRequiredException The content for the approval rule is empty. You must provide
     *         some content for an approval rule. The content cannot be null.</li>
     *         <li>InvalidApprovalRuleContentException The content for the approval rule is not valid.</li>
     *         <li>CannotModifyApprovalRuleFromTemplateException The approval rule cannot be modified for the pull
     *         request because it was created by an approval rule template and applied to the pull request
     *         automatically.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestApprovalRuleContent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestApprovalRuleContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullRequestApprovalRuleContentResponse> updatePullRequestApprovalRuleContent(
            Consumer<UpdatePullRequestApprovalRuleContentRequest.Builder> updatePullRequestApprovalRuleContentRequest) {
        return updatePullRequestApprovalRuleContent(UpdatePullRequestApprovalRuleContentRequest.builder()
                .applyMutation(updatePullRequestApprovalRuleContentRequest).build());
    }

    /**
     * <p>
     * Updates the state of a user's approval on a pull request. The user is derived from the signed-in account when the
     * request is made.
     * </p>
     *
     * @param updatePullRequestApprovalStateRequest
     * @return A Java Future containing the result of the UpdatePullRequestApprovalState operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidRevisionIdException The revision ID is not valid. Use GetPullRequest to determine the value.</li>
     *         <li>RevisionIdRequiredException A revision ID is required, but was not provided.</li>
     *         <li>InvalidApprovalStateException The state for the approval is not valid. Valid values include APPROVE
     *         and REVOKE.</li>
     *         <li>ApprovalStateRequiredException An approval state is required, but was not specified.</li>
     *         <li>PullRequestCannotBeApprovedByAuthorException The approval cannot be applied because the user
     *         approving the pull request matches the user who created the pull request. You cannot approve a pull
     *         request that you created.</li>
     *         <li>RevisionNotCurrentException The revision ID provided in the request does not match the current
     *         revision ID. Use GetPullRequest to retrieve the current revision ID.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>MaximumNumberOfApprovalsExceededException The number of approvals required for the approval rule
     *         exceeds the maximum number allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestApprovalState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestApprovalState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullRequestApprovalStateResponse> updatePullRequestApprovalState(
            UpdatePullRequestApprovalStateRequest updatePullRequestApprovalStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the state of a user's approval on a pull request. The user is derived from the signed-in account when the
     * request is made.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePullRequestApprovalStateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdatePullRequestApprovalStateRequest#builder()}
     * </p>
     *
     * @param updatePullRequestApprovalStateRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePullRequestApprovalStateInput.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdatePullRequestApprovalState operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidRevisionIdException The revision ID is not valid. Use GetPullRequest to determine the value.</li>
     *         <li>RevisionIdRequiredException A revision ID is required, but was not provided.</li>
     *         <li>InvalidApprovalStateException The state for the approval is not valid. Valid values include APPROVE
     *         and REVOKE.</li>
     *         <li>ApprovalStateRequiredException An approval state is required, but was not specified.</li>
     *         <li>PullRequestCannotBeApprovedByAuthorException The approval cannot be applied because the user
     *         approving the pull request matches the user who created the pull request. You cannot approve a pull
     *         request that you created.</li>
     *         <li>RevisionNotCurrentException The revision ID provided in the request does not match the current
     *         revision ID. Use GetPullRequest to retrieve the current revision ID.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>MaximumNumberOfApprovalsExceededException The number of approvals required for the approval rule
     *         exceeds the maximum number allowed.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestApprovalState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestApprovalState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullRequestApprovalStateResponse> updatePullRequestApprovalState(
            Consumer<UpdatePullRequestApprovalStateRequest.Builder> updatePullRequestApprovalStateRequest) {
        return updatePullRequestApprovalState(UpdatePullRequestApprovalStateRequest.builder()
                .applyMutation(updatePullRequestApprovalStateRequest).build());
    }

    /**
     * <p>
     * Replaces the contents of the description of a pull request.
     * </p>
     *
     * @param updatePullRequestDescriptionRequest
     * @return A Java Future containing the result of the UpdatePullRequestDescription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidDescriptionException The pull request description is not valid. Descriptions cannot be more
     *         than 1,000 characters.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullRequestDescriptionResponse> updatePullRequestDescription(
            UpdatePullRequestDescriptionRequest updatePullRequestDescriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the contents of the description of a pull request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePullRequestDescriptionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdatePullRequestDescriptionRequest#builder()}
     * </p>
     *
     * @param updatePullRequestDescriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePullRequestDescriptionInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePullRequestDescription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidDescriptionException The pull request description is not valid. Descriptions cannot be more
     *         than 1,000 characters.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullRequestDescriptionResponse> updatePullRequestDescription(
            Consumer<UpdatePullRequestDescriptionRequest.Builder> updatePullRequestDescriptionRequest) {
        return updatePullRequestDescription(UpdatePullRequestDescriptionRequest.builder()
                .applyMutation(updatePullRequestDescriptionRequest).build());
    }

    /**
     * <p>
     * Updates the status of a pull request.
     * </p>
     *
     * @param updatePullRequestStatusRequest
     * @return A Java Future containing the result of the UpdatePullRequestStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestStatusUpdateException The pull request status update is not valid. The only valid
     *         update is from <code>OPEN</code> to <code>CLOSED</code>.</li>
     *         <li>InvalidPullRequestStatusException The pull request status is not valid. The only valid values are
     *         <code>OPEN</code> and <code>CLOSED</code>.</li>
     *         <li>PullRequestStatusRequiredException A pull request status is required, but none was provided.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullRequestStatusResponse> updatePullRequestStatus(
            UpdatePullRequestStatusRequest updatePullRequestStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of a pull request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePullRequestStatusRequest.Builder} avoiding
     * the need to create one manually via {@link UpdatePullRequestStatusRequest#builder()}
     * </p>
     *
     * @param updatePullRequestStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePullRequestStatusInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePullRequestStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>InvalidPullRequestStatusUpdateException The pull request status update is not valid. The only valid
     *         update is from <code>OPEN</code> to <code>CLOSED</code>.</li>
     *         <li>InvalidPullRequestStatusException The pull request status is not valid. The only valid values are
     *         <code>OPEN</code> and <code>CLOSED</code>.</li>
     *         <li>PullRequestStatusRequiredException A pull request status is required, but none was provided.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullRequestStatusResponse> updatePullRequestStatus(
            Consumer<UpdatePullRequestStatusRequest.Builder> updatePullRequestStatusRequest) {
        return updatePullRequestStatus(UpdatePullRequestStatusRequest.builder().applyMutation(updatePullRequestStatusRequest)
                .build());
    }

    /**
     * <p>
     * Replaces the title of a pull request.
     * </p>
     *
     * @param updatePullRequestTitleRequest
     * @return A Java Future containing the result of the UpdatePullRequestTitle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>TitleRequiredException A pull request title is required. It cannot be empty or null.</li>
     *         <li>InvalidTitleException The title of the pull request is not valid. Pull request titles cannot exceed
     *         100 characters in length.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestTitle
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestTitle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullRequestTitleResponse> updatePullRequestTitle(
            UpdatePullRequestTitleRequest updatePullRequestTitleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the title of a pull request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePullRequestTitleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePullRequestTitleRequest#builder()}
     * </p>
     *
     * @param updatePullRequestTitleRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePullRequestTitleInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePullRequestTitle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PullRequestDoesNotExistException The pull request ID could not be found. Make sure that you have
     *         specified the correct repository name and pull request ID, and then try again.</li>
     *         <li>InvalidPullRequestIdException The pull request ID is not valid. Make sure that you have provided the
     *         full ID and that the pull request is in the specified repository, and then try again.</li>
     *         <li>PullRequestIdRequiredException A pull request ID is required, but none was provided.</li>
     *         <li>TitleRequiredException A pull request title is required. It cannot be empty or null.</li>
     *         <li>InvalidTitleException The title of the pull request is not valid. Pull request titles cannot exceed
     *         100 characters in length.</li>
     *         <li>PullRequestAlreadyClosedException The pull request status cannot be updated because it is already
     *         closed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdatePullRequestTitle
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestTitle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdatePullRequestTitleResponse> updatePullRequestTitle(
            Consumer<UpdatePullRequestTitleRequest.Builder> updatePullRequestTitleRequest) {
        return updatePullRequestTitle(UpdatePullRequestTitleRequest.builder().applyMutation(updatePullRequestTitleRequest)
                .build());
    }

    /**
     * <p>
     * Sets or changes the comment or description for a repository.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a webpage.
     * </p>
     * </note>
     *
     * @param updateRepositoryDescriptionRequest
     *        Represents the input of an update repository description operation.
     * @return A Java Future containing the result of the UpdateRepositoryDescription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidRepositoryDescriptionException The specified repository description is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateRepositoryDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRepositoryDescriptionResponse> updateRepositoryDescription(
            UpdateRepositoryDescriptionRequest updateRepositoryDescriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets or changes the comment or description for a repository.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a webpage.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRepositoryDescriptionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRepositoryDescriptionRequest#builder()}
     * </p>
     *
     * @param updateRepositoryDescriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRepositoryDescriptionInput.Builder} to create a
     *        request. Represents the input of an update repository description operation.
     * @return A Java Future containing the result of the UpdateRepositoryDescription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>InvalidRepositoryDescriptionException The specified repository description is not valid.</li>
     *         <li>EncryptionIntegrityChecksFailedException An encryption integrity check failed.</li>
     *         <li>EncryptionKeyAccessDeniedException An encryption key could not be accessed.</li>
     *         <li>EncryptionKeyDisabledException The encryption key is disabled.</li>
     *         <li>EncryptionKeyNotFoundException No encryption key was found.</li>
     *         <li>EncryptionKeyUnavailableException The encryption key is not available.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateRepositoryDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryDescription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRepositoryDescriptionResponse> updateRepositoryDescription(
            Consumer<UpdateRepositoryDescriptionRequest.Builder> updateRepositoryDescriptionRequest) {
        return updateRepositoryDescription(UpdateRepositoryDescriptionRequest.builder()
                .applyMutation(updateRepositoryDescriptionRequest).build());
    }

    /**
     * <p>
     * Renames a repository. The repository name must be unique across the calling AWS account. Repository names are
     * limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. The suffix
     * .git is prohibited. For more information about the limits on repository names, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the AWS CodeCommit User
     * Guide.
     * </p>
     *
     * @param updateRepositoryNameRequest
     *        Represents the input of an update repository description operation.
     * @return A Java Future containing the result of the UpdateRepositoryName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNameExistsException The specified repository name already exists.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateRepositoryName
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryName"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRepositoryNameResponse> updateRepositoryName(
            UpdateRepositoryNameRequest updateRepositoryNameRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Renames a repository. The repository name must be unique across the calling AWS account. Repository names are
     * limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. The suffix
     * .git is prohibited. For more information about the limits on repository names, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the AWS CodeCommit User
     * Guide.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRepositoryNameRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRepositoryNameRequest#builder()}
     * </p>
     *
     * @param updateRepositoryNameRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRepositoryNameInput.Builder} to create a
     *        request. Represents the input of an update repository description operation.
     * @return A Java Future containing the result of the UpdateRepositoryName operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RepositoryDoesNotExistException The specified repository does not exist.</li>
     *         <li>RepositoryNameExistsException The specified repository name already exists.</li>
     *         <li>RepositoryNameRequiredException A repository name is required, but was not specified.</li>
     *         <li>InvalidRepositoryNameException A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeCommitException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CodeCommitAsyncClient.UpdateRepositoryName
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryName"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRepositoryNameResponse> updateRepositoryName(
            Consumer<UpdateRepositoryNameRequest.Builder> updateRepositoryNameRequest) {
        return updateRepositoryName(UpdateRepositoryNameRequest.builder().applyMutation(updateRepositoryNameRequest).build());
    }
}
