/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.MergeOptionTypeEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MergeMetadata> {
    private static final SdkField<Boolean> IS_MERGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(MergeMetadata.getter(MergeMetadata::isMerged)).setter(MergeMetadata.setter(Builder::isMerged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMerged").build()}).build();
    private static final SdkField<String> MERGED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeMetadata.getter(MergeMetadata::mergedBy)).setter(MergeMetadata.setter(Builder::mergedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedBy").build()}).build();
    private static final SdkField<String> MERGE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeMetadata.getter(MergeMetadata::mergeCommitId)).setter(MergeMetadata.setter(Builder::mergeCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeCommitId").build()}).build();
    private static final SdkField<String> MERGE_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MergeMetadata.getter(MergeMetadata::mergeOptionAsString)).setter(MergeMetadata.setter(Builder::mergeOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_MERGED_FIELD, MERGED_BY_FIELD, MERGE_COMMIT_ID_FIELD, MERGE_OPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean isMerged;
    private final String mergedBy;
    private final String mergeCommitId;
    private final String mergeOption;

    private MergeMetadata(BuilderImpl builder) {
        this.isMerged = builder.isMerged;
        this.mergedBy = builder.mergedBy;
        this.mergeCommitId = builder.mergeCommitId;
        this.mergeOption = builder.mergeOption;
    }

    public Boolean isMerged() {
        return this.isMerged;
    }

    public String mergedBy() {
        return this.mergedBy;
    }

    public String mergeCommitId() {
        return this.mergeCommitId;
    }

    public MergeOptionTypeEnum mergeOption() {
        return MergeOptionTypeEnum.fromValue(this.mergeOption);
    }

    public String mergeOptionAsString() {
        return this.mergeOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isMerged());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeOptionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeMetadata)) {
            return false;
        }
        MergeMetadata other = (MergeMetadata)obj;
        return Objects.equals(this.isMerged(), other.isMerged()) && Objects.equals(this.mergedBy(), other.mergedBy()) && Objects.equals(this.mergeCommitId(), other.mergeCommitId()) && Objects.equals(this.mergeOptionAsString(), other.mergeOptionAsString());
    }

    public String toString() {
        return ToString.builder((String)"MergeMetadata").add("IsMerged", (Object)this.isMerged()).add("MergedBy", (Object)this.mergedBy()).add("MergeCommitId", (Object)this.mergeCommitId()).add("MergeOption", (Object)this.mergeOptionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isMerged": {
                return Optional.ofNullable(clazz.cast(this.isMerged()));
            }
            case "mergedBy": {
                return Optional.ofNullable(clazz.cast(this.mergedBy()));
            }
            case "mergeCommitId": {
                return Optional.ofNullable(clazz.cast(this.mergeCommitId()));
            }
            case "mergeOption": {
                return Optional.ofNullable(clazz.cast(this.mergeOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MergeMetadata, T> g) {
        return obj -> g.apply((MergeMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isMerged;
        private String mergedBy;
        private String mergeCommitId;
        private String mergeOption;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeMetadata model) {
            this.isMerged(model.isMerged);
            this.mergedBy(model.mergedBy);
            this.mergeCommitId(model.mergeCommitId);
            this.mergeOption(model.mergeOption);
        }

        public final Boolean getIsMerged() {
            return this.isMerged;
        }

        @Override
        public final Builder isMerged(Boolean isMerged) {
            this.isMerged = isMerged;
            return this;
        }

        public final void setIsMerged(Boolean isMerged) {
            this.isMerged = isMerged;
        }

        public final String getMergedBy() {
            return this.mergedBy;
        }

        @Override
        public final Builder mergedBy(String mergedBy) {
            this.mergedBy = mergedBy;
            return this;
        }

        public final void setMergedBy(String mergedBy) {
            this.mergedBy = mergedBy;
        }

        public final String getMergeCommitId() {
            return this.mergeCommitId;
        }

        @Override
        public final Builder mergeCommitId(String mergeCommitId) {
            this.mergeCommitId = mergeCommitId;
            return this;
        }

        public final void setMergeCommitId(String mergeCommitId) {
            this.mergeCommitId = mergeCommitId;
        }

        public final String getMergeOption() {
            return this.mergeOption;
        }

        @Override
        public final Builder mergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
            return this;
        }

        @Override
        public final Builder mergeOption(MergeOptionTypeEnum mergeOption) {
            this.mergeOption(mergeOption == null ? null : mergeOption.toString());
            return this;
        }

        public final void setMergeOption(String mergeOption) {
            this.mergeOption = mergeOption;
        }

        public MergeMetadata build() {
            return new MergeMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MergeMetadata> {
        public Builder isMerged(Boolean var1);

        public Builder mergedBy(String var1);

        public Builder mergeCommitId(String var1);

        public Builder mergeOption(String var1);

        public Builder mergeOption(MergeOptionTypeEnum var1);
    }
}

