/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.DeleteFileEntriesCopier;
import software.amazon.awssdk.services.codecommit.model.DeleteFileEntry;
import software.amazon.awssdk.services.codecommit.model.ReplaceContentEntriesCopier;
import software.amazon.awssdk.services.codecommit.model.ReplaceContentEntry;
import software.amazon.awssdk.services.codecommit.model.SetFileModeEntriesCopier;
import software.amazon.awssdk.services.codecommit.model.SetFileModeEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConflictResolution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConflictResolution> {
    private static final SdkField<List<ReplaceContentEntry>> REPLACE_CONTENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ConflictResolution.getter(ConflictResolution::replaceContents)).setter(ConflictResolution.setter(Builder::replaceContents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replaceContents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplaceContentEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DeleteFileEntry>> DELETE_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ConflictResolution.getter(ConflictResolution::deleteFiles)).setter(ConflictResolution.setter(Builder::deleteFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteFileEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SetFileModeEntry>> SET_FILE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ConflictResolution.getter(ConflictResolution::setFileModes)).setter(ConflictResolution.setter(Builder::setFileModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setFileModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SetFileModeEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACE_CONTENTS_FIELD, DELETE_FILES_FIELD, SET_FILE_MODES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ReplaceContentEntry> replaceContents;
    private final List<DeleteFileEntry> deleteFiles;
    private final List<SetFileModeEntry> setFileModes;

    private ConflictResolution(BuilderImpl builder) {
        this.replaceContents = builder.replaceContents;
        this.deleteFiles = builder.deleteFiles;
        this.setFileModes = builder.setFileModes;
    }

    public boolean hasReplaceContents() {
        return this.replaceContents != null && !(this.replaceContents instanceof SdkAutoConstructList);
    }

    public List<ReplaceContentEntry> replaceContents() {
        return this.replaceContents;
    }

    public boolean hasDeleteFiles() {
        return this.deleteFiles != null && !(this.deleteFiles instanceof SdkAutoConstructList);
    }

    public List<DeleteFileEntry> deleteFiles() {
        return this.deleteFiles;
    }

    public boolean hasSetFileModes() {
        return this.setFileModes != null && !(this.setFileModes instanceof SdkAutoConstructList);
    }

    public List<SetFileModeEntry> setFileModes() {
        return this.setFileModes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceContents());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.setFileModes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictResolution)) {
            return false;
        }
        ConflictResolution other = (ConflictResolution)obj;
        return Objects.equals(this.replaceContents(), other.replaceContents()) && Objects.equals(this.deleteFiles(), other.deleteFiles()) && Objects.equals(this.setFileModes(), other.setFileModes());
    }

    public String toString() {
        return ToString.builder((String)"ConflictResolution").add("ReplaceContents", this.replaceContents()).add("DeleteFiles", this.deleteFiles()).add("SetFileModes", this.setFileModes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "replaceContents": {
                return Optional.ofNullable(clazz.cast(this.replaceContents()));
            }
            case "deleteFiles": {
                return Optional.ofNullable(clazz.cast(this.deleteFiles()));
            }
            case "setFileModes": {
                return Optional.ofNullable(clazz.cast(this.setFileModes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictResolution, T> g) {
        return obj -> g.apply((ConflictResolution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ReplaceContentEntry> replaceContents = DefaultSdkAutoConstructList.getInstance();
        private List<DeleteFileEntry> deleteFiles = DefaultSdkAutoConstructList.getInstance();
        private List<SetFileModeEntry> setFileModes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictResolution model) {
            this.replaceContents(model.replaceContents);
            this.deleteFiles(model.deleteFiles);
            this.setFileModes(model.setFileModes);
        }

        public final Collection<ReplaceContentEntry.Builder> getReplaceContents() {
            return this.replaceContents != null ? (Collection)this.replaceContents.stream().map(ReplaceContentEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replaceContents(Collection<ReplaceContentEntry> replaceContents) {
            this.replaceContents = ReplaceContentEntriesCopier.copy(replaceContents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replaceContents(ReplaceContentEntry ... replaceContents) {
            this.replaceContents(Arrays.asList(replaceContents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replaceContents(Consumer<ReplaceContentEntry.Builder> ... replaceContents) {
            this.replaceContents(Stream.of(replaceContents).map(c -> (ReplaceContentEntry)((ReplaceContentEntry.Builder)ReplaceContentEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplaceContents(Collection<ReplaceContentEntry.BuilderImpl> replaceContents) {
            this.replaceContents = ReplaceContentEntriesCopier.copyFromBuilder(replaceContents);
        }

        public final Collection<DeleteFileEntry.Builder> getDeleteFiles() {
            return this.deleteFiles != null ? (Collection)this.deleteFiles.stream().map(DeleteFileEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deleteFiles(Collection<DeleteFileEntry> deleteFiles) {
            this.deleteFiles = DeleteFileEntriesCopier.copy(deleteFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteFiles(DeleteFileEntry ... deleteFiles) {
            this.deleteFiles(Arrays.asList(deleteFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteFiles(Consumer<DeleteFileEntry.Builder> ... deleteFiles) {
            this.deleteFiles(Stream.of(deleteFiles).map(c -> (DeleteFileEntry)((DeleteFileEntry.Builder)DeleteFileEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeleteFiles(Collection<DeleteFileEntry.BuilderImpl> deleteFiles) {
            this.deleteFiles = DeleteFileEntriesCopier.copyFromBuilder(deleteFiles);
        }

        public final Collection<SetFileModeEntry.Builder> getSetFileModes() {
            return this.setFileModes != null ? (Collection)this.setFileModes.stream().map(SetFileModeEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder setFileModes(Collection<SetFileModeEntry> setFileModes) {
            this.setFileModes = SetFileModeEntriesCopier.copy(setFileModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder setFileModes(SetFileModeEntry ... setFileModes) {
            this.setFileModes(Arrays.asList(setFileModes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder setFileModes(Consumer<SetFileModeEntry.Builder> ... setFileModes) {
            this.setFileModes(Stream.of(setFileModes).map(c -> (SetFileModeEntry)((SetFileModeEntry.Builder)SetFileModeEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSetFileModes(Collection<SetFileModeEntry.BuilderImpl> setFileModes) {
            this.setFileModes = SetFileModeEntriesCopier.copyFromBuilder(setFileModes);
        }

        public ConflictResolution build() {
            return new ConflictResolution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConflictResolution> {
        public Builder replaceContents(Collection<ReplaceContentEntry> var1);

        public Builder replaceContents(ReplaceContentEntry ... var1);

        public Builder replaceContents(Consumer<ReplaceContentEntry.Builder> ... var1);

        public Builder deleteFiles(Collection<DeleteFileEntry> var1);

        public Builder deleteFiles(DeleteFileEntry ... var1);

        public Builder deleteFiles(Consumer<DeleteFileEntry.Builder> ... var1);

        public Builder setFileModes(Collection<SetFileModeEntry> var1);

        public Builder setFileModes(SetFileModeEntry ... var1);

        public Builder setFileModes(Consumer<SetFileModeEntry.Builder> ... var1);
    }
}

