/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPullRequestOverrideStateResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetPullRequestOverrideStateResponse.Builder, GetPullRequestOverrideStateResponse> {
    private static final SdkField<Boolean> OVERRIDDEN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(GetPullRequestOverrideStateResponse::overridden)).setter(setter(Builder::overridden))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overridden").build()).build();

    private static final SdkField<String> OVERRIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPullRequestOverrideStateResponse::overrider)).setter(setter(Builder::overrider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDDEN_FIELD,
            OVERRIDER_FIELD));

    private final Boolean overridden;

    private final String overrider;

    private GetPullRequestOverrideStateResponse(BuilderImpl builder) {
        super(builder);
        this.overridden = builder.overridden;
        this.overrider = builder.overrider;
    }

    /**
     * <p>
     * A Boolean value that indicates whether a pull request has had its rules set aside (TRUE) or whether all approval
     * rules still apply (FALSE).
     * </p>
     * 
     * @return A Boolean value that indicates whether a pull request has had its rules set aside (TRUE) or whether all
     *         approval rules still apply (FALSE).
     */
    public Boolean overridden() {
        return overridden;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the
     * pull request.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for
     *         the pull request.
     */
    public String overrider() {
        return overrider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(overridden());
        hashCode = 31 * hashCode + Objects.hashCode(overrider());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPullRequestOverrideStateResponse)) {
            return false;
        }
        GetPullRequestOverrideStateResponse other = (GetPullRequestOverrideStateResponse) obj;
        return Objects.equals(overridden(), other.overridden()) && Objects.equals(overrider(), other.overrider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPullRequestOverrideStateResponse").add("Overridden", overridden())
                .add("Overrider", overrider()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "overridden":
            return Optional.ofNullable(clazz.cast(overridden()));
        case "overrider":
            return Optional.ofNullable(clazz.cast(overrider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPullRequestOverrideStateResponse, T> g) {
        return obj -> g.apply((GetPullRequestOverrideStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPullRequestOverrideStateResponse> {
        /**
         * <p>
         * A Boolean value that indicates whether a pull request has had its rules set aside (TRUE) or whether all
         * approval rules still apply (FALSE).
         * </p>
         * 
         * @param overridden
         *        A Boolean value that indicates whether a pull request has had its rules set aside (TRUE) or whether
         *        all approval rules still apply (FALSE).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overridden(Boolean overridden);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the
         * pull request.
         * </p>
         * 
         * @param overrider
         *        The Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements
         *        for the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrider(String overrider);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private Boolean overridden;

        private String overrider;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPullRequestOverrideStateResponse model) {
            super(model);
            overridden(model.overridden);
            overrider(model.overrider);
        }

        public final Boolean getOverridden() {
            return overridden;
        }

        @Override
        public final Builder overridden(Boolean overridden) {
            this.overridden = overridden;
            return this;
        }

        public final void setOverridden(Boolean overridden) {
            this.overridden = overridden;
        }

        public final String getOverrider() {
            return overrider;
        }

        @Override
        public final Builder overrider(String overrider) {
            this.overrider = overrider;
            return this;
        }

        public final void setOverrider(String overrider) {
            this.overrider = overrider;
        }

        @Override
        public GetPullRequestOverrideStateResponse build() {
            return new GetPullRequestOverrideStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
