/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMergeConflictsResponse extends CodeCommitResponse implements
        ToCopyableBuilder<DescribeMergeConflictsResponse.Builder, DescribeMergeConflictsResponse> {
    private static final SdkField<ConflictMetadata> CONFLICT_METADATA_FIELD = SdkField
            .<ConflictMetadata> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeMergeConflictsResponse::conflictMetadata)).setter(setter(Builder::conflictMetadata))
            .constructor(ConflictMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictMetadata").build()).build();

    private static final SdkField<List<MergeHunk>> MERGE_HUNKS_FIELD = SdkField
            .<List<MergeHunk>> builder(MarshallingType.LIST)
            .getter(getter(DescribeMergeConflictsResponse::mergeHunks))
            .setter(setter(Builder::mergeHunks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeHunks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MergeHunk> builder(MarshallingType.SDK_POJO)
                                            .constructor(MergeHunk::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMergeConflictsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMergeConflictsResponse::destinationCommitId)).setter(setter(Builder::destinationCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build())
            .build();

    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMergeConflictsResponse::sourceCommitId)).setter(setter(Builder::sourceCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()).build();

    private static final SdkField<String> BASE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMergeConflictsResponse::baseCommitId)).setter(setter(Builder::baseCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCommitId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICT_METADATA_FIELD,
            MERGE_HUNKS_FIELD, NEXT_TOKEN_FIELD, DESTINATION_COMMIT_ID_FIELD, SOURCE_COMMIT_ID_FIELD, BASE_COMMIT_ID_FIELD));

    private final ConflictMetadata conflictMetadata;

    private final List<MergeHunk> mergeHunks;

    private final String nextToken;

    private final String destinationCommitId;

    private final String sourceCommitId;

    private final String baseCommitId;

    private DescribeMergeConflictsResponse(BuilderImpl builder) {
        super(builder);
        this.conflictMetadata = builder.conflictMetadata;
        this.mergeHunks = builder.mergeHunks;
        this.nextToken = builder.nextToken;
        this.destinationCommitId = builder.destinationCommitId;
        this.sourceCommitId = builder.sourceCommitId;
        this.baseCommitId = builder.baseCommitId;
    }

    /**
     * <p>
     * Contains metadata about the conflicts found in the merge.
     * </p>
     * 
     * @return Contains metadata about the conflicts found in the merge.
     */
    public ConflictMetadata conflictMetadata() {
        return conflictMetadata;
    }

    /**
     * Returns true if the MergeHunks property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMergeHunks() {
        return mergeHunks != null && !(mergeHunks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of merge hunks of the differences between the files or lines.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMergeHunks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of merge hunks of the differences between the files or lines.
     */
    public List<MergeHunk> mergeHunks() {
        return mergeHunks;
    }

    /**
     * <p>
     * An enumeration token that can be used in a request to return the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that can be used in a request to return the next batch of the results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The commit ID of the destination commit specifier that was used in the merge evaluation.
     * </p>
     * 
     * @return The commit ID of the destination commit specifier that was used in the merge evaluation.
     */
    public String destinationCommitId() {
        return destinationCommitId;
    }

    /**
     * <p>
     * The commit ID of the source commit specifier that was used in the merge evaluation.
     * </p>
     * 
     * @return The commit ID of the source commit specifier that was used in the merge evaluation.
     */
    public String sourceCommitId() {
        return sourceCommitId;
    }

    /**
     * <p>
     * The commit ID of the merge base.
     * </p>
     * 
     * @return The commit ID of the merge base.
     */
    public String baseCommitId() {
        return baseCommitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(conflictMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(mergeHunks());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(baseCommitId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMergeConflictsResponse)) {
            return false;
        }
        DescribeMergeConflictsResponse other = (DescribeMergeConflictsResponse) obj;
        return Objects.equals(conflictMetadata(), other.conflictMetadata()) && Objects.equals(mergeHunks(), other.mergeHunks())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(destinationCommitId(), other.destinationCommitId())
                && Objects.equals(sourceCommitId(), other.sourceCommitId())
                && Objects.equals(baseCommitId(), other.baseCommitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeMergeConflictsResponse").add("ConflictMetadata", conflictMetadata())
                .add("MergeHunks", mergeHunks()).add("NextToken", nextToken()).add("DestinationCommitId", destinationCommitId())
                .add("SourceCommitId", sourceCommitId()).add("BaseCommitId", baseCommitId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conflictMetadata":
            return Optional.ofNullable(clazz.cast(conflictMetadata()));
        case "mergeHunks":
            return Optional.ofNullable(clazz.cast(mergeHunks()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "destinationCommitId":
            return Optional.ofNullable(clazz.cast(destinationCommitId()));
        case "sourceCommitId":
            return Optional.ofNullable(clazz.cast(sourceCommitId()));
        case "baseCommitId":
            return Optional.ofNullable(clazz.cast(baseCommitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMergeConflictsResponse, T> g) {
        return obj -> g.apply((DescribeMergeConflictsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMergeConflictsResponse> {
        /**
         * <p>
         * Contains metadata about the conflicts found in the merge.
         * </p>
         * 
         * @param conflictMetadata
         *        Contains metadata about the conflicts found in the merge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictMetadata(ConflictMetadata conflictMetadata);

        /**
         * <p>
         * Contains metadata about the conflicts found in the merge.
         * </p>
         * This is a convenience that creates an instance of the {@link ConflictMetadata.Builder} avoiding the need to
         * create one manually via {@link ConflictMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConflictMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #conflictMetadata(ConflictMetadata)}.
         * 
         * @param conflictMetadata
         *        a consumer that will call methods on {@link ConflictMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflictMetadata(ConflictMetadata)
         */
        default Builder conflictMetadata(Consumer<ConflictMetadata.Builder> conflictMetadata) {
            return conflictMetadata(ConflictMetadata.builder().applyMutation(conflictMetadata).build());
        }

        /**
         * <p>
         * A list of merge hunks of the differences between the files or lines.
         * </p>
         * 
         * @param mergeHunks
         *        A list of merge hunks of the differences between the files or lines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeHunks(Collection<MergeHunk> mergeHunks);

        /**
         * <p>
         * A list of merge hunks of the differences between the files or lines.
         * </p>
         * 
         * @param mergeHunks
         *        A list of merge hunks of the differences between the files or lines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeHunks(MergeHunk... mergeHunks);

        /**
         * <p>
         * A list of merge hunks of the differences between the files or lines.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MergeHunk>.Builder} avoiding the need to
         * create one manually via {@link List<MergeHunk>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MergeHunk>.Builder#build()} is called immediately and its
         * result is passed to {@link #mergeHunks(List<MergeHunk>)}.
         * 
         * @param mergeHunks
         *        a consumer that will call methods on {@link List<MergeHunk>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mergeHunks(List<MergeHunk>)
         */
        Builder mergeHunks(Consumer<MergeHunk.Builder>... mergeHunks);

        /**
         * <p>
         * An enumeration token that can be used in a request to return the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that can be used in a request to return the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The commit ID of the destination commit specifier that was used in the merge evaluation.
         * </p>
         * 
         * @param destinationCommitId
         *        The commit ID of the destination commit specifier that was used in the merge evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitId(String destinationCommitId);

        /**
         * <p>
         * The commit ID of the source commit specifier that was used in the merge evaluation.
         * </p>
         * 
         * @param sourceCommitId
         *        The commit ID of the source commit specifier that was used in the merge evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitId(String sourceCommitId);

        /**
         * <p>
         * The commit ID of the merge base.
         * </p>
         * 
         * @param baseCommitId
         *        The commit ID of the merge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseCommitId(String baseCommitId);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private ConflictMetadata conflictMetadata;

        private List<MergeHunk> mergeHunks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String destinationCommitId;

        private String sourceCommitId;

        private String baseCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMergeConflictsResponse model) {
            super(model);
            conflictMetadata(model.conflictMetadata);
            mergeHunks(model.mergeHunks);
            nextToken(model.nextToken);
            destinationCommitId(model.destinationCommitId);
            sourceCommitId(model.sourceCommitId);
            baseCommitId(model.baseCommitId);
        }

        public final ConflictMetadata.Builder getConflictMetadata() {
            return conflictMetadata != null ? conflictMetadata.toBuilder() : null;
        }

        @Override
        public final Builder conflictMetadata(ConflictMetadata conflictMetadata) {
            this.conflictMetadata = conflictMetadata;
            return this;
        }

        public final void setConflictMetadata(ConflictMetadata.BuilderImpl conflictMetadata) {
            this.conflictMetadata = conflictMetadata != null ? conflictMetadata.build() : null;
        }

        public final Collection<MergeHunk.Builder> getMergeHunks() {
            return mergeHunks != null ? mergeHunks.stream().map(MergeHunk::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mergeHunks(Collection<MergeHunk> mergeHunks) {
            this.mergeHunks = MergeHunksCopier.copy(mergeHunks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeHunks(MergeHunk... mergeHunks) {
            mergeHunks(Arrays.asList(mergeHunks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeHunks(Consumer<MergeHunk.Builder>... mergeHunks) {
            mergeHunks(Stream.of(mergeHunks).map(c -> MergeHunk.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMergeHunks(Collection<MergeHunk.BuilderImpl> mergeHunks) {
            this.mergeHunks = MergeHunksCopier.copyFromBuilder(mergeHunks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getDestinationCommitId() {
            return destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        public final String getSourceCommitId() {
            return sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        public final String getBaseCommitId() {
            return baseCommitId;
        }

        @Override
        public final Builder baseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
            return this;
        }

        public final void setBaseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
        }

        @Override
        public DescribeMergeConflictsResponse build() {
            return new DescribeMergeConflictsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
