/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about errors in a BatchGetCommits operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCommitsError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetCommitsError.Builder, BatchGetCommitsError> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchGetCommitsError::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchGetCommitsError::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchGetCommitsError::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD,
            ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String commitId;

    private final String errorCode;

    private final String errorMessage;

    private BatchGetCommitsError(BuilderImpl builder) {
        this.commitId = builder.commitId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * A commit ID that either could not be found or was not in a valid format.
     * </p>
     * 
     * @return A commit ID that either could not be found or was not in a valid format.
     */
    public String commitId() {
        return commitId;
    }

    /**
     * <p>
     * An error code that specifies whether the commit ID was not valid or not found.
     * </p>
     * 
     * @return An error code that specifies whether the commit ID was not valid or not found.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * An error message that provides detail about why the commit ID either was not found or was not valid.
     * </p>
     * 
     * @return An error message that provides detail about why the commit ID either was not found or was not valid.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCommitsError)) {
            return false;
        }
        BatchGetCommitsError other = (BatchGetCommitsError) obj;
        return Objects.equals(commitId(), other.commitId()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetCommitsError").add("CommitId", commitId()).add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCommitsError, T> g) {
        return obj -> g.apply((BatchGetCommitsError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetCommitsError> {
        /**
         * <p>
         * A commit ID that either could not be found or was not in a valid format.
         * </p>
         * 
         * @param commitId
         *        A commit ID that either could not be found or was not in a valid format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * An error code that specifies whether the commit ID was not valid or not found.
         * </p>
         * 
         * @param errorCode
         *        An error code that specifies whether the commit ID was not valid or not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * An error message that provides detail about why the commit ID either was not found or was not valid.
         * </p>
         * 
         * @param errorMessage
         *        An error message that provides detail about why the commit ID either was not found or was not valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String commitId;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCommitsError model) {
            commitId(model.commitId);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getCommitId() {
            return commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public BatchGetCommitsError build() {
            return new BatchGetCommitsError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
