/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessTokenResponse
extends CodeCatalystResponse
implements ToCopyableBuilder<Builder, CreateAccessTokenResponse> {
    private static final SdkField<String> SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secret").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::secret)).setter(CreateAccessTokenResponse.setter(Builder::secret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secret").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::name)).setter(CreateAccessTokenResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> EXPIRES_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresTime").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::expiresTime)).setter(CreateAccessTokenResponse.setter(Builder::expiresTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ACCESS_TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessTokenId").getter(CreateAccessTokenResponse.getter(CreateAccessTokenResponse::accessTokenId)).setter(CreateAccessTokenResponse.setter(Builder::accessTokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTokenId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_FIELD, NAME_FIELD, EXPIRES_TIME_FIELD, ACCESS_TOKEN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAccessTokenResponse.memberNameToFieldInitializer();
    private final String secret;
    private final String name;
    private final Instant expiresTime;
    private final String accessTokenId;

    private CreateAccessTokenResponse(BuilderImpl builder) {
        super(builder);
        this.secret = builder.secret;
        this.name = builder.name;
        this.expiresTime = builder.expiresTime;
        this.accessTokenId = builder.accessTokenId;
    }

    public final String secret() {
        return this.secret;
    }

    public final String name() {
        return this.name;
    }

    public final Instant expiresTime() {
        return this.expiresTime;
    }

    public final String accessTokenId() {
        return this.accessTokenId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.secret());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTokenId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessTokenResponse)) {
            return false;
        }
        CreateAccessTokenResponse other = (CreateAccessTokenResponse)((Object)obj);
        return Objects.equals(this.secret(), other.secret()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.expiresTime(), other.expiresTime()) && Objects.equals(this.accessTokenId(), other.accessTokenId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessTokenResponse").add("Secret", (Object)(this.secret() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("ExpiresTime", (Object)this.expiresTime()).add("AccessTokenId", (Object)this.accessTokenId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "secret": {
                return Optional.ofNullable(clazz.cast(this.secret()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "expiresTime": {
                return Optional.ofNullable(clazz.cast(this.expiresTime()));
            }
            case "accessTokenId": {
                return Optional.ofNullable(clazz.cast(this.accessTokenId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("secret", SECRET_FIELD);
        map.put("name", NAME_FIELD);
        map.put("expiresTime", EXPIRES_TIME_FIELD);
        map.put("accessTokenId", ACCESS_TOKEN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessTokenResponse, T> g) {
        return obj -> g.apply((CreateAccessTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystResponse.BuilderImpl
    implements Builder {
        private String secret;
        private String name;
        private Instant expiresTime;
        private String accessTokenId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessTokenResponse model) {
            super(model);
            this.secret(model.secret);
            this.name(model.name);
            this.expiresTime(model.expiresTime);
            this.accessTokenId(model.accessTokenId);
        }

        public final String getSecret() {
            return this.secret;
        }

        public final void setSecret(String secret) {
            this.secret = secret;
        }

        @Override
        public final Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getExpiresTime() {
            return this.expiresTime;
        }

        public final void setExpiresTime(Instant expiresTime) {
            this.expiresTime = expiresTime;
        }

        @Override
        public final Builder expiresTime(Instant expiresTime) {
            this.expiresTime = expiresTime;
            return this;
        }

        public final String getAccessTokenId() {
            return this.accessTokenId;
        }

        public final void setAccessTokenId(String accessTokenId) {
            this.accessTokenId = accessTokenId;
        }

        @Override
        public final Builder accessTokenId(String accessTokenId) {
            this.accessTokenId = accessTokenId;
            return this;
        }

        @Override
        public CreateAccessTokenResponse build() {
            return new CreateAccessTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeCatalystResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessTokenResponse> {
        public Builder secret(String var1);

        public Builder name(String var1);

        public Builder expiresTime(Instant var1);

        public Builder accessTokenId(String var1);
    }
}

