/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystResponse;
import software.amazon.awssdk.services.codecatalyst.model.EmailAddress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUserDetailsResponse
extends CodeCatalystResponse
implements ToCopyableBuilder<Builder, GetUserDetailsResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(GetUserDetailsResponse.getter(GetUserDetailsResponse::userId)).setter(GetUserDetailsResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userName").getter(GetUserDetailsResponse.getter(GetUserDetailsResponse::userName)).setter(GetUserDetailsResponse.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetUserDetailsResponse.getter(GetUserDetailsResponse::displayName)).setter(GetUserDetailsResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<EmailAddress> PRIMARY_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("primaryEmail").getter(GetUserDetailsResponse.getter(GetUserDetailsResponse::primaryEmail)).setter(GetUserDetailsResponse.setter(Builder::primaryEmail)).constructor(EmailAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryEmail").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(GetUserDetailsResponse.getter(GetUserDetailsResponse::version)).setter(GetUserDetailsResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, USER_NAME_FIELD, DISPLAY_NAME_FIELD, PRIMARY_EMAIL_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUserDetailsResponse.memberNameToFieldInitializer();
    private final String userId;
    private final String userName;
    private final String displayName;
    private final EmailAddress primaryEmail;
    private final String version;

    private GetUserDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.userName = builder.userName;
        this.displayName = builder.displayName;
        this.primaryEmail = builder.primaryEmail;
        this.version = builder.version;
    }

    public final String userId() {
        return this.userId;
    }

    public final String userName() {
        return this.userName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final EmailAddress primaryEmail() {
        return this.primaryEmail;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserDetailsResponse)) {
            return false;
        }
        GetUserDetailsResponse other = (GetUserDetailsResponse)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.primaryEmail(), other.primaryEmail()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"GetUserDetailsResponse").add("UserId", (Object)this.userId()).add("UserName", (Object)this.userName()).add("DisplayName", (Object)this.displayName()).add("PrimaryEmail", (Object)this.primaryEmail()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "userName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "primaryEmail": {
                return Optional.ofNullable(clazz.cast(this.primaryEmail()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", USER_ID_FIELD);
        map.put("userName", USER_NAME_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("primaryEmail", PRIMARY_EMAIL_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUserDetailsResponse, T> g) {
        return obj -> g.apply((GetUserDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystResponse.BuilderImpl
    implements Builder {
        private String userId;
        private String userName;
        private String displayName;
        private EmailAddress primaryEmail;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserDetailsResponse model) {
            super(model);
            this.userId(model.userId);
            this.userName(model.userName);
            this.displayName(model.displayName);
            this.primaryEmail(model.primaryEmail);
            this.version(model.version);
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final EmailAddress.Builder getPrimaryEmail() {
            return this.primaryEmail != null ? this.primaryEmail.toBuilder() : null;
        }

        public final void setPrimaryEmail(EmailAddress.BuilderImpl primaryEmail) {
            this.primaryEmail = primaryEmail != null ? primaryEmail.build() : null;
        }

        @Override
        public final Builder primaryEmail(EmailAddress primaryEmail) {
            this.primaryEmail = primaryEmail;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public GetUserDetailsResponse build() {
            return new GetUserDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCatalystResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUserDetailsResponse> {
        public Builder userId(String var1);

        public Builder userName(String var1);

        public Builder displayName(String var1);

        public Builder primaryEmail(EmailAddress var1);

        default public Builder primaryEmail(Consumer<EmailAddress.Builder> primaryEmail) {
            return this.primaryEmail((EmailAddress)((EmailAddress.Builder)EmailAddress.builder().applyMutation(primaryEmail)).build());
        }

        public Builder version(String var1);
    }
}

