/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class CodeCatalystEndpointParams
implements ToCopyableBuilder<Builder, CodeCatalystEndpointParams> {
    private final Boolean useFIPS;
    private final Region region;
    private final String endpoint;

    private CodeCatalystEndpointParams(BuilderImpl builder) {
        this.useFIPS = builder.useFIPS;
        this.region = builder.region;
        this.endpoint = builder.endpoint;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public Region region() {
        return this.region;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Boolean useFIPS = false;
        private Region region;
        private String endpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeCatalystEndpointParams builder) {
            this.useFIPS = builder.useFIPS;
            this.region = builder.region;
            this.endpoint = builder.endpoint;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public CodeCatalystEndpointParams build() {
            return new CodeCatalystEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CodeCatalystEndpointParams> {
        public Builder useFips(Boolean var1);

        public Builder region(Region var1);

        public Builder endpoint(String var1);

        public CodeCatalystEndpointParams build();
    }
}

