/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecatalyst.model.CodeCatalystResponse;
import software.amazon.awssdk.services.codecatalyst.model.WorkflowDefinition;
import software.amazon.awssdk.services.codecatalyst.model.WorkflowRunMode;
import software.amazon.awssdk.services.codecatalyst.model.WorkflowStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowResponse
extends CodeCatalystResponse
implements ToCopyableBuilder<Builder, GetWorkflowResponse> {
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceName").getter(GetWorkflowResponse.getter(GetWorkflowResponse::spaceName)).setter(GetWorkflowResponse.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(GetWorkflowResponse.getter(GetWorkflowResponse::projectName)).setter(GetWorkflowResponse.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetWorkflowResponse.getter(GetWorkflowResponse::id)).setter(GetWorkflowResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetWorkflowResponse.getter(GetWorkflowResponse::name)).setter(GetWorkflowResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOURCE_REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceRepositoryName").getter(GetWorkflowResponse.getter(GetWorkflowResponse::sourceRepositoryName)).setter(GetWorkflowResponse.setter(Builder::sourceRepositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRepositoryName").build()}).build();
    private static final SdkField<String> SOURCE_BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceBranchName").getter(GetWorkflowResponse.getter(GetWorkflowResponse::sourceBranchName)).setter(GetWorkflowResponse.setter(Builder::sourceBranchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceBranchName").build()}).build();
    private static final SdkField<WorkflowDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(GetWorkflowResponse.getter(GetWorkflowResponse::definition)).setter(GetWorkflowResponse.setter(Builder::definition)).constructor(WorkflowDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(GetWorkflowResponse.getter(GetWorkflowResponse::createdTime)).setter(GetWorkflowResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(GetWorkflowResponse.getter(GetWorkflowResponse::lastUpdatedTime)).setter(GetWorkflowResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> RUN_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runMode").getter(GetWorkflowResponse.getter(GetWorkflowResponse::runModeAsString)).setter(GetWorkflowResponse.setter(Builder::runMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runMode").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetWorkflowResponse.getter(GetWorkflowResponse::statusAsString)).setter(GetWorkflowResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_NAME_FIELD, PROJECT_NAME_FIELD, ID_FIELD, NAME_FIELD, SOURCE_REPOSITORY_NAME_FIELD, SOURCE_BRANCH_NAME_FIELD, DEFINITION_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, RUN_MODE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkflowResponse.memberNameToFieldInitializer();
    private final String spaceName;
    private final String projectName;
    private final String id;
    private final String name;
    private final String sourceRepositoryName;
    private final String sourceBranchName;
    private final WorkflowDefinition definition;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final String runMode;
    private final String status;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.id = builder.id;
        this.name = builder.name;
        this.sourceRepositoryName = builder.sourceRepositoryName;
        this.sourceBranchName = builder.sourceBranchName;
        this.definition = builder.definition;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.runMode = builder.runMode;
        this.status = builder.status;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String sourceRepositoryName() {
        return this.sourceRepositoryName;
    }

    public final String sourceBranchName() {
        return this.sourceBranchName;
    }

    public final WorkflowDefinition definition() {
        return this.definition;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final WorkflowRunMode runMode() {
        return WorkflowRunMode.fromValue(this.runMode);
    }

    public final String runModeAsString() {
        return this.runMode;
    }

    public final WorkflowStatus status() {
        return WorkflowStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRepositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBranchName());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.runModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse)((Object)obj);
        return Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceRepositoryName(), other.sourceRepositoryName()) && Objects.equals(this.sourceBranchName(), other.sourceBranchName()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.runModeAsString(), other.runModeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowResponse").add("SpaceName", (Object)this.spaceName()).add("ProjectName", (Object)this.projectName()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("SourceRepositoryName", (Object)this.sourceRepositoryName()).add("SourceBranchName", (Object)this.sourceBranchName()).add("Definition", (Object)this.definition()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("RunMode", (Object)this.runModeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "sourceRepositoryName": {
                return Optional.ofNullable(clazz.cast(this.sourceRepositoryName()));
            }
            case "sourceBranchName": {
                return Optional.ofNullable(clazz.cast(this.sourceBranchName()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "runMode": {
                return Optional.ofNullable(clazz.cast(this.runModeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spaceName", SPACE_NAME_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sourceRepositoryName", SOURCE_REPOSITORY_NAME_FIELD);
        map.put("sourceBranchName", SOURCE_BRANCH_NAME_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("runMode", RUN_MODE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCatalystResponse.BuilderImpl
    implements Builder {
        private String spaceName;
        private String projectName;
        private String id;
        private String name;
        private String sourceRepositoryName;
        private String sourceBranchName;
        private WorkflowDefinition definition;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private String runMode;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            this.spaceName(model.spaceName);
            this.projectName(model.projectName);
            this.id(model.id);
            this.name(model.name);
            this.sourceRepositoryName(model.sourceRepositoryName);
            this.sourceBranchName(model.sourceBranchName);
            this.definition(model.definition);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.runMode(model.runMode);
            this.status(model.status);
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceRepositoryName() {
            return this.sourceRepositoryName;
        }

        public final void setSourceRepositoryName(String sourceRepositoryName) {
            this.sourceRepositoryName = sourceRepositoryName;
        }

        @Override
        public final Builder sourceRepositoryName(String sourceRepositoryName) {
            this.sourceRepositoryName = sourceRepositoryName;
            return this;
        }

        public final String getSourceBranchName() {
            return this.sourceBranchName;
        }

        public final void setSourceBranchName(String sourceBranchName) {
            this.sourceBranchName = sourceBranchName;
        }

        @Override
        public final Builder sourceBranchName(String sourceBranchName) {
            this.sourceBranchName = sourceBranchName;
            return this;
        }

        public final WorkflowDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(WorkflowDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(WorkflowDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getRunMode() {
            return this.runMode;
        }

        public final void setRunMode(String runMode) {
            this.runMode = runMode;
        }

        @Override
        public final Builder runMode(String runMode) {
            this.runMode = runMode;
            return this;
        }

        @Override
        public final Builder runMode(WorkflowRunMode runMode) {
            this.runMode(runMode == null ? null : runMode.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCatalystResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowResponse> {
        public Builder spaceName(String var1);

        public Builder projectName(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder sourceRepositoryName(String var1);

        public Builder sourceBranchName(String var1);

        public Builder definition(WorkflowDefinition var1);

        default public Builder definition(Consumer<WorkflowDefinition.Builder> definition) {
            return this.definition((WorkflowDefinition)((WorkflowDefinition.Builder)WorkflowDefinition.builder().applyMutation(definition)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder runMode(String var1);

        public Builder runMode(WorkflowRunMode var1);

        public Builder status(String var1);

        public Builder status(WorkflowStatus var1);
    }
}

