/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DevEnvironmentSessionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DevEnvironmentSessionSummary> {
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spaceName").getter(DevEnvironmentSessionSummary.getter(DevEnvironmentSessionSummary::spaceName)).setter(DevEnvironmentSessionSummary.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(DevEnvironmentSessionSummary.getter(DevEnvironmentSessionSummary::projectName)).setter(DevEnvironmentSessionSummary.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> DEV_ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("devEnvironmentId").getter(DevEnvironmentSessionSummary.getter(DevEnvironmentSessionSummary::devEnvironmentId)).setter(DevEnvironmentSessionSummary.setter(Builder::devEnvironmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devEnvironmentId").build()}).build();
    private static final SdkField<Instant> STARTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedTime").getter(DevEnvironmentSessionSummary.getter(DevEnvironmentSessionSummary::startedTime)).setter(DevEnvironmentSessionSummary.setter(Builder::startedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DevEnvironmentSessionSummary.getter(DevEnvironmentSessionSummary::id)).setter(DevEnvironmentSessionSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPACE_NAME_FIELD, PROJECT_NAME_FIELD, DEV_ENVIRONMENT_ID_FIELD, STARTED_TIME_FIELD, ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DevEnvironmentSessionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String spaceName;
    private final String projectName;
    private final String devEnvironmentId;
    private final Instant startedTime;
    private final String id;

    private DevEnvironmentSessionSummary(BuilderImpl builder) {
        this.spaceName = builder.spaceName;
        this.projectName = builder.projectName;
        this.devEnvironmentId = builder.devEnvironmentId;
        this.startedTime = builder.startedTime;
        this.id = builder.id;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String devEnvironmentId() {
        return this.devEnvironmentId;
    }

    public final Instant startedTime() {
        return this.startedTime;
    }

    public final String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.devEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DevEnvironmentSessionSummary)) {
            return false;
        }
        DevEnvironmentSessionSummary other = (DevEnvironmentSessionSummary)obj;
        return Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.devEnvironmentId(), other.devEnvironmentId()) && Objects.equals(this.startedTime(), other.startedTime()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"DevEnvironmentSessionSummary").add("SpaceName", (Object)this.spaceName()).add("ProjectName", (Object)this.projectName()).add("DevEnvironmentId", (Object)this.devEnvironmentId()).add("StartedTime", (Object)this.startedTime()).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "spaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "devEnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.devEnvironmentId()));
            }
            case "startedTime": {
                return Optional.ofNullable(clazz.cast(this.startedTime()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spaceName", SPACE_NAME_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("devEnvironmentId", DEV_ENVIRONMENT_ID_FIELD);
        map.put("startedTime", STARTED_TIME_FIELD);
        map.put("id", ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DevEnvironmentSessionSummary, T> g) {
        return obj -> g.apply((DevEnvironmentSessionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String spaceName;
        private String projectName;
        private String devEnvironmentId;
        private Instant startedTime;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(DevEnvironmentSessionSummary model) {
            this.spaceName(model.spaceName);
            this.projectName(model.projectName);
            this.devEnvironmentId(model.devEnvironmentId);
            this.startedTime(model.startedTime);
            this.id(model.id);
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getDevEnvironmentId() {
            return this.devEnvironmentId;
        }

        public final void setDevEnvironmentId(String devEnvironmentId) {
            this.devEnvironmentId = devEnvironmentId;
        }

        @Override
        public final Builder devEnvironmentId(String devEnvironmentId) {
            this.devEnvironmentId = devEnvironmentId;
            return this;
        }

        public final Instant getStartedTime() {
            return this.startedTime;
        }

        public final void setStartedTime(Instant startedTime) {
            this.startedTime = startedTime;
        }

        @Override
        public final Builder startedTime(Instant startedTime) {
            this.startedTime = startedTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public DevEnvironmentSessionSummary build() {
            return new DevEnvironmentSessionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DevEnvironmentSessionSummary> {
        public Builder spaceName(String var1);

        public Builder projectName(String var1);

        public Builder devEnvironmentId(String var1);

        public Builder startedTime(Instant var1);

        public Builder id(String var1);
    }
}

