/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailAddress
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailAddress> {
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("email").getter(EmailAddress.getter(EmailAddress::email)).setter(EmailAddress.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<Boolean> VERIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("verified").getter(EmailAddress.getter(EmailAddress::verified)).setter(EmailAddress.setter(Builder::verified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, VERIFIED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("email", EMAIL_FIELD);
            this.put("verified", VERIFIED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String email;
    private final Boolean verified;

    private EmailAddress(BuilderImpl builder) {
        this.email = builder.email;
        this.verified = builder.verified;
    }

    public final String email() {
        return this.email;
    }

    public final Boolean verified() {
        return this.verified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.verified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailAddress)) {
            return false;
        }
        EmailAddress other = (EmailAddress)obj;
        return Objects.equals(this.email(), other.email()) && Objects.equals(this.verified(), other.verified());
    }

    public final String toString() {
        return ToString.builder((String)"EmailAddress").add("Email", (Object)this.email()).add("Verified", (Object)this.verified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "verified": {
                return Optional.ofNullable(clazz.cast(this.verified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EmailAddress, T> g) {
        return obj -> g.apply((EmailAddress)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String email;
        private Boolean verified;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailAddress model) {
            this.email(model.email);
            this.verified(model.verified);
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final Boolean getVerified() {
            return this.verified;
        }

        public final void setVerified(Boolean verified) {
            this.verified = verified;
        }

        @Override
        public final Builder verified(Boolean verified) {
            this.verified = verified;
            return this;
        }

        public EmailAddress build() {
            return new EmailAddress(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailAddress> {
        public Builder email(String var1);

        public Builder verified(Boolean var1);
    }
}

