/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.TokenIdentity;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClientBuilder;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystServiceClientConfiguration;
import software.amazon.awssdk.services.codecatalyst.DefaultCodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.DefaultCodeCatalystBaseClientBuilder;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointProvider;

@SdkInternalApi
final class DefaultCodeCatalystAsyncClientBuilder
extends DefaultCodeCatalystBaseClientBuilder<CodeCatalystAsyncClientBuilder, CodeCatalystAsyncClient>
implements CodeCatalystAsyncClientBuilder {
    DefaultCodeCatalystAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeCatalystAsyncClientBuilder endpointProvider(CodeCatalystEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    @Override
    public DefaultCodeCatalystAsyncClientBuilder tokenProvider(IdentityProvider<? extends TokenIdentity> tokenProvider) {
        this.clientConfiguration.option((ClientOption)AwsClientOption.TOKEN_IDENTITY_PROVIDER, tokenProvider);
        return this;
    }

    protected final CodeCatalystAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeCatalystAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CodeCatalystServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCodeCatalystAsyncClient client = new DefaultCodeCatalystAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CodeCatalystServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CodeCatalystServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

