/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient;
import software.amazon.awssdk.services.codecatalyst.model.EventLogEntry;
import software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest;
import software.amazon.awssdk.services.codecatalyst.model.ListEventLogsResponse;

public class ListEventLogsPublisher
implements SdkPublisher<ListEventLogsResponse> {
    private final CodeCatalystAsyncClient client;
    private final ListEventLogsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventLogsPublisher(CodeCatalystAsyncClient client, ListEventLogsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventLogsPublisher(CodeCatalystAsyncClient client, ListEventLogsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventLogsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventLogsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventLogEntry> items() {
        Function<ListEventLogsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventLogsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventLogsResponseFetcher
    implements AsyncPageFetcher<ListEventLogsResponse> {
        private ListEventLogsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventLogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventLogsResponse> nextPage(ListEventLogsResponse previousPage) {
            if (previousPage == null) {
                return ListEventLogsPublisher.this.client.listEventLogs(ListEventLogsPublisher.this.firstRequest);
            }
            return ListEventLogsPublisher.this.client.listEventLogs((ListEventLogsRequest)((Object)ListEventLogsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

