/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecatalyst.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointParams;
import software.amazon.awssdk.services.codecatalyst.endpoints.CodeCatalystEndpointProvider;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.Condition;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.Expr;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.FnNode;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.Identifier;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.Parameter;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.Parameters;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.Rule;
import software.amazon.awssdk.services.codecatalyst.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultCodeCatalystEndpointProvider
implements CodeCatalystEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultCodeCatalystEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(CodeCatalystEndpointParams endpointParams) {
        Validate.notNull((Object)endpointParams.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultCodeCatalystEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(CodeCatalystEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate(), Expr.of(false))).build().validate()).build()).error("Partition does not support FIPS.");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://codecatalyst-fips.global.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_3() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCodeCatalystEndpointProvider.endpointRule_4(), DefaultCodeCatalystEndpointProvider.endpointRule_5()));
    }

    private static Rule endpointRule_6() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://codecatalyst.global.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_2() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.of("us-west-2"))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultCodeCatalystEndpointProvider.endpointRule_3(), DefaultCodeCatalystEndpointProvider.endpointRule_6()));
    }

    private static Rule endpointRule_9() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate(), Expr.of(false))).build().validate()).build()).error("Partition does not support FIPS.");
    }

    private static Rule endpointRule_10() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://codecatalyst-fips.global.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultCodeCatalystEndpointProvider.endpointRule_9(), DefaultCodeCatalystEndpointProvider.endpointRule_10()));
    }

    private static Rule endpointRule_11() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://codecatalyst.global.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultCodeCatalystEndpointProvider.endpointRule_8(), DefaultCodeCatalystEndpointProvider.endpointRule_11()));
    }

    private static Rule endpointRule_0() {
        return Rule.builder().treeRule(Arrays.asList(DefaultCodeCatalystEndpointProvider.endpointRule_1(), DefaultCodeCatalystEndpointProvider.endpointRule_2(), DefaultCodeCatalystEndpointProvider.endpointRule_7()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.3").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).build()).addRule(DefaultCodeCatalystEndpointProvider.endpointRule_0()).build();
    }
}

