/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CacheType {
    NO_CACHE("NO_CACHE"),
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CacheType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CacheType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CacheType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CacheType> knownValues() {
        return Stream.of(CacheType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

