/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesForProjectRequest;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesForProjectResponse;

public class ListSandboxesForProjectIterable
implements SdkIterable<ListSandboxesForProjectResponse> {
    private final CodeBuildClient client;
    private final ListSandboxesForProjectRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSandboxesForProjectIterable(CodeBuildClient client, ListSandboxesForProjectRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSandboxesForProjectResponseFetcher();
    }

    public Iterator<ListSandboxesForProjectResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> ids() {
        Function<ListSandboxesForProjectResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSandboxesForProjectResponseFetcher
    implements SyncPageFetcher<ListSandboxesForProjectResponse> {
        private ListSandboxesForProjectResponseFetcher() {
        }

        public boolean hasNextPage(ListSandboxesForProjectResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSandboxesForProjectResponse nextPage(ListSandboxesForProjectResponse previousPage) {
            if (previousPage == null) {
                return ListSandboxesForProjectIterable.this.client.listSandboxesForProject(ListSandboxesForProjectIterable.this.firstRequest);
            }
            return ListSandboxesForProjectIterable.this.client.listSandboxesForProject((ListSandboxesForProjectRequest)((Object)ListSandboxesForProjectIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

