/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CommandType;
import software.amazon.awssdk.services.codebuild.model.LogsLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommandExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommandExecution> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CommandExecution.getter(CommandExecution::id)).setter(CommandExecution.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> SANDBOX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sandboxId").getter(CommandExecution.getter(CommandExecution::sandboxId)).setter(CommandExecution.setter(Builder::sandboxId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxId").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("submitTime").getter(CommandExecution.getter(CommandExecution::submitTime)).setter(CommandExecution.setter(Builder::submitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submitTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(CommandExecution.getter(CommandExecution::startTime)).setter(CommandExecution.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(CommandExecution.getter(CommandExecution::endTime)).setter(CommandExecution.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CommandExecution.getter(CommandExecution::status)).setter(CommandExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("command").getter(CommandExecution.getter(CommandExecution::command)).setter(CommandExecution.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CommandExecution.getter(CommandExecution::typeAsString)).setter(CommandExecution.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exitCode").getter(CommandExecution.getter(CommandExecution::exitCode)).setter(CommandExecution.setter(Builder::exitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()}).build();
    private static final SdkField<String> STANDARD_OUTPUT_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("standardOutputContent").getter(CommandExecution.getter(CommandExecution::standardOutputContent)).setter(CommandExecution.setter(Builder::standardOutputContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardOutputContent").build()}).build();
    private static final SdkField<String> STANDARD_ERR_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("standardErrContent").getter(CommandExecution.getter(CommandExecution::standardErrContent)).setter(CommandExecution.setter(Builder::standardErrContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardErrContent").build()}).build();
    private static final SdkField<LogsLocation> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logs").getter(CommandExecution.getter(CommandExecution::logs)).setter(CommandExecution.setter(Builder::logs)).constructor(LogsLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()}).build();
    private static final SdkField<String> SANDBOX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sandboxArn").getter(CommandExecution.getter(CommandExecution::sandboxArn)).setter(CommandExecution.setter(Builder::sandboxArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SANDBOX_ID_FIELD, SUBMIT_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, COMMAND_FIELD, TYPE_FIELD, EXIT_CODE_FIELD, STANDARD_OUTPUT_CONTENT_FIELD, STANDARD_ERR_CONTENT_FIELD, LOGS_FIELD, SANDBOX_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CommandExecution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String sandboxId;
    private final Instant submitTime;
    private final Instant startTime;
    private final Instant endTime;
    private final String status;
    private final String command;
    private final String type;
    private final String exitCode;
    private final String standardOutputContent;
    private final String standardErrContent;
    private final LogsLocation logs;
    private final String sandboxArn;

    private CommandExecution(BuilderImpl builder) {
        this.id = builder.id;
        this.sandboxId = builder.sandboxId;
        this.submitTime = builder.submitTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.command = builder.command;
        this.type = builder.type;
        this.exitCode = builder.exitCode;
        this.standardOutputContent = builder.standardOutputContent;
        this.standardErrContent = builder.standardErrContent;
        this.logs = builder.logs;
        this.sandboxArn = builder.sandboxArn;
    }

    public final String id() {
        return this.id;
    }

    public final String sandboxId() {
        return this.sandboxId;
    }

    public final Instant submitTime() {
        return this.submitTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String status() {
        return this.status;
    }

    public final String command() {
        return this.command;
    }

    public final CommandType type() {
        return CommandType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String exitCode() {
        return this.exitCode;
    }

    public final String standardOutputContent() {
        return this.standardOutputContent;
    }

    public final String standardErrContent() {
        return this.standardErrContent;
    }

    public final LogsLocation logs() {
        return this.logs;
    }

    public final String sandboxArn() {
        return this.sandboxArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.sandboxId());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutputContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardErrContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.sandboxArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommandExecution)) {
            return false;
        }
        CommandExecution other = (CommandExecution)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.sandboxId(), other.sandboxId()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.exitCode(), other.exitCode()) && Objects.equals(this.standardOutputContent(), other.standardOutputContent()) && Objects.equals(this.standardErrContent(), other.standardErrContent()) && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.sandboxArn(), other.sandboxArn());
    }

    public final String toString() {
        return ToString.builder((String)"CommandExecution").add("Id", (Object)this.id()).add("SandboxId", (Object)this.sandboxId()).add("SubmitTime", (Object)this.submitTime()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.status()).add("Command", (Object)(this.command() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("ExitCode", (Object)this.exitCode()).add("StandardOutputContent", (Object)(this.standardOutputContent() == null ? null : "*** Sensitive Data Redacted ***")).add("StandardErrContent", (Object)(this.standardErrContent() == null ? null : "*** Sensitive Data Redacted ***")).add("Logs", (Object)this.logs()).add("SandboxArn", (Object)this.sandboxArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "sandboxId": {
                return Optional.ofNullable(clazz.cast(this.sandboxId()));
            }
            case "submitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "exitCode": {
                return Optional.ofNullable(clazz.cast(this.exitCode()));
            }
            case "standardOutputContent": {
                return Optional.ofNullable(clazz.cast(this.standardOutputContent()));
            }
            case "standardErrContent": {
                return Optional.ofNullable(clazz.cast(this.standardErrContent()));
            }
            case "logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "sandboxArn": {
                return Optional.ofNullable(clazz.cast(this.sandboxArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("sandboxId", SANDBOX_ID_FIELD);
        map.put("submitTime", SUBMIT_TIME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("exitCode", EXIT_CODE_FIELD);
        map.put("standardOutputContent", STANDARD_OUTPUT_CONTENT_FIELD);
        map.put("standardErrContent", STANDARD_ERR_CONTENT_FIELD);
        map.put("logs", LOGS_FIELD);
        map.put("sandboxArn", SANDBOX_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommandExecution, T> g) {
        return obj -> g.apply((CommandExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String sandboxId;
        private Instant submitTime;
        private Instant startTime;
        private Instant endTime;
        private String status;
        private String command;
        private String type;
        private String exitCode;
        private String standardOutputContent;
        private String standardErrContent;
        private LogsLocation logs;
        private String sandboxArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CommandExecution model) {
            this.id(model.id);
            this.sandboxId(model.sandboxId);
            this.submitTime(model.submitTime);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
            this.command(model.command);
            this.type(model.type);
            this.exitCode(model.exitCode);
            this.standardOutputContent(model.standardOutputContent);
            this.standardErrContent(model.standardErrContent);
            this.logs(model.logs);
            this.sandboxArn(model.sandboxArn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSandboxId() {
            return this.sandboxId;
        }

        public final void setSandboxId(String sandboxId) {
            this.sandboxId = sandboxId;
        }

        @Override
        public final Builder sandboxId(String sandboxId) {
            this.sandboxId = sandboxId;
            return this;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getCommand() {
            return this.command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CommandType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getExitCode() {
            return this.exitCode;
        }

        public final void setExitCode(String exitCode) {
            this.exitCode = exitCode;
        }

        @Override
        public final Builder exitCode(String exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final String getStandardOutputContent() {
            return this.standardOutputContent;
        }

        public final void setStandardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
        }

        @Override
        public final Builder standardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
            return this;
        }

        public final String getStandardErrContent() {
            return this.standardErrContent;
        }

        public final void setStandardErrContent(String standardErrContent) {
            this.standardErrContent = standardErrContent;
        }

        @Override
        public final Builder standardErrContent(String standardErrContent) {
            this.standardErrContent = standardErrContent;
            return this;
        }

        public final LogsLocation.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        public final void setLogs(LogsLocation.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public final Builder logs(LogsLocation logs) {
            this.logs = logs;
            return this;
        }

        public final String getSandboxArn() {
            return this.sandboxArn;
        }

        public final void setSandboxArn(String sandboxArn) {
            this.sandboxArn = sandboxArn;
        }

        @Override
        public final Builder sandboxArn(String sandboxArn) {
            this.sandboxArn = sandboxArn;
            return this;
        }

        public CommandExecution build() {
            return new CommandExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommandExecution> {
        public Builder id(String var1);

        public Builder sandboxId(String var1);

        public Builder submitTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder status(String var1);

        public Builder command(String var1);

        public Builder type(String var1);

        public Builder type(CommandType var1);

        public Builder exitCode(String var1);

        public Builder standardOutputContent(String var1);

        public Builder standardErrContent(String var1);

        public Builder logs(LogsLocation var1);

        default public Builder logs(Consumer<LogsLocation.Builder> logs) {
            return this.logs((LogsLocation)((LogsLocation.Builder)LogsLocation.builder().applyMutation(logs)).build());
        }

        public Builder sandboxArn(String var1);
    }
}

