/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.Fleet;
import software.amazon.awssdk.services.codebuild.model.FleetNamesCopier;
import software.amazon.awssdk.services.codebuild.model.FleetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetFleetsResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, BatchGetFleetsResponse> {
    private static final SdkField<List<Fleet>> FLEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fleets").getter(BatchGetFleetsResponse.getter(BatchGetFleetsResponse::fleets)).setter(BatchGetFleetsResponse.setter(Builder::fleets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Fleet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FLEETS_NOT_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fleetsNotFound").getter(BatchGetFleetsResponse.getter(BatchGetFleetsResponse::fleetsNotFound)).setter(BatchGetFleetsResponse.setter(Builder::fleetsNotFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetsNotFound").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEETS_FIELD, FLEETS_NOT_FOUND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetFleetsResponse.memberNameToFieldInitializer();
    private final List<Fleet> fleets;
    private final List<String> fleetsNotFound;

    private BatchGetFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.fleets = builder.fleets;
        this.fleetsNotFound = builder.fleetsNotFound;
    }

    public final boolean hasFleets() {
        return this.fleets != null && !(this.fleets instanceof SdkAutoConstructList);
    }

    public final List<Fleet> fleets() {
        return this.fleets;
    }

    public final boolean hasFleetsNotFound() {
        return this.fleetsNotFound != null && !(this.fleetsNotFound instanceof SdkAutoConstructList);
    }

    public final List<String> fleetsNotFound() {
        return this.fleetsNotFound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleets() ? this.fleets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFleetsNotFound() ? this.fleetsNotFound() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFleetsResponse)) {
            return false;
        }
        BatchGetFleetsResponse other = (BatchGetFleetsResponse)((Object)obj);
        return this.hasFleets() == other.hasFleets() && Objects.equals(this.fleets(), other.fleets()) && this.hasFleetsNotFound() == other.hasFleetsNotFound() && Objects.equals(this.fleetsNotFound(), other.fleetsNotFound());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetFleetsResponse").add("Fleets", this.hasFleets() ? this.fleets() : null).add("FleetsNotFound", this.hasFleetsNotFound() ? this.fleetsNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fleets": {
                return Optional.ofNullable(clazz.cast(this.fleets()));
            }
            case "fleetsNotFound": {
                return Optional.ofNullable(clazz.cast(this.fleetsNotFound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fleets", FLEETS_FIELD);
        map.put("fleetsNotFound", FLEETS_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFleetsResponse, T> g) {
        return obj -> g.apply((BatchGetFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<Fleet> fleets = DefaultSdkAutoConstructList.getInstance();
        private List<String> fleetsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFleetsResponse model) {
            super(model);
            this.fleets(model.fleets);
            this.fleetsNotFound(model.fleetsNotFound);
        }

        public final List<Fleet.Builder> getFleets() {
            List<Fleet.Builder> result = FleetsCopier.copyToBuilder(this.fleets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleets(Collection<Fleet.BuilderImpl> fleets) {
            this.fleets = FleetsCopier.copyFromBuilder(fleets);
        }

        @Override
        public final Builder fleets(Collection<Fleet> fleets) {
            this.fleets = FleetsCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Fleet ... fleets) {
            this.fleets(Arrays.asList(fleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Consumer<Fleet.Builder> ... fleets) {
            this.fleets(Stream.of(fleets).map(c -> (Fleet)((Fleet.Builder)Fleet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getFleetsNotFound() {
            if (this.fleetsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fleetsNotFound;
        }

        public final void setFleetsNotFound(Collection<String> fleetsNotFound) {
            this.fleetsNotFound = FleetNamesCopier.copy(fleetsNotFound);
        }

        @Override
        public final Builder fleetsNotFound(Collection<String> fleetsNotFound) {
            this.fleetsNotFound = FleetNamesCopier.copy(fleetsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetsNotFound(String ... fleetsNotFound) {
            this.fleetsNotFound(Arrays.asList(fleetsNotFound));
            return this;
        }

        @Override
        public BatchGetFleetsResponse build() {
            return new BatchGetFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetFleetsResponse> {
        public Builder fleets(Collection<Fleet> var1);

        public Builder fleets(Fleet ... var1);

        public Builder fleets(Consumer<Fleet.Builder> ... var1);

        public Builder fleetsNotFound(Collection<String> var1);

        public Builder fleetsNotFound(String ... var1);
    }
}

