/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.CommandExecution;
import software.amazon.awssdk.services.codebuild.model.ListCommandExecutionsForSandboxRequest;
import software.amazon.awssdk.services.codebuild.model.ListCommandExecutionsForSandboxResponse;

public class ListCommandExecutionsForSandboxIterable
implements SdkIterable<ListCommandExecutionsForSandboxResponse> {
    private final CodeBuildClient client;
    private final ListCommandExecutionsForSandboxRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCommandExecutionsForSandboxIterable(CodeBuildClient client, ListCommandExecutionsForSandboxRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCommandExecutionsForSandboxResponseFetcher();
    }

    public Iterator<ListCommandExecutionsForSandboxResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CommandExecution> commandExecutions() {
        Function<ListCommandExecutionsForSandboxResponse, Iterator> getIterator = response -> {
            if (response != null && response.commandExecutions() != null) {
                return response.commandExecutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCommandExecutionsForSandboxResponseFetcher
    implements SyncPageFetcher<ListCommandExecutionsForSandboxResponse> {
        private ListCommandExecutionsForSandboxResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandExecutionsForSandboxResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCommandExecutionsForSandboxResponse nextPage(ListCommandExecutionsForSandboxResponse previousPage) {
            if (previousPage == null) {
                return ListCommandExecutionsForSandboxIterable.this.client.listCommandExecutionsForSandbox(ListCommandExecutionsForSandboxIterable.this.firstRequest);
            }
            return ListCommandExecutionsForSandboxIterable.this.client.listCommandExecutionsForSandbox((ListCommandExecutionsForSandboxRequest)((Object)ListCommandExecutionsForSandboxIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

