/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeCoverageReportSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeCoverageReportSummary> {
    private static final SdkField<Double> LINE_COVERAGE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("lineCoveragePercentage").getter(CodeCoverageReportSummary.getter(CodeCoverageReportSummary::lineCoveragePercentage)).setter(CodeCoverageReportSummary.setter(Builder::lineCoveragePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineCoveragePercentage").build()}).build();
    private static final SdkField<Integer> LINES_COVERED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("linesCovered").getter(CodeCoverageReportSummary.getter(CodeCoverageReportSummary::linesCovered)).setter(CodeCoverageReportSummary.setter(Builder::linesCovered)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linesCovered").build()}).build();
    private static final SdkField<Integer> LINES_MISSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("linesMissed").getter(CodeCoverageReportSummary.getter(CodeCoverageReportSummary::linesMissed)).setter(CodeCoverageReportSummary.setter(Builder::linesMissed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linesMissed").build()}).build();
    private static final SdkField<Double> BRANCH_COVERAGE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("branchCoveragePercentage").getter(CodeCoverageReportSummary.getter(CodeCoverageReportSummary::branchCoveragePercentage)).setter(CodeCoverageReportSummary.setter(Builder::branchCoveragePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchCoveragePercentage").build()}).build();
    private static final SdkField<Integer> BRANCHES_COVERED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("branchesCovered").getter(CodeCoverageReportSummary.getter(CodeCoverageReportSummary::branchesCovered)).setter(CodeCoverageReportSummary.setter(Builder::branchesCovered)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchesCovered").build()}).build();
    private static final SdkField<Integer> BRANCHES_MISSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("branchesMissed").getter(CodeCoverageReportSummary.getter(CodeCoverageReportSummary::branchesMissed)).setter(CodeCoverageReportSummary.setter(Builder::branchesMissed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchesMissed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINE_COVERAGE_PERCENTAGE_FIELD, LINES_COVERED_FIELD, LINES_MISSED_FIELD, BRANCH_COVERAGE_PERCENTAGE_FIELD, BRANCHES_COVERED_FIELD, BRANCHES_MISSED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeCoverageReportSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double lineCoveragePercentage;
    private final Integer linesCovered;
    private final Integer linesMissed;
    private final Double branchCoveragePercentage;
    private final Integer branchesCovered;
    private final Integer branchesMissed;

    private CodeCoverageReportSummary(BuilderImpl builder) {
        this.lineCoveragePercentage = builder.lineCoveragePercentage;
        this.linesCovered = builder.linesCovered;
        this.linesMissed = builder.linesMissed;
        this.branchCoveragePercentage = builder.branchCoveragePercentage;
        this.branchesCovered = builder.branchesCovered;
        this.branchesMissed = builder.branchesMissed;
    }

    public final Double lineCoveragePercentage() {
        return this.lineCoveragePercentage;
    }

    public final Integer linesCovered() {
        return this.linesCovered;
    }

    public final Integer linesMissed() {
        return this.linesMissed;
    }

    public final Double branchCoveragePercentage() {
        return this.branchCoveragePercentage;
    }

    public final Integer branchesCovered() {
        return this.branchesCovered;
    }

    public final Integer branchesMissed() {
        return this.branchesMissed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lineCoveragePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.linesCovered());
        hashCode = 31 * hashCode + Objects.hashCode(this.linesMissed());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchCoveragePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchesCovered());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchesMissed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeCoverageReportSummary)) {
            return false;
        }
        CodeCoverageReportSummary other = (CodeCoverageReportSummary)obj;
        return Objects.equals(this.lineCoveragePercentage(), other.lineCoveragePercentage()) && Objects.equals(this.linesCovered(), other.linesCovered()) && Objects.equals(this.linesMissed(), other.linesMissed()) && Objects.equals(this.branchCoveragePercentage(), other.branchCoveragePercentage()) && Objects.equals(this.branchesCovered(), other.branchesCovered()) && Objects.equals(this.branchesMissed(), other.branchesMissed());
    }

    public final String toString() {
        return ToString.builder((String)"CodeCoverageReportSummary").add("LineCoveragePercentage", (Object)this.lineCoveragePercentage()).add("LinesCovered", (Object)this.linesCovered()).add("LinesMissed", (Object)this.linesMissed()).add("BranchCoveragePercentage", (Object)this.branchCoveragePercentage()).add("BranchesCovered", (Object)this.branchesCovered()).add("BranchesMissed", (Object)this.branchesMissed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lineCoveragePercentage": {
                return Optional.ofNullable(clazz.cast(this.lineCoveragePercentage()));
            }
            case "linesCovered": {
                return Optional.ofNullable(clazz.cast(this.linesCovered()));
            }
            case "linesMissed": {
                return Optional.ofNullable(clazz.cast(this.linesMissed()));
            }
            case "branchCoveragePercentage": {
                return Optional.ofNullable(clazz.cast(this.branchCoveragePercentage()));
            }
            case "branchesCovered": {
                return Optional.ofNullable(clazz.cast(this.branchesCovered()));
            }
            case "branchesMissed": {
                return Optional.ofNullable(clazz.cast(this.branchesMissed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lineCoveragePercentage", LINE_COVERAGE_PERCENTAGE_FIELD);
        map.put("linesCovered", LINES_COVERED_FIELD);
        map.put("linesMissed", LINES_MISSED_FIELD);
        map.put("branchCoveragePercentage", BRANCH_COVERAGE_PERCENTAGE_FIELD);
        map.put("branchesCovered", BRANCHES_COVERED_FIELD);
        map.put("branchesMissed", BRANCHES_MISSED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeCoverageReportSummary, T> g) {
        return obj -> g.apply((CodeCoverageReportSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double lineCoveragePercentage;
        private Integer linesCovered;
        private Integer linesMissed;
        private Double branchCoveragePercentage;
        private Integer branchesCovered;
        private Integer branchesMissed;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeCoverageReportSummary model) {
            this.lineCoveragePercentage(model.lineCoveragePercentage);
            this.linesCovered(model.linesCovered);
            this.linesMissed(model.linesMissed);
            this.branchCoveragePercentage(model.branchCoveragePercentage);
            this.branchesCovered(model.branchesCovered);
            this.branchesMissed(model.branchesMissed);
        }

        public final Double getLineCoveragePercentage() {
            return this.lineCoveragePercentage;
        }

        public final void setLineCoveragePercentage(Double lineCoveragePercentage) {
            this.lineCoveragePercentage = lineCoveragePercentage;
        }

        @Override
        public final Builder lineCoveragePercentage(Double lineCoveragePercentage) {
            this.lineCoveragePercentage = lineCoveragePercentage;
            return this;
        }

        public final Integer getLinesCovered() {
            return this.linesCovered;
        }

        public final void setLinesCovered(Integer linesCovered) {
            this.linesCovered = linesCovered;
        }

        @Override
        public final Builder linesCovered(Integer linesCovered) {
            this.linesCovered = linesCovered;
            return this;
        }

        public final Integer getLinesMissed() {
            return this.linesMissed;
        }

        public final void setLinesMissed(Integer linesMissed) {
            this.linesMissed = linesMissed;
        }

        @Override
        public final Builder linesMissed(Integer linesMissed) {
            this.linesMissed = linesMissed;
            return this;
        }

        public final Double getBranchCoveragePercentage() {
            return this.branchCoveragePercentage;
        }

        public final void setBranchCoveragePercentage(Double branchCoveragePercentage) {
            this.branchCoveragePercentage = branchCoveragePercentage;
        }

        @Override
        public final Builder branchCoveragePercentage(Double branchCoveragePercentage) {
            this.branchCoveragePercentage = branchCoveragePercentage;
            return this;
        }

        public final Integer getBranchesCovered() {
            return this.branchesCovered;
        }

        public final void setBranchesCovered(Integer branchesCovered) {
            this.branchesCovered = branchesCovered;
        }

        @Override
        public final Builder branchesCovered(Integer branchesCovered) {
            this.branchesCovered = branchesCovered;
            return this;
        }

        public final Integer getBranchesMissed() {
            return this.branchesMissed;
        }

        public final void setBranchesMissed(Integer branchesMissed) {
            this.branchesMissed = branchesMissed;
        }

        @Override
        public final Builder branchesMissed(Integer branchesMissed) {
            this.branchesMissed = branchesMissed;
            return this;
        }

        public CodeCoverageReportSummary build() {
            return new CodeCoverageReportSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeCoverageReportSummary> {
        public Builder lineCoveragePercentage(Double var1);

        public Builder linesCovered(Integer var1);

        public Builder linesMissed(Integer var1);

        public Builder branchCoveragePercentage(Double var1);

        public Builder branchesCovered(Integer var1);

        public Builder branchesMissed(Integer var1);
    }
}

