/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.CommandType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCommandExecutionRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, StartCommandExecutionRequest> {
    private static final SdkField<String> SANDBOX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sandboxId").getter(StartCommandExecutionRequest.getter(StartCommandExecutionRequest::sandboxId)).setter(StartCommandExecutionRequest.setter(Builder::sandboxId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxId").build()}).build();
    private static final SdkField<String> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("command").getter(StartCommandExecutionRequest.getter(StartCommandExecutionRequest::command)).setter(StartCommandExecutionRequest.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(StartCommandExecutionRequest.getter(StartCommandExecutionRequest::typeAsString)).setter(StartCommandExecutionRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SANDBOX_ID_FIELD, COMMAND_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartCommandExecutionRequest.memberNameToFieldInitializer();
    private final String sandboxId;
    private final String command;
    private final String type;

    private StartCommandExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.sandboxId = builder.sandboxId;
        this.command = builder.command;
        this.type = builder.type;
    }

    public final String sandboxId() {
        return this.sandboxId;
    }

    public final String command() {
        return this.command;
    }

    public final CommandType type() {
        return CommandType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sandboxId());
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCommandExecutionRequest)) {
            return false;
        }
        StartCommandExecutionRequest other = (StartCommandExecutionRequest)((Object)obj);
        return Objects.equals(this.sandboxId(), other.sandboxId()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartCommandExecutionRequest").add("SandboxId", (Object)this.sandboxId()).add("Command", (Object)(this.command() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sandboxId": {
                return Optional.ofNullable(clazz.cast(this.sandboxId()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sandboxId", SANDBOX_ID_FIELD);
        map.put("command", COMMAND_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCommandExecutionRequest, T> g) {
        return obj -> g.apply((StartCommandExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String sandboxId;
        private String command;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCommandExecutionRequest model) {
            super(model);
            this.sandboxId(model.sandboxId);
            this.command(model.command);
            this.type(model.type);
        }

        public final String getSandboxId() {
            return this.sandboxId;
        }

        public final void setSandboxId(String sandboxId) {
            this.sandboxId = sandboxId;
        }

        @Override
        public final Builder sandboxId(String sandboxId) {
            this.sandboxId = sandboxId;
            return this;
        }

        public final String getCommand() {
            return this.command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CommandType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCommandExecutionRequest build() {
            return new StartCommandExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCommandExecutionRequest> {
        public Builder sandboxId(String var1);

        public Builder command(String var1);

        public Builder type(String var1);

        public Builder type(CommandType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

