/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesRequest;
import software.amazon.awssdk.services.codebuild.model.ListSandboxesResponse;

public class ListSandboxesPublisher
implements SdkPublisher<ListSandboxesResponse> {
    private final CodeBuildAsyncClient client;
    private final ListSandboxesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSandboxesPublisher(CodeBuildAsyncClient client, ListSandboxesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSandboxesPublisher(CodeBuildAsyncClient client, ListSandboxesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSandboxesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSandboxesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> ids() {
        Function<ListSandboxesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSandboxesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSandboxesResponseFetcher
    implements AsyncPageFetcher<ListSandboxesResponse> {
        private ListSandboxesResponseFetcher() {
        }

        public boolean hasNextPage(ListSandboxesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSandboxesResponse> nextPage(ListSandboxesResponse previousPage) {
            if (previousPage == null) {
                return ListSandboxesPublisher.this.client.listSandboxes(ListSandboxesPublisher.this.firstRequest);
            }
            return ListSandboxesPublisher.this.client.listSandboxes((ListSandboxesRequest)((Object)ListSandboxesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

