/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.MachineType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeConfiguration> {
    private static final SdkField<Long> V_CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("vCpu").getter(ComputeConfiguration.getter(ComputeConfiguration::vCpu)).setter(ComputeConfiguration.setter(Builder::vCpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vCpu").build()}).build();
    private static final SdkField<Long> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("memory").getter(ComputeConfiguration.getter(ComputeConfiguration::memory)).setter(ComputeConfiguration.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<Long> DISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("disk").getter(ComputeConfiguration.getter(ComputeConfiguration::disk)).setter(ComputeConfiguration.setter(Builder::disk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disk").build()}).build();
    private static final SdkField<String> MACHINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("machineType").getter(ComputeConfiguration.getter(ComputeConfiguration::machineTypeAsString)).setter(ComputeConfiguration.setter(Builder::machineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("machineType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V_CPU_FIELD, MEMORY_FIELD, DISK_FIELD, MACHINE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComputeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long vCpu;
    private final Long memory;
    private final Long disk;
    private final String machineType;

    private ComputeConfiguration(BuilderImpl builder) {
        this.vCpu = builder.vCpu;
        this.memory = builder.memory;
        this.disk = builder.disk;
        this.machineType = builder.machineType;
    }

    public final Long vCpu() {
        return this.vCpu;
    }

    public final Long memory() {
        return this.memory;
    }

    public final Long disk() {
        return this.disk;
    }

    public final MachineType machineType() {
        return MachineType.fromValue(this.machineType);
    }

    public final String machineTypeAsString() {
        return this.machineType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vCpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.disk());
        hashCode = 31 * hashCode + Objects.hashCode(this.machineTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeConfiguration)) {
            return false;
        }
        ComputeConfiguration other = (ComputeConfiguration)obj;
        return Objects.equals(this.vCpu(), other.vCpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.disk(), other.disk()) && Objects.equals(this.machineTypeAsString(), other.machineTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeConfiguration").add("VCpu", (Object)this.vCpu()).add("Memory", (Object)this.memory()).add("Disk", (Object)this.disk()).add("MachineType", (Object)this.machineTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vCpu": {
                return Optional.ofNullable(clazz.cast(this.vCpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "disk": {
                return Optional.ofNullable(clazz.cast(this.disk()));
            }
            case "machineType": {
                return Optional.ofNullable(clazz.cast(this.machineTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vCpu", V_CPU_FIELD);
        map.put("memory", MEMORY_FIELD);
        map.put("disk", DISK_FIELD);
        map.put("machineType", MACHINE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeConfiguration, T> g) {
        return obj -> g.apply((ComputeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long vCpu;
        private Long memory;
        private Long disk;
        private String machineType;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeConfiguration model) {
            this.vCpu(model.vCpu);
            this.memory(model.memory);
            this.disk(model.disk);
            this.machineType(model.machineType);
        }

        public final Long getVCpu() {
            return this.vCpu;
        }

        public final void setVCpu(Long vCpu) {
            this.vCpu = vCpu;
        }

        @Override
        public final Builder vCpu(Long vCpu) {
            this.vCpu = vCpu;
            return this;
        }

        public final Long getMemory() {
            return this.memory;
        }

        public final void setMemory(Long memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Long memory) {
            this.memory = memory;
            return this;
        }

        public final Long getDisk() {
            return this.disk;
        }

        public final void setDisk(Long disk) {
            this.disk = disk;
        }

        @Override
        public final Builder disk(Long disk) {
            this.disk = disk;
            return this;
        }

        public final String getMachineType() {
            return this.machineType;
        }

        public final void setMachineType(String machineType) {
            this.machineType = machineType;
        }

        @Override
        public final Builder machineType(String machineType) {
            this.machineType = machineType;
            return this;
        }

        @Override
        public final Builder machineType(MachineType machineType) {
            this.machineType(machineType == null ? null : machineType.toString());
            return this;
        }

        public ComputeConfiguration build() {
            return new ComputeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeConfiguration> {
        public Builder vCpu(Long var1);

        public Builder memory(Long var1);

        public Builder disk(Long var1);

        public Builder machineType(String var1);

        public Builder machineType(MachineType var1);
    }
}

