/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.BatchReportModeType;
import software.amazon.awssdk.services.codebuild.model.BatchRestrictions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectBuildBatchConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectBuildBatchConfig> {
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(ProjectBuildBatchConfig.getter(ProjectBuildBatchConfig::serviceRole)).setter(ProjectBuildBatchConfig.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<Boolean> COMBINE_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("combineArtifacts").getter(ProjectBuildBatchConfig.getter(ProjectBuildBatchConfig::combineArtifacts)).setter(ProjectBuildBatchConfig.setter(Builder::combineArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("combineArtifacts").build()}).build();
    private static final SdkField<BatchRestrictions> RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("restrictions").getter(ProjectBuildBatchConfig.getter(ProjectBuildBatchConfig::restrictions)).setter(ProjectBuildBatchConfig.setter(Builder::restrictions)).constructor(BatchRestrictions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restrictions").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutInMins").getter(ProjectBuildBatchConfig.getter(ProjectBuildBatchConfig::timeoutInMins)).setter(ProjectBuildBatchConfig.setter(Builder::timeoutInMins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMins").build()}).build();
    private static final SdkField<String> BATCH_REPORT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("batchReportMode").getter(ProjectBuildBatchConfig.getter(ProjectBuildBatchConfig::batchReportModeAsString)).setter(ProjectBuildBatchConfig.setter(Builder::batchReportMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchReportMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ROLE_FIELD, COMBINE_ARTIFACTS_FIELD, RESTRICTIONS_FIELD, TIMEOUT_IN_MINS_FIELD, BATCH_REPORT_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProjectBuildBatchConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceRole;
    private final Boolean combineArtifacts;
    private final BatchRestrictions restrictions;
    private final Integer timeoutInMins;
    private final String batchReportMode;

    private ProjectBuildBatchConfig(BuilderImpl builder) {
        this.serviceRole = builder.serviceRole;
        this.combineArtifacts = builder.combineArtifacts;
        this.restrictions = builder.restrictions;
        this.timeoutInMins = builder.timeoutInMins;
        this.batchReportMode = builder.batchReportMode;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final Boolean combineArtifacts() {
        return this.combineArtifacts;
    }

    public final BatchRestrictions restrictions() {
        return this.restrictions;
    }

    public final Integer timeoutInMins() {
        return this.timeoutInMins;
    }

    public final BatchReportModeType batchReportMode() {
        return BatchReportModeType.fromValue(this.batchReportMode);
    }

    public final String batchReportModeAsString() {
        return this.batchReportMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.combineArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMins());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchReportModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectBuildBatchConfig)) {
            return false;
        }
        ProjectBuildBatchConfig other = (ProjectBuildBatchConfig)obj;
        return Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.combineArtifacts(), other.combineArtifacts()) && Objects.equals(this.restrictions(), other.restrictions()) && Objects.equals(this.timeoutInMins(), other.timeoutInMins()) && Objects.equals(this.batchReportModeAsString(), other.batchReportModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectBuildBatchConfig").add("ServiceRole", (Object)this.serviceRole()).add("CombineArtifacts", (Object)this.combineArtifacts()).add("Restrictions", (Object)this.restrictions()).add("TimeoutInMins", (Object)this.timeoutInMins()).add("BatchReportMode", (Object)this.batchReportModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "combineArtifacts": {
                return Optional.ofNullable(clazz.cast(this.combineArtifacts()));
            }
            case "restrictions": {
                return Optional.ofNullable(clazz.cast(this.restrictions()));
            }
            case "timeoutInMins": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMins()));
            }
            case "batchReportMode": {
                return Optional.ofNullable(clazz.cast(this.batchReportModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceRole", SERVICE_ROLE_FIELD);
        map.put("combineArtifacts", COMBINE_ARTIFACTS_FIELD);
        map.put("restrictions", RESTRICTIONS_FIELD);
        map.put("timeoutInMins", TIMEOUT_IN_MINS_FIELD);
        map.put("batchReportMode", BATCH_REPORT_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectBuildBatchConfig, T> g) {
        return obj -> g.apply((ProjectBuildBatchConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceRole;
        private Boolean combineArtifacts;
        private BatchRestrictions restrictions;
        private Integer timeoutInMins;
        private String batchReportMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectBuildBatchConfig model) {
            this.serviceRole(model.serviceRole);
            this.combineArtifacts(model.combineArtifacts);
            this.restrictions(model.restrictions);
            this.timeoutInMins(model.timeoutInMins);
            this.batchReportMode(model.batchReportMode);
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final Boolean getCombineArtifacts() {
            return this.combineArtifacts;
        }

        public final void setCombineArtifacts(Boolean combineArtifacts) {
            this.combineArtifacts = combineArtifacts;
        }

        @Override
        public final Builder combineArtifacts(Boolean combineArtifacts) {
            this.combineArtifacts = combineArtifacts;
            return this;
        }

        public final BatchRestrictions.Builder getRestrictions() {
            return this.restrictions != null ? this.restrictions.toBuilder() : null;
        }

        public final void setRestrictions(BatchRestrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(BatchRestrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final Integer getTimeoutInMins() {
            return this.timeoutInMins;
        }

        public final void setTimeoutInMins(Integer timeoutInMins) {
            this.timeoutInMins = timeoutInMins;
        }

        @Override
        public final Builder timeoutInMins(Integer timeoutInMins) {
            this.timeoutInMins = timeoutInMins;
            return this;
        }

        public final String getBatchReportMode() {
            return this.batchReportMode;
        }

        public final void setBatchReportMode(String batchReportMode) {
            this.batchReportMode = batchReportMode;
        }

        @Override
        public final Builder batchReportMode(String batchReportMode) {
            this.batchReportMode = batchReportMode;
            return this;
        }

        @Override
        public final Builder batchReportMode(BatchReportModeType batchReportMode) {
            this.batchReportMode(batchReportMode == null ? null : batchReportMode.toString());
            return this;
        }

        public ProjectBuildBatchConfig build() {
            return new ProjectBuildBatchConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectBuildBatchConfig> {
        public Builder serviceRole(String var1);

        public Builder combineArtifacts(Boolean var1);

        public Builder restrictions(BatchRestrictions var1);

        default public Builder restrictions(Consumer<BatchRestrictions.Builder> restrictions) {
            return this.restrictions((BatchRestrictions)((BatchRestrictions.Builder)BatchRestrictions.builder().applyMutation(restrictions)).build());
        }

        public Builder timeoutInMins(Integer var1);

        public Builder batchReportMode(String var1);

        public Builder batchReportMode(BatchReportModeType var1);
    }
}

