/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.BuildArtifacts;
import software.amazon.awssdk.services.codebuild.model.BuildArtifactsListCopier;
import software.amazon.awssdk.services.codebuild.model.BuildBatchPhase;
import software.amazon.awssdk.services.codebuild.model.BuildBatchPhasesCopier;
import software.amazon.awssdk.services.codebuild.model.BuildGroup;
import software.amazon.awssdk.services.codebuild.model.BuildGroupsCopier;
import software.amazon.awssdk.services.codebuild.model.LogsConfig;
import software.amazon.awssdk.services.codebuild.model.ProjectBuildBatchConfig;
import software.amazon.awssdk.services.codebuild.model.ProjectCache;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation;
import software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocationsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSecondarySourceVersionsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion;
import software.amazon.awssdk.services.codebuild.model.ProjectSourcesCopier;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.services.codebuild.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BuildBatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BuildBatch> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(BuildBatch.getter(BuildBatch::id)).setter(BuildBatch.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(BuildBatch.getter(BuildBatch::arn)).setter(BuildBatch.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(BuildBatch.getter(BuildBatch::startTime)).setter(BuildBatch.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(BuildBatch.getter(BuildBatch::endTime)).setter(BuildBatch.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> CURRENT_PHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentPhase").getter(BuildBatch.getter(BuildBatch::currentPhase)).setter(BuildBatch.setter(Builder::currentPhase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPhase").build()}).build();
    private static final SdkField<String> BUILD_BATCH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildBatchStatus").getter(BuildBatch.getter(BuildBatch::buildBatchStatusAsString)).setter(BuildBatch.setter(Builder::buildBatchStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatchStatus").build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVersion").getter(BuildBatch.getter(BuildBatch::sourceVersion)).setter(BuildBatch.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final SdkField<String> RESOLVED_SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolvedSourceVersion").getter(BuildBatch.getter(BuildBatch::resolvedSourceVersion)).setter(BuildBatch.setter(Builder::resolvedSourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedSourceVersion").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(BuildBatch.getter(BuildBatch::projectName)).setter(BuildBatch.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<List<BuildBatchPhase>> PHASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("phases").getter(BuildBatch.getter(BuildBatch::phases)).setter(BuildBatch.setter(Builder::phases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildBatchPhase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(BuildBatch.getter(BuildBatch::source)).setter(BuildBatch.setter(Builder::source)).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySources").getter(BuildBatch.getter(BuildBatch::secondarySources)).setter(BuildBatch.setter(Builder::secondarySources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySourceVersions").getter(BuildBatch.getter(BuildBatch::secondarySourceVersions)).setter(BuildBatch.setter(Builder::secondarySourceVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourceVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSourceVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BuildArtifacts> ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("artifacts").getter(BuildBatch.getter(BuildBatch::artifacts)).setter(BuildBatch.setter(Builder::artifacts)).constructor(BuildArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build()}).build();
    private static final SdkField<List<BuildArtifacts>> SECONDARY_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondaryArtifacts").getter(BuildBatch.getter(BuildBatch::secondaryArtifacts)).setter(BuildBatch.setter(Builder::secondaryArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectCache> CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cache").getter(BuildBatch.getter(BuildBatch::cache)).setter(BuildBatch.setter(Builder::cache)).constructor(ProjectCache::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cache").build()}).build();
    private static final SdkField<ProjectEnvironment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environment").getter(BuildBatch.getter(BuildBatch::environment)).setter(BuildBatch.setter(Builder::environment)).constructor(ProjectEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(BuildBatch.getter(BuildBatch::serviceRole)).setter(BuildBatch.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<LogsConfig> LOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfig").getter(BuildBatch.getter(BuildBatch::logConfig)).setter(BuildBatch.setter(Builder::logConfig)).constructor(LogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()}).build();
    private static final SdkField<Integer> BUILD_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("buildTimeoutInMinutes").getter(BuildBatch.getter(BuildBatch::buildTimeoutInMinutes)).setter(BuildBatch.setter(Builder::buildTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildTimeoutInMinutes").build()}).build();
    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queuedTimeoutInMinutes").getter(BuildBatch.getter(BuildBatch::queuedTimeoutInMinutes)).setter(BuildBatch.setter(Builder::queuedTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutes").build()}).build();
    private static final SdkField<Boolean> COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("complete").getter(BuildBatch.getter(BuildBatch::complete)).setter(BuildBatch.setter(Builder::complete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complete").build()}).build();
    private static final SdkField<String> INITIATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initiator").getter(BuildBatch.getter(BuildBatch::initiator)).setter(BuildBatch.setter(Builder::initiator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initiator").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(BuildBatch.getter(BuildBatch::vpcConfig)).setter(BuildBatch.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKey").getter(BuildBatch.getter(BuildBatch::encryptionKey)).setter(BuildBatch.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<Long> BUILD_BATCH_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("buildBatchNumber").getter(BuildBatch.getter(BuildBatch::buildBatchNumber)).setter(BuildBatch.setter(Builder::buildBatchNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatchNumber").build()}).build();
    private static final SdkField<List<ProjectFileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fileSystemLocations").getter(BuildBatch.getter(BuildBatch::fileSystemLocations)).setter(BuildBatch.setter(Builder::fileSystemLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectFileSystemLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectBuildBatchConfig> BUILD_BATCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("buildBatchConfig").getter(BuildBatch.getter(BuildBatch::buildBatchConfig)).setter(BuildBatch.setter(Builder::buildBatchConfig)).constructor(ProjectBuildBatchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatchConfig").build()}).build();
    private static final SdkField<List<BuildGroup>> BUILD_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buildGroups").getter(BuildBatch.getter(BuildBatch::buildGroups)).setter(BuildBatch.setter(Builder::buildGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BuildGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DEBUG_SESSION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("debugSessionEnabled").getter(BuildBatch.getter(BuildBatch::debugSessionEnabled)).setter(BuildBatch.setter(Builder::debugSessionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("debugSessionEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, CURRENT_PHASE_FIELD, BUILD_BATCH_STATUS_FIELD, SOURCE_VERSION_FIELD, RESOLVED_SOURCE_VERSION_FIELD, PROJECT_NAME_FIELD, PHASES_FIELD, SOURCE_FIELD, SECONDARY_SOURCES_FIELD, SECONDARY_SOURCE_VERSIONS_FIELD, ARTIFACTS_FIELD, SECONDARY_ARTIFACTS_FIELD, CACHE_FIELD, ENVIRONMENT_FIELD, SERVICE_ROLE_FIELD, LOG_CONFIG_FIELD, BUILD_TIMEOUT_IN_MINUTES_FIELD, QUEUED_TIMEOUT_IN_MINUTES_FIELD, COMPLETE_FIELD, INITIATOR_FIELD, VPC_CONFIG_FIELD, ENCRYPTION_KEY_FIELD, BUILD_BATCH_NUMBER_FIELD, FILE_SYSTEM_LOCATIONS_FIELD, BUILD_BATCH_CONFIG_FIELD, BUILD_GROUPS_FIELD, DEBUG_SESSION_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BuildBatch.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final Instant startTime;
    private final Instant endTime;
    private final String currentPhase;
    private final String buildBatchStatus;
    private final String sourceVersion;
    private final String resolvedSourceVersion;
    private final String projectName;
    private final List<BuildBatchPhase> phases;
    private final ProjectSource source;
    private final List<ProjectSource> secondarySources;
    private final List<ProjectSourceVersion> secondarySourceVersions;
    private final BuildArtifacts artifacts;
    private final List<BuildArtifacts> secondaryArtifacts;
    private final ProjectCache cache;
    private final ProjectEnvironment environment;
    private final String serviceRole;
    private final LogsConfig logConfig;
    private final Integer buildTimeoutInMinutes;
    private final Integer queuedTimeoutInMinutes;
    private final Boolean complete;
    private final String initiator;
    private final VpcConfig vpcConfig;
    private final String encryptionKey;
    private final Long buildBatchNumber;
    private final List<ProjectFileSystemLocation> fileSystemLocations;
    private final ProjectBuildBatchConfig buildBatchConfig;
    private final List<BuildGroup> buildGroups;
    private final Boolean debugSessionEnabled;

    private BuildBatch(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.currentPhase = builder.currentPhase;
        this.buildBatchStatus = builder.buildBatchStatus;
        this.sourceVersion = builder.sourceVersion;
        this.resolvedSourceVersion = builder.resolvedSourceVersion;
        this.projectName = builder.projectName;
        this.phases = builder.phases;
        this.source = builder.source;
        this.secondarySources = builder.secondarySources;
        this.secondarySourceVersions = builder.secondarySourceVersions;
        this.artifacts = builder.artifacts;
        this.secondaryArtifacts = builder.secondaryArtifacts;
        this.cache = builder.cache;
        this.environment = builder.environment;
        this.serviceRole = builder.serviceRole;
        this.logConfig = builder.logConfig;
        this.buildTimeoutInMinutes = builder.buildTimeoutInMinutes;
        this.queuedTimeoutInMinutes = builder.queuedTimeoutInMinutes;
        this.complete = builder.complete;
        this.initiator = builder.initiator;
        this.vpcConfig = builder.vpcConfig;
        this.encryptionKey = builder.encryptionKey;
        this.buildBatchNumber = builder.buildBatchNumber;
        this.fileSystemLocations = builder.fileSystemLocations;
        this.buildBatchConfig = builder.buildBatchConfig;
        this.buildGroups = builder.buildGroups;
        this.debugSessionEnabled = builder.debugSessionEnabled;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String currentPhase() {
        return this.currentPhase;
    }

    public final StatusType buildBatchStatus() {
        return StatusType.fromValue(this.buildBatchStatus);
    }

    public final String buildBatchStatusAsString() {
        return this.buildBatchStatus;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final String resolvedSourceVersion() {
        return this.resolvedSourceVersion;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final boolean hasPhases() {
        return this.phases != null && !(this.phases instanceof SdkAutoConstructList);
    }

    public final List<BuildBatchPhase> phases() {
        return this.phases;
    }

    public final ProjectSource source() {
        return this.source;
    }

    public final boolean hasSecondarySources() {
        return this.secondarySources != null && !(this.secondarySources instanceof SdkAutoConstructList);
    }

    public final List<ProjectSource> secondarySources() {
        return this.secondarySources;
    }

    public final boolean hasSecondarySourceVersions() {
        return this.secondarySourceVersions != null && !(this.secondarySourceVersions instanceof SdkAutoConstructList);
    }

    public final List<ProjectSourceVersion> secondarySourceVersions() {
        return this.secondarySourceVersions;
    }

    public final BuildArtifacts artifacts() {
        return this.artifacts;
    }

    public final boolean hasSecondaryArtifacts() {
        return this.secondaryArtifacts != null && !(this.secondaryArtifacts instanceof SdkAutoConstructList);
    }

    public final List<BuildArtifacts> secondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public final ProjectCache cache() {
        return this.cache;
    }

    public final ProjectEnvironment environment() {
        return this.environment;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final LogsConfig logConfig() {
        return this.logConfig;
    }

    public final Integer buildTimeoutInMinutes() {
        return this.buildTimeoutInMinutes;
    }

    public final Integer queuedTimeoutInMinutes() {
        return this.queuedTimeoutInMinutes;
    }

    public final Boolean complete() {
        return this.complete;
    }

    public final String initiator() {
        return this.initiator;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final Long buildBatchNumber() {
        return this.buildBatchNumber;
    }

    public final boolean hasFileSystemLocations() {
        return this.fileSystemLocations != null && !(this.fileSystemLocations instanceof SdkAutoConstructList);
    }

    public final List<ProjectFileSystemLocation> fileSystemLocations() {
        return this.fileSystemLocations;
    }

    public final ProjectBuildBatchConfig buildBatchConfig() {
        return this.buildBatchConfig;
    }

    public final boolean hasBuildGroups() {
        return this.buildGroups != null && !(this.buildGroups instanceof SdkAutoConstructList);
    }

    public final List<BuildGroup> buildGroups() {
        return this.buildGroups;
    }

    public final Boolean debugSessionEnabled() {
        return this.debugSessionEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPhase());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildBatchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedSourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhases() ? this.phases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySources() ? this.secondarySources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySourceVersions() ? this.secondarySourceVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryArtifacts() ? this.secondaryArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cache());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.complete());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiator());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildBatchNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemLocations() ? this.fileSystemLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.buildBatchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuildGroups() ? this.buildGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.debugSessionEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildBatch)) {
            return false;
        }
        BuildBatch other = (BuildBatch)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.currentPhase(), other.currentPhase()) && Objects.equals(this.buildBatchStatusAsString(), other.buildBatchStatusAsString()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.resolvedSourceVersion(), other.resolvedSourceVersion()) && Objects.equals(this.projectName(), other.projectName()) && this.hasPhases() == other.hasPhases() && Objects.equals(this.phases(), other.phases()) && Objects.equals(this.source(), other.source()) && this.hasSecondarySources() == other.hasSecondarySources() && Objects.equals(this.secondarySources(), other.secondarySources()) && this.hasSecondarySourceVersions() == other.hasSecondarySourceVersions() && Objects.equals(this.secondarySourceVersions(), other.secondarySourceVersions()) && Objects.equals(this.artifacts(), other.artifacts()) && this.hasSecondaryArtifacts() == other.hasSecondaryArtifacts() && Objects.equals(this.secondaryArtifacts(), other.secondaryArtifacts()) && Objects.equals(this.cache(), other.cache()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.logConfig(), other.logConfig()) && Objects.equals(this.buildTimeoutInMinutes(), other.buildTimeoutInMinutes()) && Objects.equals(this.queuedTimeoutInMinutes(), other.queuedTimeoutInMinutes()) && Objects.equals(this.complete(), other.complete()) && Objects.equals(this.initiator(), other.initiator()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.buildBatchNumber(), other.buildBatchNumber()) && this.hasFileSystemLocations() == other.hasFileSystemLocations() && Objects.equals(this.fileSystemLocations(), other.fileSystemLocations()) && Objects.equals(this.buildBatchConfig(), other.buildBatchConfig()) && this.hasBuildGroups() == other.hasBuildGroups() && Objects.equals(this.buildGroups(), other.buildGroups()) && Objects.equals(this.debugSessionEnabled(), other.debugSessionEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"BuildBatch").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("CurrentPhase", (Object)this.currentPhase()).add("BuildBatchStatus", (Object)this.buildBatchStatusAsString()).add("SourceVersion", (Object)this.sourceVersion()).add("ResolvedSourceVersion", (Object)this.resolvedSourceVersion()).add("ProjectName", (Object)this.projectName()).add("Phases", this.hasPhases() ? this.phases() : null).add("Source", (Object)this.source()).add("SecondarySources", this.hasSecondarySources() ? this.secondarySources() : null).add("SecondarySourceVersions", this.hasSecondarySourceVersions() ? this.secondarySourceVersions() : null).add("Artifacts", (Object)this.artifacts()).add("SecondaryArtifacts", this.hasSecondaryArtifacts() ? this.secondaryArtifacts() : null).add("Cache", (Object)this.cache()).add("Environment", (Object)this.environment()).add("ServiceRole", (Object)this.serviceRole()).add("LogConfig", (Object)this.logConfig()).add("BuildTimeoutInMinutes", (Object)this.buildTimeoutInMinutes()).add("QueuedTimeoutInMinutes", (Object)this.queuedTimeoutInMinutes()).add("Complete", (Object)this.complete()).add("Initiator", (Object)this.initiator()).add("VpcConfig", (Object)this.vpcConfig()).add("EncryptionKey", (Object)this.encryptionKey()).add("BuildBatchNumber", (Object)this.buildBatchNumber()).add("FileSystemLocations", this.hasFileSystemLocations() ? this.fileSystemLocations() : null).add("BuildBatchConfig", (Object)this.buildBatchConfig()).add("BuildGroups", this.hasBuildGroups() ? this.buildGroups() : null).add("DebugSessionEnabled", (Object)this.debugSessionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "currentPhase": {
                return Optional.ofNullable(clazz.cast(this.currentPhase()));
            }
            case "buildBatchStatus": {
                return Optional.ofNullable(clazz.cast(this.buildBatchStatusAsString()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "resolvedSourceVersion": {
                return Optional.ofNullable(clazz.cast(this.resolvedSourceVersion()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "phases": {
                return Optional.ofNullable(clazz.cast(this.phases()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "secondarySources": {
                return Optional.ofNullable(clazz.cast(this.secondarySources()));
            }
            case "secondarySourceVersions": {
                return Optional.ofNullable(clazz.cast(this.secondarySourceVersions()));
            }
            case "artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
            case "secondaryArtifacts": {
                return Optional.ofNullable(clazz.cast(this.secondaryArtifacts()));
            }
            case "cache": {
                return Optional.ofNullable(clazz.cast(this.cache()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "logConfig": {
                return Optional.ofNullable(clazz.cast(this.logConfig()));
            }
            case "buildTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.buildTimeoutInMinutes()));
            }
            case "queuedTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.queuedTimeoutInMinutes()));
            }
            case "complete": {
                return Optional.ofNullable(clazz.cast(this.complete()));
            }
            case "initiator": {
                return Optional.ofNullable(clazz.cast(this.initiator()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "buildBatchNumber": {
                return Optional.ofNullable(clazz.cast(this.buildBatchNumber()));
            }
            case "fileSystemLocations": {
                return Optional.ofNullable(clazz.cast(this.fileSystemLocations()));
            }
            case "buildBatchConfig": {
                return Optional.ofNullable(clazz.cast(this.buildBatchConfig()));
            }
            case "buildGroups": {
                return Optional.ofNullable(clazz.cast(this.buildGroups()));
            }
            case "debugSessionEnabled": {
                return Optional.ofNullable(clazz.cast(this.debugSessionEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("currentPhase", CURRENT_PHASE_FIELD);
        map.put("buildBatchStatus", BUILD_BATCH_STATUS_FIELD);
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        map.put("resolvedSourceVersion", RESOLVED_SOURCE_VERSION_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("phases", PHASES_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("secondarySources", SECONDARY_SOURCES_FIELD);
        map.put("secondarySourceVersions", SECONDARY_SOURCE_VERSIONS_FIELD);
        map.put("artifacts", ARTIFACTS_FIELD);
        map.put("secondaryArtifacts", SECONDARY_ARTIFACTS_FIELD);
        map.put("cache", CACHE_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("serviceRole", SERVICE_ROLE_FIELD);
        map.put("logConfig", LOG_CONFIG_FIELD);
        map.put("buildTimeoutInMinutes", BUILD_TIMEOUT_IN_MINUTES_FIELD);
        map.put("queuedTimeoutInMinutes", QUEUED_TIMEOUT_IN_MINUTES_FIELD);
        map.put("complete", COMPLETE_FIELD);
        map.put("initiator", INITIATOR_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("encryptionKey", ENCRYPTION_KEY_FIELD);
        map.put("buildBatchNumber", BUILD_BATCH_NUMBER_FIELD);
        map.put("fileSystemLocations", FILE_SYSTEM_LOCATIONS_FIELD);
        map.put("buildBatchConfig", BUILD_BATCH_CONFIG_FIELD);
        map.put("buildGroups", BUILD_GROUPS_FIELD);
        map.put("debugSessionEnabled", DEBUG_SESSION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BuildBatch, T> g) {
        return obj -> g.apply((BuildBatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private Instant startTime;
        private Instant endTime;
        private String currentPhase;
        private String buildBatchStatus;
        private String sourceVersion;
        private String resolvedSourceVersion;
        private String projectName;
        private List<BuildBatchPhase> phases = DefaultSdkAutoConstructList.getInstance();
        private ProjectSource source;
        private List<ProjectSource> secondarySources = DefaultSdkAutoConstructList.getInstance();
        private List<ProjectSourceVersion> secondarySourceVersions = DefaultSdkAutoConstructList.getInstance();
        private BuildArtifacts artifacts;
        private List<BuildArtifacts> secondaryArtifacts = DefaultSdkAutoConstructList.getInstance();
        private ProjectCache cache;
        private ProjectEnvironment environment;
        private String serviceRole;
        private LogsConfig logConfig;
        private Integer buildTimeoutInMinutes;
        private Integer queuedTimeoutInMinutes;
        private Boolean complete;
        private String initiator;
        private VpcConfig vpcConfig;
        private String encryptionKey;
        private Long buildBatchNumber;
        private List<ProjectFileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();
        private ProjectBuildBatchConfig buildBatchConfig;
        private List<BuildGroup> buildGroups = DefaultSdkAutoConstructList.getInstance();
        private Boolean debugSessionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildBatch model) {
            this.id(model.id);
            this.arn(model.arn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.currentPhase(model.currentPhase);
            this.buildBatchStatus(model.buildBatchStatus);
            this.sourceVersion(model.sourceVersion);
            this.resolvedSourceVersion(model.resolvedSourceVersion);
            this.projectName(model.projectName);
            this.phases(model.phases);
            this.source(model.source);
            this.secondarySources(model.secondarySources);
            this.secondarySourceVersions(model.secondarySourceVersions);
            this.artifacts(model.artifacts);
            this.secondaryArtifacts(model.secondaryArtifacts);
            this.cache(model.cache);
            this.environment(model.environment);
            this.serviceRole(model.serviceRole);
            this.logConfig(model.logConfig);
            this.buildTimeoutInMinutes(model.buildTimeoutInMinutes);
            this.queuedTimeoutInMinutes(model.queuedTimeoutInMinutes);
            this.complete(model.complete);
            this.initiator(model.initiator);
            this.vpcConfig(model.vpcConfig);
            this.encryptionKey(model.encryptionKey);
            this.buildBatchNumber(model.buildBatchNumber);
            this.fileSystemLocations(model.fileSystemLocations);
            this.buildBatchConfig(model.buildBatchConfig);
            this.buildGroups(model.buildGroups);
            this.debugSessionEnabled(model.debugSessionEnabled);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getCurrentPhase() {
            return this.currentPhase;
        }

        public final void setCurrentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
        }

        @Override
        public final Builder currentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
            return this;
        }

        public final String getBuildBatchStatus() {
            return this.buildBatchStatus;
        }

        public final void setBuildBatchStatus(String buildBatchStatus) {
            this.buildBatchStatus = buildBatchStatus;
        }

        @Override
        public final Builder buildBatchStatus(String buildBatchStatus) {
            this.buildBatchStatus = buildBatchStatus;
            return this;
        }

        @Override
        public final Builder buildBatchStatus(StatusType buildBatchStatus) {
            this.buildBatchStatus(buildBatchStatus == null ? null : buildBatchStatus.toString());
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final String getResolvedSourceVersion() {
            return this.resolvedSourceVersion;
        }

        public final void setResolvedSourceVersion(String resolvedSourceVersion) {
            this.resolvedSourceVersion = resolvedSourceVersion;
        }

        @Override
        public final Builder resolvedSourceVersion(String resolvedSourceVersion) {
            this.resolvedSourceVersion = resolvedSourceVersion;
            return this;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final List<BuildBatchPhase.Builder> getPhases() {
            List<BuildBatchPhase.Builder> result = BuildBatchPhasesCopier.copyToBuilder(this.phases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhases(Collection<BuildBatchPhase.BuilderImpl> phases) {
            this.phases = BuildBatchPhasesCopier.copyFromBuilder(phases);
        }

        @Override
        public final Builder phases(Collection<BuildBatchPhase> phases) {
            this.phases = BuildBatchPhasesCopier.copy(phases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(BuildBatchPhase ... phases) {
            this.phases(Arrays.asList(phases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(Consumer<BuildBatchPhase.Builder> ... phases) {
            this.phases(Stream.of(phases).map(c -> (BuildBatchPhase)((BuildBatchPhase.Builder)BuildBatchPhase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final List<ProjectSource.Builder> getSecondarySources() {
            List<ProjectSource.Builder> result = ProjectSourcesCopier.copyToBuilder(this.secondarySources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySources(Collection<ProjectSource.BuilderImpl> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copyFromBuilder(secondarySources);
        }

        @Override
        public final Builder secondarySources(Collection<ProjectSource> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copy(secondarySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(ProjectSource ... secondarySources) {
            this.secondarySources(Arrays.asList(secondarySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(Consumer<ProjectSource.Builder> ... secondarySources) {
            this.secondarySources(Stream.of(secondarySources).map(c -> (ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProjectSourceVersion.Builder> getSecondarySourceVersions() {
            List<ProjectSourceVersion.Builder> result = ProjectSecondarySourceVersionsCopier.copyToBuilder(this.secondarySourceVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourceVersions(Collection<ProjectSourceVersion.BuilderImpl> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourceVersions);
        }

        @Override
        public final Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copy(secondarySourceVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(ProjectSourceVersion ... secondarySourceVersions) {
            this.secondarySourceVersions(Arrays.asList(secondarySourceVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... secondarySourceVersions) {
            this.secondarySourceVersions(Stream.of(secondarySourceVersions).map(c -> (ProjectSourceVersion)((ProjectSourceVersion.Builder)ProjectSourceVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BuildArtifacts.Builder getArtifacts() {
            return this.artifacts != null ? this.artifacts.toBuilder() : null;
        }

        public final void setArtifacts(BuildArtifacts.BuilderImpl artifacts) {
            this.artifacts = artifacts != null ? artifacts.build() : null;
        }

        @Override
        public final Builder artifacts(BuildArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final List<BuildArtifacts.Builder> getSecondaryArtifacts() {
            List<BuildArtifacts.Builder> result = BuildArtifactsListCopier.copyToBuilder(this.secondaryArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryArtifacts(Collection<BuildArtifacts.BuilderImpl> secondaryArtifacts) {
            this.secondaryArtifacts = BuildArtifactsListCopier.copyFromBuilder(secondaryArtifacts);
        }

        @Override
        public final Builder secondaryArtifacts(Collection<BuildArtifacts> secondaryArtifacts) {
            this.secondaryArtifacts = BuildArtifactsListCopier.copy(secondaryArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(BuildArtifacts ... secondaryArtifacts) {
            this.secondaryArtifacts(Arrays.asList(secondaryArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(Consumer<BuildArtifacts.Builder> ... secondaryArtifacts) {
            this.secondaryArtifacts(Stream.of(secondaryArtifacts).map(c -> (BuildArtifacts)((BuildArtifacts.Builder)BuildArtifacts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectCache.Builder getCache() {
            return this.cache != null ? this.cache.toBuilder() : null;
        }

        public final void setCache(ProjectCache.BuilderImpl cache) {
            this.cache = cache != null ? cache.build() : null;
        }

        @Override
        public final Builder cache(ProjectCache cache) {
            this.cache = cache;
            return this;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final LogsConfig.Builder getLogConfig() {
            return this.logConfig != null ? this.logConfig.toBuilder() : null;
        }

        public final void setLogConfig(LogsConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(LogsConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final Integer getBuildTimeoutInMinutes() {
            return this.buildTimeoutInMinutes;
        }

        public final void setBuildTimeoutInMinutes(Integer buildTimeoutInMinutes) {
            this.buildTimeoutInMinutes = buildTimeoutInMinutes;
        }

        @Override
        public final Builder buildTimeoutInMinutes(Integer buildTimeoutInMinutes) {
            this.buildTimeoutInMinutes = buildTimeoutInMinutes;
            return this;
        }

        public final Integer getQueuedTimeoutInMinutes() {
            return this.queuedTimeoutInMinutes;
        }

        public final void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
        }

        @Override
        public final Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
            return this;
        }

        public final Boolean getComplete() {
            return this.complete;
        }

        public final void setComplete(Boolean complete) {
            this.complete = complete;
        }

        @Override
        public final Builder complete(Boolean complete) {
            this.complete = complete;
            return this;
        }

        public final String getInitiator() {
            return this.initiator;
        }

        public final void setInitiator(String initiator) {
            this.initiator = initiator;
        }

        @Override
        public final Builder initiator(String initiator) {
            this.initiator = initiator;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final Long getBuildBatchNumber() {
            return this.buildBatchNumber;
        }

        public final void setBuildBatchNumber(Long buildBatchNumber) {
            this.buildBatchNumber = buildBatchNumber;
        }

        @Override
        public final Builder buildBatchNumber(Long buildBatchNumber) {
            this.buildBatchNumber = buildBatchNumber;
            return this;
        }

        public final List<ProjectFileSystemLocation.Builder> getFileSystemLocations() {
            List<ProjectFileSystemLocation.Builder> result = ProjectFileSystemLocationsCopier.copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<ProjectFileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        public final Builder fileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(ProjectFileSystemLocation ... fileSystemLocations) {
            this.fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder> ... fileSystemLocations) {
            this.fileSystemLocations(Stream.of(fileSystemLocations).map(c -> (ProjectFileSystemLocation)((ProjectFileSystemLocation.Builder)ProjectFileSystemLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectBuildBatchConfig.Builder getBuildBatchConfig() {
            return this.buildBatchConfig != null ? this.buildBatchConfig.toBuilder() : null;
        }

        public final void setBuildBatchConfig(ProjectBuildBatchConfig.BuilderImpl buildBatchConfig) {
            this.buildBatchConfig = buildBatchConfig != null ? buildBatchConfig.build() : null;
        }

        @Override
        public final Builder buildBatchConfig(ProjectBuildBatchConfig buildBatchConfig) {
            this.buildBatchConfig = buildBatchConfig;
            return this;
        }

        public final List<BuildGroup.Builder> getBuildGroups() {
            List<BuildGroup.Builder> result = BuildGroupsCopier.copyToBuilder(this.buildGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuildGroups(Collection<BuildGroup.BuilderImpl> buildGroups) {
            this.buildGroups = BuildGroupsCopier.copyFromBuilder(buildGroups);
        }

        @Override
        public final Builder buildGroups(Collection<BuildGroup> buildGroups) {
            this.buildGroups = BuildGroupsCopier.copy(buildGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildGroups(BuildGroup ... buildGroups) {
            this.buildGroups(Arrays.asList(buildGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildGroups(Consumer<BuildGroup.Builder> ... buildGroups) {
            this.buildGroups(Stream.of(buildGroups).map(c -> (BuildGroup)((BuildGroup.Builder)BuildGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDebugSessionEnabled() {
            return this.debugSessionEnabled;
        }

        public final void setDebugSessionEnabled(Boolean debugSessionEnabled) {
            this.debugSessionEnabled = debugSessionEnabled;
        }

        @Override
        public final Builder debugSessionEnabled(Boolean debugSessionEnabled) {
            this.debugSessionEnabled = debugSessionEnabled;
            return this;
        }

        public BuildBatch build() {
            return new BuildBatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BuildBatch> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder currentPhase(String var1);

        public Builder buildBatchStatus(String var1);

        public Builder buildBatchStatus(StatusType var1);

        public Builder sourceVersion(String var1);

        public Builder resolvedSourceVersion(String var1);

        public Builder projectName(String var1);

        public Builder phases(Collection<BuildBatchPhase> var1);

        public Builder phases(BuildBatchPhase ... var1);

        public Builder phases(Consumer<BuildBatchPhase.Builder> ... var1);

        public Builder source(ProjectSource var1);

        default public Builder source(Consumer<ProjectSource.Builder> source) {
            return this.source((ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation(source)).build());
        }

        public Builder secondarySources(Collection<ProjectSource> var1);

        public Builder secondarySources(ProjectSource ... var1);

        public Builder secondarySources(Consumer<ProjectSource.Builder> ... var1);

        public Builder secondarySourceVersions(Collection<ProjectSourceVersion> var1);

        public Builder secondarySourceVersions(ProjectSourceVersion ... var1);

        public Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... var1);

        public Builder artifacts(BuildArtifacts var1);

        default public Builder artifacts(Consumer<BuildArtifacts.Builder> artifacts) {
            return this.artifacts((BuildArtifacts)((BuildArtifacts.Builder)BuildArtifacts.builder().applyMutation(artifacts)).build());
        }

        public Builder secondaryArtifacts(Collection<BuildArtifacts> var1);

        public Builder secondaryArtifacts(BuildArtifacts ... var1);

        public Builder secondaryArtifacts(Consumer<BuildArtifacts.Builder> ... var1);

        public Builder cache(ProjectCache var1);

        default public Builder cache(Consumer<ProjectCache.Builder> cache) {
            return this.cache((ProjectCache)((ProjectCache.Builder)ProjectCache.builder().applyMutation(cache)).build());
        }

        public Builder environment(ProjectEnvironment var1);

        default public Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return this.environment((ProjectEnvironment)((ProjectEnvironment.Builder)ProjectEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder serviceRole(String var1);

        public Builder logConfig(LogsConfig var1);

        default public Builder logConfig(Consumer<LogsConfig.Builder> logConfig) {
            return this.logConfig((LogsConfig)((LogsConfig.Builder)LogsConfig.builder().applyMutation(logConfig)).build());
        }

        public Builder buildTimeoutInMinutes(Integer var1);

        public Builder queuedTimeoutInMinutes(Integer var1);

        public Builder complete(Boolean var1);

        public Builder initiator(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder encryptionKey(String var1);

        public Builder buildBatchNumber(Long var1);

        public Builder fileSystemLocations(Collection<ProjectFileSystemLocation> var1);

        public Builder fileSystemLocations(ProjectFileSystemLocation ... var1);

        public Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder> ... var1);

        public Builder buildBatchConfig(ProjectBuildBatchConfig var1);

        default public Builder buildBatchConfig(Consumer<ProjectBuildBatchConfig.Builder> buildBatchConfig) {
            return this.buildBatchConfig((ProjectBuildBatchConfig)((ProjectBuildBatchConfig.Builder)ProjectBuildBatchConfig.builder().applyMutation(buildBatchConfig)).build());
        }

        public Builder buildGroups(Collection<BuildGroup> var1);

        public Builder buildGroups(BuildGroup ... var1);

        public Builder buildGroups(Consumer<BuildGroup.Builder> ... var1);

        public Builder debugSessionEnabled(Boolean var1);
    }
}

