/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.FilterGroupsCopier;
import software.amazon.awssdk.services.codebuild.model.ScopeConfiguration;
import software.amazon.awssdk.services.codebuild.model.WebhookBuildType;
import software.amazon.awssdk.services.codebuild.model.WebhookFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Webhook
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Webhook> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(Webhook.getter(Webhook::url)).setter(Webhook.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<String> PAYLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("payloadUrl").getter(Webhook.getter(Webhook::payloadUrl)).setter(Webhook.setter(Builder::payloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadUrl").build()}).build();
    private static final SdkField<String> SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secret").getter(Webhook.getter(Webhook::secret)).setter(Webhook.setter(Builder::secret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secret").build()}).build();
    private static final SdkField<String> BRANCH_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("branchFilter").getter(Webhook.getter(Webhook::branchFilter)).setter(Webhook.setter(Builder::branchFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchFilter").build()}).build();
    private static final SdkField<List<List<WebhookFilter>>> FILTER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filterGroups").getter(Webhook.getter(Webhook::filterGroups)).setter(Webhook.setter(Builder::filterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WebhookFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> BUILD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildType").getter(Webhook.getter(Webhook::buildTypeAsString)).setter(Webhook.setter(Builder::buildType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildType").build()}).build();
    private static final SdkField<Boolean> MANUAL_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("manualCreation").getter(Webhook.getter(Webhook::manualCreation)).setter(Webhook.setter(Builder::manualCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manualCreation").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedSecret").getter(Webhook.getter(Webhook::lastModifiedSecret)).setter(Webhook.setter(Builder::lastModifiedSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedSecret").build()}).build();
    private static final SdkField<ScopeConfiguration> SCOPE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scopeConfiguration").getter(Webhook.getter(Webhook::scopeConfiguration)).setter(Webhook.setter(Builder::scopeConfiguration)).constructor(ScopeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, PAYLOAD_URL_FIELD, SECRET_FIELD, BRANCH_FILTER_FIELD, FILTER_GROUPS_FIELD, BUILD_TYPE_FIELD, MANUAL_CREATION_FIELD, LAST_MODIFIED_SECRET_FIELD, SCOPE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Webhook.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String url;
    private final String payloadUrl;
    private final String secret;
    private final String branchFilter;
    private final List<List<WebhookFilter>> filterGroups;
    private final String buildType;
    private final Boolean manualCreation;
    private final Instant lastModifiedSecret;
    private final ScopeConfiguration scopeConfiguration;

    private Webhook(BuilderImpl builder) {
        this.url = builder.url;
        this.payloadUrl = builder.payloadUrl;
        this.secret = builder.secret;
        this.branchFilter = builder.branchFilter;
        this.filterGroups = builder.filterGroups;
        this.buildType = builder.buildType;
        this.manualCreation = builder.manualCreation;
        this.lastModifiedSecret = builder.lastModifiedSecret;
        this.scopeConfiguration = builder.scopeConfiguration;
    }

    public final String url() {
        return this.url;
    }

    public final String payloadUrl() {
        return this.payloadUrl;
    }

    public final String secret() {
        return this.secret;
    }

    public final String branchFilter() {
        return this.branchFilter;
    }

    public final boolean hasFilterGroups() {
        return this.filterGroups != null && !(this.filterGroups instanceof SdkAutoConstructList);
    }

    public final List<List<WebhookFilter>> filterGroups() {
        return this.filterGroups;
    }

    public final WebhookBuildType buildType() {
        return WebhookBuildType.fromValue(this.buildType);
    }

    public final String buildTypeAsString() {
        return this.buildType;
    }

    public final Boolean manualCreation() {
        return this.manualCreation;
    }

    public final Instant lastModifiedSecret() {
        return this.lastModifiedSecret;
    }

    public final ScopeConfiguration scopeConfiguration() {
        return this.scopeConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.secret());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterGroups() ? this.filterGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.buildTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manualCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Webhook)) {
            return false;
        }
        Webhook other = (Webhook)obj;
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.payloadUrl(), other.payloadUrl()) && Objects.equals(this.secret(), other.secret()) && Objects.equals(this.branchFilter(), other.branchFilter()) && this.hasFilterGroups() == other.hasFilterGroups() && Objects.equals(this.filterGroups(), other.filterGroups()) && Objects.equals(this.buildTypeAsString(), other.buildTypeAsString()) && Objects.equals(this.manualCreation(), other.manualCreation()) && Objects.equals(this.lastModifiedSecret(), other.lastModifiedSecret()) && Objects.equals(this.scopeConfiguration(), other.scopeConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Webhook").add("Url", (Object)this.url()).add("PayloadUrl", (Object)this.payloadUrl()).add("Secret", (Object)this.secret()).add("BranchFilter", (Object)this.branchFilter()).add("FilterGroups", this.hasFilterGroups() ? this.filterGroups() : null).add("BuildType", (Object)this.buildTypeAsString()).add("ManualCreation", (Object)this.manualCreation()).add("LastModifiedSecret", (Object)this.lastModifiedSecret()).add("ScopeConfiguration", (Object)this.scopeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "payloadUrl": {
                return Optional.ofNullable(clazz.cast(this.payloadUrl()));
            }
            case "secret": {
                return Optional.ofNullable(clazz.cast(this.secret()));
            }
            case "branchFilter": {
                return Optional.ofNullable(clazz.cast(this.branchFilter()));
            }
            case "filterGroups": {
                return Optional.ofNullable(clazz.cast(this.filterGroups()));
            }
            case "buildType": {
                return Optional.ofNullable(clazz.cast(this.buildTypeAsString()));
            }
            case "manualCreation": {
                return Optional.ofNullable(clazz.cast(this.manualCreation()));
            }
            case "lastModifiedSecret": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedSecret()));
            }
            case "scopeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scopeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url", URL_FIELD);
        map.put("payloadUrl", PAYLOAD_URL_FIELD);
        map.put("secret", SECRET_FIELD);
        map.put("branchFilter", BRANCH_FILTER_FIELD);
        map.put("filterGroups", FILTER_GROUPS_FIELD);
        map.put("buildType", BUILD_TYPE_FIELD);
        map.put("manualCreation", MANUAL_CREATION_FIELD);
        map.put("lastModifiedSecret", LAST_MODIFIED_SECRET_FIELD);
        map.put("scopeConfiguration", SCOPE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Webhook, T> g) {
        return obj -> g.apply((Webhook)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String url;
        private String payloadUrl;
        private String secret;
        private String branchFilter;
        private List<List<WebhookFilter>> filterGroups = DefaultSdkAutoConstructList.getInstance();
        private String buildType;
        private Boolean manualCreation;
        private Instant lastModifiedSecret;
        private ScopeConfiguration scopeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Webhook model) {
            this.url(model.url);
            this.payloadUrl(model.payloadUrl);
            this.secret(model.secret);
            this.branchFilter(model.branchFilter);
            this.filterGroups(model.filterGroups);
            this.buildType(model.buildType);
            this.manualCreation(model.manualCreation);
            this.lastModifiedSecret(model.lastModifiedSecret);
            this.scopeConfiguration(model.scopeConfiguration);
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getPayloadUrl() {
            return this.payloadUrl;
        }

        public final void setPayloadUrl(String payloadUrl) {
            this.payloadUrl = payloadUrl;
        }

        @Override
        public final Builder payloadUrl(String payloadUrl) {
            this.payloadUrl = payloadUrl;
            return this;
        }

        public final String getSecret() {
            return this.secret;
        }

        public final void setSecret(String secret) {
            this.secret = secret;
        }

        @Override
        public final Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public final String getBranchFilter() {
            return this.branchFilter;
        }

        public final void setBranchFilter(String branchFilter) {
            this.branchFilter = branchFilter;
        }

        @Override
        public final Builder branchFilter(String branchFilter) {
            this.branchFilter = branchFilter;
            return this;
        }

        public final List<List<WebhookFilter.Builder>> getFilterGroups() {
            List<List<WebhookFilter.Builder>> result = FilterGroupsCopier.copyToBuilder(this.filterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterGroups(Collection<? extends Collection<WebhookFilter.BuilderImpl>> filterGroups) {
            this.filterGroups = FilterGroupsCopier.copyFromBuilder(filterGroups);
        }

        @Override
        public final Builder filterGroups(Collection<? extends Collection<WebhookFilter>> filterGroups) {
            this.filterGroups = FilterGroupsCopier.copy(filterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterGroups(Collection<WebhookFilter> ... filterGroups) {
            this.filterGroups((Collection<? extends Collection<WebhookFilter>>)Arrays.asList(filterGroups));
            return this;
        }

        public final String getBuildType() {
            return this.buildType;
        }

        public final void setBuildType(String buildType) {
            this.buildType = buildType;
        }

        @Override
        public final Builder buildType(String buildType) {
            this.buildType = buildType;
            return this;
        }

        @Override
        public final Builder buildType(WebhookBuildType buildType) {
            this.buildType(buildType == null ? null : buildType.toString());
            return this;
        }

        public final Boolean getManualCreation() {
            return this.manualCreation;
        }

        public final void setManualCreation(Boolean manualCreation) {
            this.manualCreation = manualCreation;
        }

        @Override
        public final Builder manualCreation(Boolean manualCreation) {
            this.manualCreation = manualCreation;
            return this;
        }

        public final Instant getLastModifiedSecret() {
            return this.lastModifiedSecret;
        }

        public final void setLastModifiedSecret(Instant lastModifiedSecret) {
            this.lastModifiedSecret = lastModifiedSecret;
        }

        @Override
        public final Builder lastModifiedSecret(Instant lastModifiedSecret) {
            this.lastModifiedSecret = lastModifiedSecret;
            return this;
        }

        public final ScopeConfiguration.Builder getScopeConfiguration() {
            return this.scopeConfiguration != null ? this.scopeConfiguration.toBuilder() : null;
        }

        public final void setScopeConfiguration(ScopeConfiguration.BuilderImpl scopeConfiguration) {
            this.scopeConfiguration = scopeConfiguration != null ? scopeConfiguration.build() : null;
        }

        @Override
        public final Builder scopeConfiguration(ScopeConfiguration scopeConfiguration) {
            this.scopeConfiguration = scopeConfiguration;
            return this;
        }

        public Webhook build() {
            return new Webhook(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Webhook> {
        public Builder url(String var1);

        public Builder payloadUrl(String var1);

        public Builder secret(String var1);

        public Builder branchFilter(String var1);

        public Builder filterGroups(Collection<? extends Collection<WebhookFilter>> var1);

        public Builder filterGroups(Collection<WebhookFilter> ... var1);

        public Builder buildType(String var1);

        public Builder buildType(WebhookBuildType var1);

        public Builder manualCreation(Boolean var1);

        public Builder lastModifiedSecret(Instant var1);

        public Builder scopeConfiguration(ScopeConfiguration var1);

        default public Builder scopeConfiguration(Consumer<ScopeConfiguration.Builder> scopeConfiguration) {
            return this.scopeConfiguration((ScopeConfiguration)((ScopeConfiguration.Builder)ScopeConfiguration.builder().applyMutation(scopeConfiguration)).build());
        }
    }
}

