/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WebhookScopeType {
    GITHUB_ORGANIZATION("GITHUB_ORGANIZATION"),
    GITHUB_GLOBAL("GITHUB_GLOBAL"),
    GITLAB_GROUP("GITLAB_GROUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WebhookScopeType> VALUE_MAP;
    private final String value;

    private WebhookScopeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WebhookScopeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WebhookScopeType> knownValues() {
        EnumSet<WebhookScopeType> knownValues = EnumSet.allOf(WebhookScopeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WebhookScopeType.class, WebhookScopeType::toString);
    }
}

