/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.BuildStatusConfig;
import software.amazon.awssdk.services.codebuild.model.GitSubmodulesConfig;
import software.amazon.awssdk.services.codebuild.model.SourceAuth;
import software.amazon.awssdk.services.codebuild.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectSource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ProjectSource.getter(ProjectSource::typeAsString)).setter(ProjectSource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(ProjectSource.getter(ProjectSource::location)).setter(ProjectSource.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<Integer> GIT_CLONE_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("gitCloneDepth").getter(ProjectSource.getter(ProjectSource::gitCloneDepth)).setter(ProjectSource.setter(Builder::gitCloneDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitCloneDepth").build()}).build();
    private static final SdkField<GitSubmodulesConfig> GIT_SUBMODULES_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("gitSubmodulesConfig").getter(ProjectSource.getter(ProjectSource::gitSubmodulesConfig)).setter(ProjectSource.setter(Builder::gitSubmodulesConfig)).constructor(GitSubmodulesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitSubmodulesConfig").build()}).build();
    private static final SdkField<String> BUILDSPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildspec").getter(ProjectSource.getter(ProjectSource::buildspec)).setter(ProjectSource.setter(Builder::buildspec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildspec").build()}).build();
    private static final SdkField<SourceAuth> AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("auth").getter(ProjectSource.getter(ProjectSource::auth)).setter(ProjectSource.setter(Builder::auth)).constructor(SourceAuth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auth").build()}).build();
    private static final SdkField<Boolean> REPORT_BUILD_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("reportBuildStatus").getter(ProjectSource.getter(ProjectSource::reportBuildStatus)).setter(ProjectSource.setter(Builder::reportBuildStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportBuildStatus").build()}).build();
    private static final SdkField<BuildStatusConfig> BUILD_STATUS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("buildStatusConfig").getter(ProjectSource.getter(ProjectSource::buildStatusConfig)).setter(ProjectSource.setter(Builder::buildStatusConfig)).constructor(BuildStatusConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildStatusConfig").build()}).build();
    private static final SdkField<Boolean> INSECURE_SSL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("insecureSsl").getter(ProjectSource.getter(ProjectSource::insecureSsl)).setter(ProjectSource.setter(Builder::insecureSsl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insecureSsl").build()}).build();
    private static final SdkField<String> SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceIdentifier").getter(ProjectSource.getter(ProjectSource::sourceIdentifier)).setter(ProjectSource.setter(Builder::sourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LOCATION_FIELD, GIT_CLONE_DEPTH_FIELD, GIT_SUBMODULES_CONFIG_FIELD, BUILDSPEC_FIELD, AUTH_FIELD, REPORT_BUILD_STATUS_FIELD, BUILD_STATUS_CONFIG_FIELD, INSECURE_SSL_FIELD, SOURCE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("type", TYPE_FIELD);
            this.put("location", LOCATION_FIELD);
            this.put("gitCloneDepth", GIT_CLONE_DEPTH_FIELD);
            this.put("gitSubmodulesConfig", GIT_SUBMODULES_CONFIG_FIELD);
            this.put("buildspec", BUILDSPEC_FIELD);
            this.put("auth", AUTH_FIELD);
            this.put("reportBuildStatus", REPORT_BUILD_STATUS_FIELD);
            this.put("buildStatusConfig", BUILD_STATUS_CONFIG_FIELD);
            this.put("insecureSsl", INSECURE_SSL_FIELD);
            this.put("sourceIdentifier", SOURCE_IDENTIFIER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String location;
    private final Integer gitCloneDepth;
    private final GitSubmodulesConfig gitSubmodulesConfig;
    private final String buildspec;
    private final SourceAuth auth;
    private final Boolean reportBuildStatus;
    private final BuildStatusConfig buildStatusConfig;
    private final Boolean insecureSsl;
    private final String sourceIdentifier;

    private ProjectSource(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.gitCloneDepth = builder.gitCloneDepth;
        this.gitSubmodulesConfig = builder.gitSubmodulesConfig;
        this.buildspec = builder.buildspec;
        this.auth = builder.auth;
        this.reportBuildStatus = builder.reportBuildStatus;
        this.buildStatusConfig = builder.buildStatusConfig;
        this.insecureSsl = builder.insecureSsl;
        this.sourceIdentifier = builder.sourceIdentifier;
    }

    public final SourceType type() {
        return SourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String location() {
        return this.location;
    }

    public final Integer gitCloneDepth() {
        return this.gitCloneDepth;
    }

    public final GitSubmodulesConfig gitSubmodulesConfig() {
        return this.gitSubmodulesConfig;
    }

    public final String buildspec() {
        return this.buildspec;
    }

    public final SourceAuth auth() {
        return this.auth;
    }

    public final Boolean reportBuildStatus() {
        return this.reportBuildStatus;
    }

    public final BuildStatusConfig buildStatusConfig() {
        return this.buildStatusConfig;
    }

    public final Boolean insecureSsl() {
        return this.insecureSsl;
    }

    public final String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitCloneDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitSubmodulesConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildspec());
        hashCode = 31 * hashCode + Objects.hashCode(this.auth());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportBuildStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildStatusConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.insecureSsl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectSource)) {
            return false;
        }
        ProjectSource other = (ProjectSource)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.gitCloneDepth(), other.gitCloneDepth()) && Objects.equals(this.gitSubmodulesConfig(), other.gitSubmodulesConfig()) && Objects.equals(this.buildspec(), other.buildspec()) && Objects.equals(this.auth(), other.auth()) && Objects.equals(this.reportBuildStatus(), other.reportBuildStatus()) && Objects.equals(this.buildStatusConfig(), other.buildStatusConfig()) && Objects.equals(this.insecureSsl(), other.insecureSsl()) && Objects.equals(this.sourceIdentifier(), other.sourceIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ProjectSource").add("Type", (Object)this.typeAsString()).add("Location", (Object)this.location()).add("GitCloneDepth", (Object)this.gitCloneDepth()).add("GitSubmodulesConfig", (Object)this.gitSubmodulesConfig()).add("Buildspec", (Object)this.buildspec()).add("Auth", (Object)this.auth()).add("ReportBuildStatus", (Object)this.reportBuildStatus()).add("BuildStatusConfig", (Object)this.buildStatusConfig()).add("InsecureSsl", (Object)this.insecureSsl()).add("SourceIdentifier", (Object)this.sourceIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "gitCloneDepth": {
                return Optional.ofNullable(clazz.cast(this.gitCloneDepth()));
            }
            case "gitSubmodulesConfig": {
                return Optional.ofNullable(clazz.cast(this.gitSubmodulesConfig()));
            }
            case "buildspec": {
                return Optional.ofNullable(clazz.cast(this.buildspec()));
            }
            case "auth": {
                return Optional.ofNullable(clazz.cast(this.auth()));
            }
            case "reportBuildStatus": {
                return Optional.ofNullable(clazz.cast(this.reportBuildStatus()));
            }
            case "buildStatusConfig": {
                return Optional.ofNullable(clazz.cast(this.buildStatusConfig()));
            }
            case "insecureSsl": {
                return Optional.ofNullable(clazz.cast(this.insecureSsl()));
            }
            case "sourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProjectSource, T> g) {
        return obj -> g.apply((ProjectSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private Integer gitCloneDepth;
        private GitSubmodulesConfig gitSubmodulesConfig;
        private String buildspec;
        private SourceAuth auth;
        private Boolean reportBuildStatus;
        private BuildStatusConfig buildStatusConfig;
        private Boolean insecureSsl;
        private String sourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectSource model) {
            this.type(model.type);
            this.location(model.location);
            this.gitCloneDepth(model.gitCloneDepth);
            this.gitSubmodulesConfig(model.gitSubmodulesConfig);
            this.buildspec(model.buildspec);
            this.auth(model.auth);
            this.reportBuildStatus(model.reportBuildStatus);
            this.buildStatusConfig(model.buildStatusConfig);
            this.insecureSsl(model.insecureSsl);
            this.sourceIdentifier(model.sourceIdentifier);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final Integer getGitCloneDepth() {
            return this.gitCloneDepth;
        }

        public final void setGitCloneDepth(Integer gitCloneDepth) {
            this.gitCloneDepth = gitCloneDepth;
        }

        @Override
        public final Builder gitCloneDepth(Integer gitCloneDepth) {
            this.gitCloneDepth = gitCloneDepth;
            return this;
        }

        public final GitSubmodulesConfig.Builder getGitSubmodulesConfig() {
            return this.gitSubmodulesConfig != null ? this.gitSubmodulesConfig.toBuilder() : null;
        }

        public final void setGitSubmodulesConfig(GitSubmodulesConfig.BuilderImpl gitSubmodulesConfig) {
            this.gitSubmodulesConfig = gitSubmodulesConfig != null ? gitSubmodulesConfig.build() : null;
        }

        @Override
        public final Builder gitSubmodulesConfig(GitSubmodulesConfig gitSubmodulesConfig) {
            this.gitSubmodulesConfig = gitSubmodulesConfig;
            return this;
        }

        public final String getBuildspec() {
            return this.buildspec;
        }

        public final void setBuildspec(String buildspec) {
            this.buildspec = buildspec;
        }

        @Override
        public final Builder buildspec(String buildspec) {
            this.buildspec = buildspec;
            return this;
        }

        public final SourceAuth.Builder getAuth() {
            return this.auth != null ? this.auth.toBuilder() : null;
        }

        public final void setAuth(SourceAuth.BuilderImpl auth) {
            this.auth = auth != null ? auth.build() : null;
        }

        @Override
        public final Builder auth(SourceAuth auth) {
            this.auth = auth;
            return this;
        }

        public final Boolean getReportBuildStatus() {
            return this.reportBuildStatus;
        }

        public final void setReportBuildStatus(Boolean reportBuildStatus) {
            this.reportBuildStatus = reportBuildStatus;
        }

        @Override
        public final Builder reportBuildStatus(Boolean reportBuildStatus) {
            this.reportBuildStatus = reportBuildStatus;
            return this;
        }

        public final BuildStatusConfig.Builder getBuildStatusConfig() {
            return this.buildStatusConfig != null ? this.buildStatusConfig.toBuilder() : null;
        }

        public final void setBuildStatusConfig(BuildStatusConfig.BuilderImpl buildStatusConfig) {
            this.buildStatusConfig = buildStatusConfig != null ? buildStatusConfig.build() : null;
        }

        @Override
        public final Builder buildStatusConfig(BuildStatusConfig buildStatusConfig) {
            this.buildStatusConfig = buildStatusConfig;
            return this;
        }

        public final Boolean getInsecureSsl() {
            return this.insecureSsl;
        }

        public final void setInsecureSsl(Boolean insecureSsl) {
            this.insecureSsl = insecureSsl;
        }

        @Override
        public final Builder insecureSsl(Boolean insecureSsl) {
            this.insecureSsl = insecureSsl;
            return this;
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public ProjectSource build() {
            return new ProjectSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectSource> {
        public Builder type(String var1);

        public Builder type(SourceType var1);

        public Builder location(String var1);

        public Builder gitCloneDepth(Integer var1);

        public Builder gitSubmodulesConfig(GitSubmodulesConfig var1);

        default public Builder gitSubmodulesConfig(Consumer<GitSubmodulesConfig.Builder> gitSubmodulesConfig) {
            return this.gitSubmodulesConfig((GitSubmodulesConfig)((GitSubmodulesConfig.Builder)GitSubmodulesConfig.builder().applyMutation(gitSubmodulesConfig)).build());
        }

        public Builder buildspec(String var1);

        public Builder auth(SourceAuth var1);

        default public Builder auth(Consumer<SourceAuth.Builder> auth) {
            return this.auth((SourceAuth)((SourceAuth.Builder)SourceAuth.builder().applyMutation(auth)).build());
        }

        public Builder reportBuildStatus(Boolean var1);

        public Builder buildStatusConfig(BuildStatusConfig var1);

        default public Builder buildStatusConfig(Consumer<BuildStatusConfig.Builder> buildStatusConfig) {
            return this.buildStatusConfig((BuildStatusConfig)((BuildStatusConfig.Builder)BuildStatusConfig.builder().applyMutation(buildStatusConfig)).build());
        }

        public Builder insecureSsl(Boolean var1);

        public Builder sourceIdentifier(String var1);
    }
}

