/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.WebhookScopeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScopeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScopeConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ScopeConfiguration.getter(ScopeConfiguration::name)).setter(ScopeConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(ScopeConfiguration.getter(ScopeConfiguration::domain)).setter(ScopeConfiguration.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scope").getter(ScopeConfiguration.getter(ScopeConfiguration::scopeAsString)).setter(ScopeConfiguration.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOMAIN_FIELD, SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("domain", DOMAIN_FIELD);
            this.put("scope", SCOPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String domain;
    private final String scope;

    private ScopeConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.domain = builder.domain;
        this.scope = builder.scope;
    }

    public final String name() {
        return this.name;
    }

    public final String domain() {
        return this.domain;
    }

    public final WebhookScopeType scope() {
        return WebhookScopeType.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScopeConfiguration)) {
            return false;
        }
        ScopeConfiguration other = (ScopeConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.scopeAsString(), other.scopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScopeConfiguration").add("Name", (Object)this.name()).add("Domain", (Object)this.domain()).add("Scope", (Object)this.scopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScopeConfiguration, T> g) {
        return obj -> g.apply((ScopeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String domain;
        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ScopeConfiguration model) {
            this.name(model.name);
            this.domain(model.domain);
            this.scope(model.scope);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(WebhookScopeType scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public ScopeConfiguration build() {
            return new ScopeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScopeConfiguration> {
        public Builder name(String var1);

        public Builder domain(String var1);

        public Builder scope(String var1);

        public Builder scope(WebhookScopeType var1);
    }
}

