/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ReportGroupArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetReportGroupsRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, BatchGetReportGroupsRequest> {
    private static final SdkField<List<String>> REPORT_GROUP_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reportGroupArns").getter(BatchGetReportGroupsRequest.getter(BatchGetReportGroupsRequest::reportGroupArns)).setter(BatchGetReportGroupsRequest.setter(Builder::reportGroupArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportGroupArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_GROUP_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("reportGroupArns", REPORT_GROUP_ARNS_FIELD);
        }
    });
    private final List<String> reportGroupArns;

    private BatchGetReportGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.reportGroupArns = builder.reportGroupArns;
    }

    public final boolean hasReportGroupArns() {
        return this.reportGroupArns != null && !(this.reportGroupArns instanceof SdkAutoConstructList);
    }

    public final List<String> reportGroupArns() {
        return this.reportGroupArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportGroupArns() ? this.reportGroupArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetReportGroupsRequest)) {
            return false;
        }
        BatchGetReportGroupsRequest other = (BatchGetReportGroupsRequest)((Object)obj);
        return this.hasReportGroupArns() == other.hasReportGroupArns() && Objects.equals(this.reportGroupArns(), other.reportGroupArns());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetReportGroupsRequest").add("ReportGroupArns", this.hasReportGroupArns() ? this.reportGroupArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportGroupArns": {
                return Optional.ofNullable(clazz.cast(this.reportGroupArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetReportGroupsRequest, T> g) {
        return obj -> g.apply((BatchGetReportGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private List<String> reportGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetReportGroupsRequest model) {
            super(model);
            this.reportGroupArns(model.reportGroupArns);
        }

        public final Collection<String> getReportGroupArns() {
            if (this.reportGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reportGroupArns;
        }

        public final void setReportGroupArns(Collection<String> reportGroupArns) {
            this.reportGroupArns = ReportGroupArnsCopier.copy(reportGroupArns);
        }

        @Override
        public final Builder reportGroupArns(Collection<String> reportGroupArns) {
            this.reportGroupArns = ReportGroupArnsCopier.copy(reportGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportGroupArns(String ... reportGroupArns) {
            this.reportGroupArns(Arrays.asList(reportGroupArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetReportGroupsRequest build() {
            return new BatchGetReportGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetReportGroupsRequest> {
        public Builder reportGroupArns(Collection<String> var1);

        public Builder reportGroupArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

