/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.FleetProxyRuleEffectType;
import software.amazon.awssdk.services.codebuild.model.FleetProxyRuleEntitiesCopier;
import software.amazon.awssdk.services.codebuild.model.FleetProxyRuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetProxyRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetProxyRule> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FleetProxyRule.getter(FleetProxyRule::typeAsString)).setter(FleetProxyRule.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("effect").getter(FleetProxyRule.getter(FleetProxyRule::effectAsString)).setter(FleetProxyRule.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effect").build()}).build();
    private static final SdkField<List<String>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entities").getter(FleetProxyRule.getter(FleetProxyRule::entities)).setter(FleetProxyRule.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, EFFECT_FIELD, ENTITIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String effect;
    private final List<String> entities;

    private FleetProxyRule(BuilderImpl builder) {
        this.type = builder.type;
        this.effect = builder.effect;
        this.entities = builder.entities;
    }

    public final FleetProxyRuleType type() {
        return FleetProxyRuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final FleetProxyRuleEffectType effect() {
        return FleetProxyRuleEffectType.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<String> entities() {
        return this.entities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetProxyRule)) {
            return false;
        }
        FleetProxyRule other = (FleetProxyRule)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.effectAsString(), other.effectAsString()) && this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities());
    }

    public final String toString() {
        return ToString.builder((String)"FleetProxyRule").add("Type", (Object)this.typeAsString()).add("Effect", (Object)this.effectAsString()).add("Entities", this.hasEntities() ? this.entities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetProxyRule, T> g) {
        return obj -> g.apply((FleetProxyRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String effect;
        private List<String> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetProxyRule model) {
            this.type(model.type);
            this.effect(model.effect);
            this.entities(model.entities);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetProxyRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getEffect() {
            return this.effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(FleetProxyRuleEffectType effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final Collection<String> getEntities() {
            if (this.entities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entities;
        }

        public final void setEntities(Collection<String> entities) {
            this.entities = FleetProxyRuleEntitiesCopier.copy(entities);
        }

        @Override
        public final Builder entities(Collection<String> entities) {
            this.entities = FleetProxyRuleEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(String ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        public FleetProxyRule build() {
            return new FleetProxyRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetProxyRule> {
        public Builder type(String var1);

        public Builder type(FleetProxyRuleType var1);

        public Builder effect(String var1);

        public Builder effect(FleetProxyRuleEffectType var1);

        public Builder entities(Collection<String> var1);

        public Builder entities(String ... var1);
    }
}

