/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ComputeType;
import software.amazon.awssdk.services.codebuild.model.EnvironmentType;
import software.amazon.awssdk.services.codebuild.model.FleetOverflowBehavior;
import software.amazon.awssdk.services.codebuild.model.ScalingConfigurationInput;
import software.amazon.awssdk.services.codebuild.model.Tag;
import software.amazon.awssdk.services.codebuild.model.TagListCopier;
import software.amazon.awssdk.services.codebuild.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFleetRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, UpdateFleetRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateFleetRequest.getter(UpdateFleetRequest::arn)).setter(UpdateFleetRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Integer> BASE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("baseCapacity").getter(UpdateFleetRequest.getter(UpdateFleetRequest::baseCapacity)).setter(UpdateFleetRequest.setter(Builder::baseCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCapacity").build()}).build();
    private static final SdkField<String> ENVIRONMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentType").getter(UpdateFleetRequest.getter(UpdateFleetRequest::environmentTypeAsString)).setter(UpdateFleetRequest.setter(Builder::environmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentType").build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeType").getter(UpdateFleetRequest.getter(UpdateFleetRequest::computeTypeAsString)).setter(UpdateFleetRequest.setter(Builder::computeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeType").build()}).build();
    private static final SdkField<ScalingConfigurationInput> SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scalingConfiguration").getter(UpdateFleetRequest.getter(UpdateFleetRequest::scalingConfiguration)).setter(UpdateFleetRequest.setter(Builder::scalingConfiguration)).constructor(ScalingConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingConfiguration").build()}).build();
    private static final SdkField<String> OVERFLOW_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overflowBehavior").getter(UpdateFleetRequest.getter(UpdateFleetRequest::overflowBehaviorAsString)).setter(UpdateFleetRequest.setter(Builder::overflowBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overflowBehavior").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(UpdateFleetRequest.getter(UpdateFleetRequest::vpcConfig)).setter(UpdateFleetRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageId").getter(UpdateFleetRequest.getter(UpdateFleetRequest::imageId)).setter(UpdateFleetRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<String> FLEET_SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetServiceRole").getter(UpdateFleetRequest.getter(UpdateFleetRequest::fleetServiceRole)).setter(UpdateFleetRequest.setter(Builder::fleetServiceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetServiceRole").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(UpdateFleetRequest.getter(UpdateFleetRequest::tags)).setter(UpdateFleetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, BASE_CAPACITY_FIELD, ENVIRONMENT_TYPE_FIELD, COMPUTE_TYPE_FIELD, SCALING_CONFIGURATION_FIELD, OVERFLOW_BEHAVIOR_FIELD, VPC_CONFIG_FIELD, IMAGE_ID_FIELD, FLEET_SERVICE_ROLE_FIELD, TAGS_FIELD));
    private final String arn;
    private final Integer baseCapacity;
    private final String environmentType;
    private final String computeType;
    private final ScalingConfigurationInput scalingConfiguration;
    private final String overflowBehavior;
    private final VpcConfig vpcConfig;
    private final String imageId;
    private final String fleetServiceRole;
    private final List<Tag> tags;

    private UpdateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.baseCapacity = builder.baseCapacity;
        this.environmentType = builder.environmentType;
        this.computeType = builder.computeType;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.overflowBehavior = builder.overflowBehavior;
        this.vpcConfig = builder.vpcConfig;
        this.imageId = builder.imageId;
        this.fleetServiceRole = builder.fleetServiceRole;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer baseCapacity() {
        return this.baseCapacity;
    }

    public final EnvironmentType environmentType() {
        return EnvironmentType.fromValue(this.environmentType);
    }

    public final String environmentTypeAsString() {
        return this.environmentType;
    }

    public final ComputeType computeType() {
        return ComputeType.fromValue(this.computeType);
    }

    public final String computeTypeAsString() {
        return this.computeType;
    }

    public final ScalingConfigurationInput scalingConfiguration() {
        return this.scalingConfiguration;
    }

    public final FleetOverflowBehavior overflowBehavior() {
        return FleetOverflowBehavior.fromValue(this.overflowBehavior);
    }

    public final String overflowBehaviorAsString() {
        return this.overflowBehavior;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String fleetServiceRole() {
        return this.fleetServiceRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.overflowBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetServiceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetRequest)) {
            return false;
        }
        UpdateFleetRequest other = (UpdateFleetRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.baseCapacity(), other.baseCapacity()) && Objects.equals(this.environmentTypeAsString(), other.environmentTypeAsString()) && Objects.equals(this.computeTypeAsString(), other.computeTypeAsString()) && Objects.equals(this.scalingConfiguration(), other.scalingConfiguration()) && Objects.equals(this.overflowBehaviorAsString(), other.overflowBehaviorAsString()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.fleetServiceRole(), other.fleetServiceRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFleetRequest").add("Arn", (Object)this.arn()).add("BaseCapacity", (Object)this.baseCapacity()).add("EnvironmentType", (Object)this.environmentTypeAsString()).add("ComputeType", (Object)this.computeTypeAsString()).add("ScalingConfiguration", (Object)this.scalingConfiguration()).add("OverflowBehavior", (Object)this.overflowBehaviorAsString()).add("VpcConfig", (Object)this.vpcConfig()).add("ImageId", (Object)this.imageId()).add("FleetServiceRole", (Object)this.fleetServiceRole()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "baseCapacity": {
                return Optional.ofNullable(clazz.cast(this.baseCapacity()));
            }
            case "environmentType": {
                return Optional.ofNullable(clazz.cast(this.environmentTypeAsString()));
            }
            case "computeType": {
                return Optional.ofNullable(clazz.cast(this.computeTypeAsString()));
            }
            case "scalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scalingConfiguration()));
            }
            case "overflowBehavior": {
                return Optional.ofNullable(clazz.cast(this.overflowBehaviorAsString()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "fleetServiceRole": {
                return Optional.ofNullable(clazz.cast(this.fleetServiceRole()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetRequest, T> g) {
        return obj -> g.apply((UpdateFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String arn;
        private Integer baseCapacity;
        private String environmentType;
        private String computeType;
        private ScalingConfigurationInput scalingConfiguration;
        private String overflowBehavior;
        private VpcConfig vpcConfig;
        private String imageId;
        private String fleetServiceRole;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetRequest model) {
            super(model);
            this.arn(model.arn);
            this.baseCapacity(model.baseCapacity);
            this.environmentType(model.environmentType);
            this.computeType(model.computeType);
            this.scalingConfiguration(model.scalingConfiguration);
            this.overflowBehavior(model.overflowBehavior);
            this.vpcConfig(model.vpcConfig);
            this.imageId(model.imageId);
            this.fleetServiceRole(model.fleetServiceRole);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getBaseCapacity() {
            return this.baseCapacity;
        }

        public final void setBaseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
        }

        @Override
        public final Builder baseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        public final String getEnvironmentType() {
            return this.environmentType;
        }

        public final void setEnvironmentType(String environmentType) {
            this.environmentType = environmentType;
        }

        @Override
        public final Builder environmentType(String environmentType) {
            this.environmentType = environmentType;
            return this;
        }

        @Override
        public final Builder environmentType(EnvironmentType environmentType) {
            this.environmentType(environmentType == null ? null : environmentType.toString());
            return this;
        }

        public final String getComputeType() {
            return this.computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final ScalingConfigurationInput.Builder getScalingConfiguration() {
            return this.scalingConfiguration != null ? this.scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfigurationInput.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfigurationInput scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final String getOverflowBehavior() {
            return this.overflowBehavior;
        }

        public final void setOverflowBehavior(String overflowBehavior) {
            this.overflowBehavior = overflowBehavior;
        }

        @Override
        public final Builder overflowBehavior(String overflowBehavior) {
            this.overflowBehavior = overflowBehavior;
            return this;
        }

        @Override
        public final Builder overflowBehavior(FleetOverflowBehavior overflowBehavior) {
            this.overflowBehavior(overflowBehavior == null ? null : overflowBehavior.toString());
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getFleetServiceRole() {
            return this.fleetServiceRole;
        }

        public final void setFleetServiceRole(String fleetServiceRole) {
            this.fleetServiceRole = fleetServiceRole;
        }

        @Override
        public final Builder fleetServiceRole(String fleetServiceRole) {
            this.fleetServiceRole = fleetServiceRole;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetRequest build() {
            return new UpdateFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFleetRequest> {
        public Builder arn(String var1);

        public Builder baseCapacity(Integer var1);

        public Builder environmentType(String var1);

        public Builder environmentType(EnvironmentType var1);

        public Builder computeType(String var1);

        public Builder computeType(ComputeType var1);

        public Builder scalingConfiguration(ScalingConfigurationInput var1);

        default public Builder scalingConfiguration(Consumer<ScalingConfigurationInput.Builder> scalingConfiguration) {
            return this.scalingConfiguration((ScalingConfigurationInput)((ScalingConfigurationInput.Builder)ScalingConfigurationInput.builder().applyMutation(scalingConfiguration)).build());
        }

        public Builder overflowBehavior(String var1);

        public Builder overflowBehavior(FleetOverflowBehavior var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder imageId(String var1);

        public Builder fleetServiceRole(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

