/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.ListSharedReportGroupsResponse;

public class ListSharedReportGroupsPublisher
implements SdkPublisher<ListSharedReportGroupsResponse> {
    private final CodeBuildAsyncClient client;
    private final ListSharedReportGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSharedReportGroupsPublisher(CodeBuildAsyncClient client, ListSharedReportGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSharedReportGroupsPublisher(CodeBuildAsyncClient client, ListSharedReportGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSharedReportGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSharedReportGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> reportGroups() {
        Function<ListSharedReportGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reportGroups() != null) {
                return response.reportGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSharedReportGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSharedReportGroupsResponseFetcher
    implements AsyncPageFetcher<ListSharedReportGroupsResponse> {
        private ListSharedReportGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListSharedReportGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSharedReportGroupsResponse> nextPage(ListSharedReportGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListSharedReportGroupsPublisher.this.client.listSharedReportGroups(ListSharedReportGroupsPublisher.this.firstRequest);
            }
            return ListSharedReportGroupsPublisher.this.client.listSharedReportGroups((ListSharedReportGroupsRequest)((Object)ListSharedReportGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

