/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CacheType {
    NO_CACHE("NO_CACHE"),
    S3("S3"),
    LOCAL("LOCAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CacheType> VALUE_MAP;
    private final String value;

    private CacheType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CacheType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CacheType> knownValues() {
        EnumSet<CacheType> knownValues = EnumSet.allOf(CacheType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CacheType.class, CacheType::toString);
    }
}

