/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.internal.UserAgentUtils;
import software.amazon.awssdk.services.codebuild.model.ListReportGroupsRequest;
import software.amazon.awssdk.services.codebuild.model.ListReportGroupsResponse;

public class ListReportGroupsPublisher
implements SdkPublisher<ListReportGroupsResponse> {
    private final CodeBuildAsyncClient client;
    private final ListReportGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReportGroupsPublisher(CodeBuildAsyncClient client, ListReportGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReportGroupsPublisher(CodeBuildAsyncClient client, ListReportGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReportGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReportGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> reportGroups() {
        Function<ListReportGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reportGroups() != null) {
                return response.reportGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReportGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReportGroupsResponseFetcher
    implements AsyncPageFetcher<ListReportGroupsResponse> {
        private ListReportGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListReportGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReportGroupsResponse> nextPage(ListReportGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListReportGroupsPublisher.this.client.listReportGroups(ListReportGroupsPublisher.this.firstRequest);
            }
            return ListReportGroupsPublisher.this.client.listReportGroups((ListReportGroupsRequest)((Object)ListReportGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

