/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.TestCase;
import software.amazon.awssdk.services.codebuild.model.TestCasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTestCasesResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, DescribeTestCasesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeTestCasesResponse.getter(DescribeTestCasesResponse::nextToken)).setter(DescribeTestCasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TestCase>> TEST_CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testCases").getter(DescribeTestCasesResponse.getter(DescribeTestCasesResponse::testCases)).setter(DescribeTestCasesResponse.setter(Builder::testCases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestCase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TEST_CASES_FIELD));
    private final String nextToken;
    private final List<TestCase> testCases;

    private DescribeTestCasesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.testCases = builder.testCases;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTestCases() {
        return this.testCases != null && !(this.testCases instanceof SdkAutoConstructList);
    }

    public final List<TestCase> testCases() {
        return this.testCases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestCases() ? this.testCases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTestCasesResponse)) {
            return false;
        }
        DescribeTestCasesResponse other = (DescribeTestCasesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTestCases() == other.hasTestCases() && Objects.equals(this.testCases(), other.testCases());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTestCasesResponse").add("NextToken", (Object)this.nextToken()).add("TestCases", this.hasTestCases() ? this.testCases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "testCases": {
                return Optional.ofNullable(clazz.cast(this.testCases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTestCasesResponse, T> g) {
        return obj -> g.apply((DescribeTestCasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TestCase> testCases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTestCasesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.testCases(model.testCases);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TestCase.Builder> getTestCases() {
            List<TestCase.Builder> result = TestCasesCopier.copyToBuilder(this.testCases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestCases(Collection<TestCase.BuilderImpl> testCases) {
            this.testCases = TestCasesCopier.copyFromBuilder(testCases);
        }

        @Override
        public final Builder testCases(Collection<TestCase> testCases) {
            this.testCases = TestCasesCopier.copy(testCases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCases(TestCase ... testCases) {
            this.testCases(Arrays.asList(testCases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCases(Consumer<TestCase.Builder> ... testCases) {
            this.testCases(Stream.of(testCases).map(c -> (TestCase)((TestCase.Builder)TestCase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTestCasesResponse build() {
            return new DescribeTestCasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTestCasesResponse> {
        public Builder nextToken(String var1);

        public Builder testCases(Collection<TestCase> var1);

        public Builder testCases(TestCase ... var1);

        public Builder testCases(Consumer<TestCase.Builder> ... var1);
    }
}

