/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClientBuilder;
import software.amazon.awssdk.services.codebuild.CodeBuildServiceClientConfiguration;
import software.amazon.awssdk.services.codebuild.DefaultCodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.DefaultCodeBuildBaseClientBuilder;
import software.amazon.awssdk.services.codebuild.endpoints.CodeBuildEndpointProvider;

@SdkInternalApi
final class DefaultCodeBuildAsyncClientBuilder
extends DefaultCodeBuildBaseClientBuilder<CodeBuildAsyncClientBuilder, CodeBuildAsyncClient>
implements CodeBuildAsyncClientBuilder {
    DefaultCodeBuildAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeBuildAsyncClientBuilder endpointProvider(CodeBuildEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeBuildAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeBuildAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodeBuildServiceClientConfiguration serviceClientConfiguration = CodeBuildServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodeBuildAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

