/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.RetryBuildBatchType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetryBuildBatchRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, RetryBuildBatchRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(RetryBuildBatchRequest.getter(RetryBuildBatchRequest::id)).setter(RetryBuildBatchRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idempotencyToken").getter(RetryBuildBatchRequest.getter(RetryBuildBatchRequest::idempotencyToken)).setter(RetryBuildBatchRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idempotencyToken").build()}).build();
    private static final SdkField<String> RETRY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retryType").getter(RetryBuildBatchRequest.getter(RetryBuildBatchRequest::retryTypeAsString)).setter(RetryBuildBatchRequest.setter(Builder::retryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IDEMPOTENCY_TOKEN_FIELD, RETRY_TYPE_FIELD));
    private final String id;
    private final String idempotencyToken;
    private final String retryType;

    private RetryBuildBatchRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.idempotencyToken = builder.idempotencyToken;
        this.retryType = builder.retryType;
    }

    public final String id() {
        return this.id;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final RetryBuildBatchType retryType() {
        return RetryBuildBatchType.fromValue(this.retryType);
    }

    public final String retryTypeAsString() {
        return this.retryType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryBuildBatchRequest)) {
            return false;
        }
        RetryBuildBatchRequest other = (RetryBuildBatchRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.retryTypeAsString(), other.retryTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RetryBuildBatchRequest").add("Id", (Object)this.id()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("RetryType", (Object)this.retryTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "idempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "retryType": {
                return Optional.ofNullable(clazz.cast(this.retryTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryBuildBatchRequest, T> g) {
        return obj -> g.apply((RetryBuildBatchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String id;
        private String idempotencyToken;
        private String retryType;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryBuildBatchRequest model) {
            super(model);
            this.id(model.id);
            this.idempotencyToken(model.idempotencyToken);
            this.retryType(model.retryType);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public final String getRetryType() {
            return this.retryType;
        }

        @Override
        public final Builder retryType(String retryType) {
            this.retryType = retryType;
            return this;
        }

        @Override
        public final Builder retryType(RetryBuildBatchType retryType) {
            this.retryType(retryType == null ? null : retryType.toString());
            return this;
        }

        public final void setRetryType(String retryType) {
            this.retryType = retryType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetryBuildBatchRequest build() {
            return new RetryBuildBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetryBuildBatchRequest> {
        public Builder id(String var1);

        public Builder idempotencyToken(String var1);

        public Builder retryType(String var1);

        public Builder retryType(RetryBuildBatchType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

