/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildClient;
import software.amazon.awssdk.services.codebuild.model.ListBuildsRequest;
import software.amazon.awssdk.services.codebuild.model.ListBuildsResponse;

public class ListBuildsIterable
implements SdkIterable<ListBuildsResponse> {
    private final CodeBuildClient client;
    private final ListBuildsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBuildsIterable(CodeBuildClient client, ListBuildsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBuildsResponseFetcher();
    }

    public Iterator<ListBuildsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> ids() {
        Function<ListBuildsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ids() != null) {
                return response.ids().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBuildsResponseFetcher
    implements SyncPageFetcher<ListBuildsResponse> {
        private ListBuildsResponseFetcher() {
        }

        public boolean hasNextPage(ListBuildsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBuildsResponse nextPage(ListBuildsResponse previousPage) {
            if (previousPage == null) {
                return ListBuildsIterable.this.client.listBuilds(ListBuildsIterable.this.firstRequest);
            }
            return ListBuildsIterable.this.client.listBuilds((ListBuildsRequest)((Object)ListBuildsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

