/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codebuild.model.ReportStatusCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestReportSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestReportSummary> {
    private static final SdkField<Integer> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("total").getter(TestReportSummary.getter(TestReportSummary::total)).setter(TestReportSummary.setter(Builder::total)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()}).build();
    private static final SdkField<Map<String, Integer>> STATUS_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("statusCounts").getter(TestReportSummary.getter(TestReportSummary::statusCounts)).setter(TestReportSummary.setter(Builder::statusCounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> DURATION_IN_NANO_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("durationInNanoSeconds").getter(TestReportSummary.getter(TestReportSummary::durationInNanoSeconds)).setter(TestReportSummary.setter(Builder::durationInNanoSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationInNanoSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FIELD, STATUS_COUNTS_FIELD, DURATION_IN_NANO_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer total;
    private final Map<String, Integer> statusCounts;
    private final Long durationInNanoSeconds;

    private TestReportSummary(BuilderImpl builder) {
        this.total = builder.total;
        this.statusCounts = builder.statusCounts;
        this.durationInNanoSeconds = builder.durationInNanoSeconds;
    }

    public final Integer total() {
        return this.total;
    }

    public final boolean hasStatusCounts() {
        return this.statusCounts != null && !(this.statusCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> statusCounts() {
        return this.statusCounts;
    }

    public final Long durationInNanoSeconds() {
        return this.durationInNanoSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusCounts() ? this.statusCounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInNanoSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestReportSummary)) {
            return false;
        }
        TestReportSummary other = (TestReportSummary)obj;
        return Objects.equals(this.total(), other.total()) && this.hasStatusCounts() == other.hasStatusCounts() && Objects.equals(this.statusCounts(), other.statusCounts()) && Objects.equals(this.durationInNanoSeconds(), other.durationInNanoSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"TestReportSummary").add("Total", (Object)this.total()).add("StatusCounts", this.hasStatusCounts() ? this.statusCounts() : null).add("DurationInNanoSeconds", (Object)this.durationInNanoSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "statusCounts": {
                return Optional.ofNullable(clazz.cast(this.statusCounts()));
            }
            case "durationInNanoSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInNanoSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestReportSummary, T> g) {
        return obj -> g.apply((TestReportSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer total;
        private Map<String, Integer> statusCounts = DefaultSdkAutoConstructMap.getInstance();
        private Long durationInNanoSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TestReportSummary model) {
            this.total(model.total);
            this.statusCounts(model.statusCounts);
            this.durationInNanoSeconds(model.durationInNanoSeconds);
        }

        public final Integer getTotal() {
            return this.total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        public final Map<String, Integer> getStatusCounts() {
            if (this.statusCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.statusCounts;
        }

        public final void setStatusCounts(Map<String, Integer> statusCounts) {
            this.statusCounts = ReportStatusCountsCopier.copy(statusCounts);
        }

        @Override
        public final Builder statusCounts(Map<String, Integer> statusCounts) {
            this.statusCounts = ReportStatusCountsCopier.copy(statusCounts);
            return this;
        }

        public final Long getDurationInNanoSeconds() {
            return this.durationInNanoSeconds;
        }

        public final void setDurationInNanoSeconds(Long durationInNanoSeconds) {
            this.durationInNanoSeconds = durationInNanoSeconds;
        }

        @Override
        public final Builder durationInNanoSeconds(Long durationInNanoSeconds) {
            this.durationInNanoSeconds = durationInNanoSeconds;
            return this;
        }

        public TestReportSummary build() {
            return new TestReportSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestReportSummary> {
        public Builder total(Integer var1);

        public Builder statusCounts(Map<String, Integer> var1);

        public Builder durationInNanoSeconds(Long var1);
    }
}

