/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codebuild.model.AuthType;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.ServerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportSourceCredentialsRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, ImportSourceCredentialsRequest> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(ImportSourceCredentialsRequest.getter(ImportSourceCredentialsRequest::username)).setter(ImportSourceCredentialsRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final SdkField<String> TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("token").getter(ImportSourceCredentialsRequest.getter(ImportSourceCredentialsRequest::token)).setter(ImportSourceCredentialsRequest.setter(Builder::token)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()}).build();
    private static final SdkField<String> SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serverType").getter(ImportSourceCredentialsRequest.getter(ImportSourceCredentialsRequest::serverTypeAsString)).setter(ImportSourceCredentialsRequest.setter(Builder::serverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverType").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(ImportSourceCredentialsRequest.getter(ImportSourceCredentialsRequest::authTypeAsString)).setter(ImportSourceCredentialsRequest.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<Boolean> SHOULD_OVERWRITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("shouldOverwrite").getter(ImportSourceCredentialsRequest.getter(ImportSourceCredentialsRequest::shouldOverwrite)).setter(ImportSourceCredentialsRequest.setter(Builder::shouldOverwrite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shouldOverwrite").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, TOKEN_FIELD, SERVER_TYPE_FIELD, AUTH_TYPE_FIELD, SHOULD_OVERWRITE_FIELD));
    private final String username;
    private final String token;
    private final String serverType;
    private final String authType;
    private final Boolean shouldOverwrite;

    private ImportSourceCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.token = builder.token;
        this.serverType = builder.serverType;
        this.authType = builder.authType;
        this.shouldOverwrite = builder.shouldOverwrite;
    }

    public final String username() {
        return this.username;
    }

    public final String token() {
        return this.token;
    }

    public final ServerType serverType() {
        return ServerType.fromValue(this.serverType);
    }

    public final String serverTypeAsString() {
        return this.serverType;
    }

    public final AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final Boolean shouldOverwrite() {
        return this.shouldOverwrite;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shouldOverwrite());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSourceCredentialsRequest)) {
            return false;
        }
        ImportSourceCredentialsRequest other = (ImportSourceCredentialsRequest)((Object)obj);
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.token(), other.token()) && Objects.equals(this.serverTypeAsString(), other.serverTypeAsString()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.shouldOverwrite(), other.shouldOverwrite());
    }

    public final String toString() {
        return ToString.builder((String)"ImportSourceCredentialsRequest").add("Username", (Object)this.username()).add("Token", (Object)(this.token() == null ? null : "*** Sensitive Data Redacted ***")).add("ServerType", (Object)this.serverTypeAsString()).add("AuthType", (Object)this.authTypeAsString()).add("ShouldOverwrite", (Object)this.shouldOverwrite()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "token": {
                return Optional.ofNullable(clazz.cast(this.token()));
            }
            case "serverType": {
                return Optional.ofNullable(clazz.cast(this.serverTypeAsString()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "shouldOverwrite": {
                return Optional.ofNullable(clazz.cast(this.shouldOverwrite()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportSourceCredentialsRequest, T> g) {
        return obj -> g.apply((ImportSourceCredentialsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String username;
        private String token;
        private String serverType;
        private String authType;
        private Boolean shouldOverwrite;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSourceCredentialsRequest model) {
            super(model);
            this.username(model.username);
            this.token(model.token);
            this.serverType(model.serverType);
            this.authType(model.authType);
            this.shouldOverwrite(model.shouldOverwrite);
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getToken() {
            return this.token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        @Transient
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final String getServerType() {
            return this.serverType;
        }

        public final void setServerType(String serverType) {
            this.serverType = serverType;
        }

        @Override
        @Transient
        public final Builder serverType(String serverType) {
            this.serverType = serverType;
            return this;
        }

        @Override
        @Transient
        public final Builder serverType(ServerType serverType) {
            this.serverType(serverType == null ? null : serverType.toString());
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        @Transient
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        @Transient
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Boolean getShouldOverwrite() {
            return this.shouldOverwrite;
        }

        public final void setShouldOverwrite(Boolean shouldOverwrite) {
            this.shouldOverwrite = shouldOverwrite;
        }

        @Override
        @Transient
        public final Builder shouldOverwrite(Boolean shouldOverwrite) {
            this.shouldOverwrite = shouldOverwrite;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportSourceCredentialsRequest build() {
            return new ImportSourceCredentialsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportSourceCredentialsRequest> {
        public Builder username(String var1);

        public Builder token(String var1);

        public Builder serverType(String var1);

        public Builder serverType(ServerType var1);

        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder shouldOverwrite(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

